/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.tokens;

import electric.soap.security.IWSSConstants;
import electric.soap.security.tokens.SecurityToken;
import electric.util.string.Base64;
import electric.util.time.XSDDateFormat;
import electric.xml.Element;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Random;

public class UsernameToken
extends SecurityToken
implements IWSSConstants {
    protected String username;
    protected String password;
    protected String passwordType;
    protected String digestedPassword;
    protected String nonce;
    protected String nonceEncoding;
    protected String created;
    protected boolean useNonce;
    protected boolean useTimestamp = true;

    public UsernameToken() {
        this(null, null, "wsse:PasswordText", false);
    }

    public UsernameToken(String username, String password) {
        this(username, password, "wsse:PasswordText", false);
    }

    public UsernameToken(String username, String password, String passwordType) {
        this(username, password, passwordType, false);
    }

    public UsernameToken(String username, String password, String passwordType, boolean useNonce) {
        this.username = username;
        this.passwordType = passwordType;
        this.useNonce = useNonce;
        this.password = password;
    }

    public synchronized void init() {
        if (this.nonceEncoding != null && !this.nonceEncoding.equals("wsse:Base64Binary")) {
            throw new IllegalArgumentException("nonce encoding must be base64");
        }
        if (this.useNonce || this.created != null || this.nonce != null) {
            this.passwordType = "wsse:PasswordDigest";
            if (this.created == null && this.useTimestamp) {
                long timeStamp = System.currentTimeMillis();
                Date dateStamp = new Date(timeStamp);
                XSDDateFormat dateFormat = new XSDDateFormat();
                this.created = dateFormat.format(dateStamp);
            }
            if (this.nonce == null) {
                SecureRandom random = new SecureRandom();
                byte[] digestBytes = new byte[16];
                ((Random)random).nextBytes(digestBytes);
                this.nonce = Base64.toBase64(digestBytes);
            }
        }
        if (this.passwordType.equals("wsse:PasswordDigest")) {
            this.digestedPassword = UsernameToken.digestPassword(this.password, this.nonce, this.created);
        }
    }

    public Element getElement() {
        String id;
        this.init();
        Element tokElement = new Element("wsse", "UsernameToken", "http://schemas.xmlsoap.org/ws/2002/12/secext");
        tokElement.setNamespace("wsse", "http://schemas.xmlsoap.org/ws/2002/12/secext");
        Element usernameElement = new Element("wsse", "Username", "http://schemas.xmlsoap.org/ws/2002/12/secext");
        usernameElement.setText(this.username);
        tokElement.addChild(usernameElement);
        Element passwordElement = new Element("wsse", "Password", "http://schemas.xmlsoap.org/ws/2002/12/secext");
        passwordElement.setAttribute("Type", this.passwordType);
        if (this.passwordType.equals("wsse:PasswordDigest")) {
            passwordElement.setText(this.getDigestedPassword());
        } else {
            passwordElement.setText(this.password);
        }
        tokElement.addChild(passwordElement);
        if (this.nonce != null) {
            Element nonceElement = new Element("wsse", "Nonce", "http://schemas.xmlsoap.org/ws/2002/12/secext");
            nonceElement.setText(this.nonce);
            tokElement.addChild(nonceElement);
        }
        if (this.created != null) {
            Element createdElement = new Element("wsu", "Created", "http://schemas.xmlsoap.org/ws/2002/07/utility");
            createdElement.setText(this.created);
            tokElement.addChild(createdElement);
        }
        if ((id = this.getId()) != null) {
            tokElement.setNamespace("wsu", "http://schemas.xmlsoap.org/ws/2002/07/utility");
            tokElement.setAttribute("wsu", "Id", id);
        }
        return tokElement;
    }

    public void setElement(Element token) throws IllegalArgumentException {
        String username = token.getTextString("Username");
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        this.setUsername(token.getTextString("Username"));
        this.setId(token.getAttributeValue("Id"));
        Element passwordElement = token.getElement("Password");
        Element nonceElement = token.getElement("Nonce");
        Element createdElement = token.getElement("Created");
        if (nonceElement != null) {
            this.nonce = nonceElement.getString();
            this.nonceEncoding = nonceElement.getAttribute("EncodingType");
            if (this.nonceEncoding == null) {
                this.nonceEncoding = "wsse:Base64Binary";
            }
            this.useNonce = true;
        }
        if (passwordElement != null) {
            this.setPassword(passwordElement.getString());
            String passwordType = passwordElement.getAttributeValue("Type");
            if (passwordType == null) {
                passwordType = "wsse:PasswordText";
            }
            this.setPasswordType(passwordType);
            if (passwordType.equals("wsse:PasswordDigest")) {
                this.digestedPassword = passwordElement.getString();
                this.password = null;
            } else {
                this.password = passwordElement.getString();
                this.digestedPassword = null;
            }
        }
        if (createdElement != null) {
            this.setCreated(createdElement.getString());
            this.useNonce = true;
        }
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPasswordType() {
        return this.passwordType;
    }

    public void setPasswordType(String passwordType) {
        if (passwordType == null || !passwordType.equals("wsse:PasswordDigest") && !passwordType.equals("wsse:PasswordText")) {
            throw new IllegalArgumentException("invalid passwordType:" + passwordType);
        }
        this.passwordType = passwordType;
    }

    public String getDigestedPassword() {
        return this.digestedPassword;
    }

    public static String digestPassword(String plainText, String nonce, String created) {
        if (plainText == null) {
            return null;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            if (nonce != null) {
                byte[] nonceBytes = Base64.fromBase64(nonce);
                md.update(nonceBytes);
            }
            if (created != null) {
                md.update(created.getBytes("UTF8"));
            }
            md.update(plainText.getBytes("UTF8"));
            byte[] digest = md.digest();
            String digest64 = Base64.toBase64(digest);
            return digest64;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public boolean isUseNonce() {
        return this.useNonce;
    }

    public void setUseNonce(boolean useNonce) {
        this.useNonce = useNonce;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public String toString() {
        return "UsernameToken(" + this.id + "," + this.username + "," + this.password + ")";
    }
}

