/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.tokens;

import electric.soap.security.IWSSConstants;
import electric.soap.security.tokens.SecurityToken;
import electric.soap.security.tokens.UsernameToken;
import electric.soap.security.tokens.X509v3SecurityToken;
import electric.xml.Element;

public class SecurityTokenFactory
implements IWSSConstants {
    public SecurityToken createToken(Element tokenElement) throws Exception {
        SecurityToken token = null;
        String uri = tokenElement.getNamespace();
        String elementName = tokenElement.getLocalName();
        if (!uri.equals("http://schemas.xmlsoap.org/ws/2002/12/secext")) {
            return null;
        }
        if (elementName.equals("BinarySecurityToken")) {
            String valueType = tokenElement.getAttribute("ValueType");
            if (valueType.equals("wsse:X509v3")) {
                token = new X509v3SecurityToken();
                token.setElement(tokenElement);
            }
        } else if (elementName.equals("UsernameToken")) {
            token = new UsernameToken();
            token.setElement(tokenElement);
        }
        return token;
    }
}

