/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.encryption;

import electric.glue.IGLUELoggingConstants;
import electric.security.IRealm;
import electric.soap.security.IWSSConstants;
import electric.soap.security.encryption.WSSEncryption;
import electric.soap.security.encryption.xml.IXMLEncryptionConstants;
import electric.soap.security.encryption.xml.XMLEncryptionProcessor;
import electric.soap.security.util.SecurityXPathFactory;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.IXPath;
import electric.xml.XPathException;

public class WSSReferenceListHandler
implements IWSSConstants,
IXMLEncryptionConstants,
IGLUELoggingConstants {
    private Element canHandle(Element securityElement) {
        try {
            IXPath xpath = SecurityXPathFactory.createXPath("./xenc:ReferenceList");
            xpath.setNamespace("xenc", "http://www.w3.org/2001/04/xmlenc#");
            Element referenceListElement = xpath.getElement(securityElement);
            return referenceListElement;
        }
        catch (XPathException exception) {
            block2: {
                if (!Log.isLogging(ILoggingConstants.ERROR_EVENT)) break block2;
                Log.log(ILoggingConstants.ERROR_EVENT, "encryption reference list problem", exception);
            }
            return null;
        }
    }

    public WSSEncryption handle(Element envelope, Element securityElement, IRealm realm) {
        WSSEncryption encryptionResult = new WSSEncryption();
        Element referenceListElement = this.canHandle(securityElement);
        if (referenceListElement == null) {
            return null;
        }
        IXPath dataReferencePath = SecurityXPathFactory.createXPath("./xenc:DataReference");
        dataReferencePath.setNamespace("xenc", "http://www.w3.org/2001/04/xmlenc#");
        Elements dataReferenceNodes = dataReferencePath.getElements(referenceListElement);
        while (dataReferenceNodes.hasMoreElements()) {
            Element dataReference = (Element)dataReferenceNodes.nextElement();
            boolean processMore = this.processDataReference(envelope, dataReference, realm, encryptionResult);
            if (processMore) continue;
            return null;
        }
        Element referenceListParent = referenceListElement.getParentElement();
        referenceListParent.removeChild(referenceListElement);
        return encryptionResult;
    }

    private boolean processDataReference(Element envelope, Element dataReference, IRealm realm, WSSEncryption encryptionResult) {
        String dataReferenceURI = dataReference.getAttribute("URI");
        if (dataReferenceURI == null) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, (Object)"encryption reference list, no uri attribute on data reference");
            }
            return false;
        }
        return XMLEncryptionProcessor.decryptAndReplace(envelope.getDocument(), encryptionResult, realm, dataReferenceURI);
    }
}

