/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.security.authenticators;

import electric.glue.IGLUELoggingConstants;
import electric.soap.SOAPMessage;
import electric.soap.security.authenticators.IWSSAuthenticator;
import electric.soap.security.tokens.SecurityToken;
import electric.soap.security.tokens.X509v3SecurityToken;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.util.Vector;

public class X509Authenticator
implements IWSSAuthenticator,
IGLUELoggingConstants {
    private KeyStore trustStore;
    private boolean actAsGuard;
    private String trustStoreURL;

    public X509Authenticator(KeyStore trustStore) {
        this.trustStore = trustStore;
        this.actAsGuard = true;
        this.trustStoreURL = null;
    }

    public X509Authenticator(KeyStore trustStore, String trustStoreURL) {
        this.trustStore = trustStore;
        this.actAsGuard = true;
        this.trustStoreURL = trustStoreURL;
    }

    public X509Authenticator(KeyStore trustStore, boolean actAsGuard) {
        this.trustStore = trustStore;
        this.actAsGuard = actAsGuard;
    }

    public KeyStore getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(KeyStore trustStore, String trustStoreURL) {
        this.trustStore = trustStore;
        this.trustStoreURL = trustStoreURL;
    }

    public String getTrustStoreURL() {
        return this.trustStoreURL;
    }

    public boolean authenticate(SOAPMessage message, Vector tokenList, Vector principalList) {
        int authCount = 0;
        if (this.trustStore == null) {
            return !this.actAsGuard;
        }
        int i = 0;
        while (i < tokenList.size()) {
            SecurityToken token = (SecurityToken)tokenList.elementAt(i);
            if (token instanceof X509v3SecurityToken) {
                X509v3SecurityToken x509Token = (X509v3SecurityToken)token;
                String alias = this.isTrusted(x509Token);
                if (alias != null) {
                    Principal principal = x509Token.getCertificate().getSubjectDN();
                    principalList.addElement(principal);
                    ++authCount;
                } else {
                    if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                        Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)"x509 cert not in trust store, authorization failed");
                    }
                    return false;
                }
            }
            ++i;
        }
        if (this.actAsGuard && authCount == 0) {
            if (Log.isLogging(IGLUELoggingConstants.SECURITY_DETAIL_EVENT)) {
                Log.log(IGLUELoggingConstants.SECURITY_DETAIL_EVENT, (Object)"no x509 tokens authenticated, authorization failed");
            }
            return false;
        }
        return true;
    }

    protected String isTrusted(X509v3SecurityToken token) {
        try {
            return this.trustStore.getCertificateAlias(token.getCertificate());
        }
        catch (KeyStoreException exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, "problem with keystore while verifying x509 certificate:", exception);
            }
            return null;
        }
    }
}

