/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.routing;

import electric.registry.Registry;
import electric.service.IService;
import electric.soap.ISOAPConstants;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPMessage;
import electric.soap.actor.SOAPActors;
import electric.soap.handlers.chain.ChainedSOAPHandler;
import electric.soap.routing.IRoutingConstants;
import electric.soap.routing.RoutingException;
import electric.util.Context;
import electric.util.UUID;
import electric.util.array.ArrayUtil;
import electric.xml.Element;
import electric.xml.Elements;
import java.rmi.RemoteException;
import java.util.Enumeration;

public class RoutingHandler
extends ChainedSOAPHandler
implements IRoutingConstants,
ISOAPConstants {
    private IService service;

    public RoutingHandler(ISOAPHandler nextHandler, IService service) {
        super(nextHandler);
        this.service = service;
    }

    public String[] getActors() {
        String[] actors = Registry.getAllPaths(this.service);
        Enumeration endpointEnumeration = this.service.getContext().getProperties("endpoint");
        String[] endpoints = new String[]{};
        while (endpointEnumeration.hasMoreElements()) {
            endpoints = (String[])ArrayUtil.addElement(endpoints, endpointEnumeration.nextElement());
        }
        endpoints = (String[])ArrayUtil.addElements(endpoints, actors);
        SOAPActors soapActors = SOAPActors.getDefaultActors();
        int i = 0;
        while (i < endpoints.length) {
            endpoints[i] = soapActors.getName(endpoints[i]);
            ++i;
        }
        return endpoints;
    }

    public SOAPMessage handle(SOAPMessage request, Context context) throws RemoteException, SecurityException {
        Element outHeader;
        if (request.getOptimizations().getEnvelopeOmission()) {
            return this.nextHandler.handle(request, context);
        }
        Element inHeader = this.getPathHeader(request);
        if (inHeader == null) {
            return this.nextHandler.handle(request, context);
        }
        String[] endpoints = this.getActors();
        this.checkHeaders(endpoints, inHeader);
        context.addProperty("understood", inHeader);
        SOAPMessage response = this.nextHandler.handle(request, context);
        if (response.getOptimizations().getEnvelopeOmission()) {
            response.deoptimize();
        }
        if ((outHeader = this.getPathHeader(response)) == null) {
            this.setOutHeader(response, inHeader);
        }
        return response;
    }

    private Element getPathHeader(SOAPMessage request) {
        Element header = request.getHeaderElement("http://schemas.xmlsoap.org/rp", "path");
        if (header == null) {
            header = request.getHeaderElement("http://schemas.xmlsoap.org/rp/", "path");
        }
        return header;
    }

    private void setOutHeader(SOAPMessage response, Element inHeader) {
        Element out = response.addHeader();
        String endpoint = this.getActors()[0];
        String namespace = inHeader.getNamespace();
        Element rev = inHeader.getElement("rev");
        Element id = inHeader.getElement("id");
        out.setNamespace("rp", namespace);
        Element path = out.addElement("rp", "path");
        path.addElement("rp", "from").setText(endpoint);
        path.addElement("rp", "id").setText("uuid:" + new UUID().getKey());
        path.addElement("rp", "rev").addElement("rp", "via").setText(endpoint);
        if (id != null) {
            path.addElement("rp", "relatesTo").setText(id.getText());
        }
    }

    private void checkHeaders(String[] endpoints, Element header) throws RoutingException {
        Element to = header.getElement("to");
        Element fwd = header.getElement("fwd");
        if (to == null) {
            if (fwd == null) {
                this.throwEndpointNotFoundException(endpoints[0]);
            } else {
                Elements vias = fwd.getElements("via");
                if (vias.size() == 0) {
                    this.throwEndpointNotFoundException(endpoints[0]);
                } else if (vias.size() > 1) {
                    this.throwMultipleEndpointException(endpoints[0]);
                }
                if (!ArrayUtil.contains(vias.next().getTrimTextString(), endpoints)) {
                    this.throwEndpointNotFoundException(vias.current().getTrimTextString());
                }
            }
        } else {
            fwd = header.getElement("fwd");
            if (fwd != null && fwd.getElements("via").size() != 0) {
                this.throwMultipleEndpointException(endpoints[0]);
            }
        }
    }

    public void throwEndpointNotFoundException(String endpoint) throws RoutingException {
        RoutingException exception = new RoutingException("Header does not contain this endpoint.");
        exception.setSOAPActor(endpoint);
        exception.setSOAPCode("Client");
        exception.setCode(700);
        throw exception;
    }

    public void throwMultipleEndpointException(String endpoint) throws RoutingException {
        RoutingException exception = new RoutingException("This is an endpoint, not an intermediary.  Additional routes supplied.");
        exception.setSOAPActor(endpoint);
        exception.setSOAPCode("Client");
        exception.setCode(800);
        throw exception;
    }
}

