/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.routing;

import electric.soap.SOAPException;
import electric.soap.SOAPMessage;
import electric.soap.routing.IRoutingConstants;
import electric.xml.Element;

public class RoutingException
extends SOAPException
implements IRoutingConstants {
    private int code;
    private String endpoint;
    private String reason;
    private boolean useAltNamespace;

    public RoutingException(String message, String soapCode, String actor, Element detail) {
        super(message, soapCode, actor, detail);
    }

    public RoutingException(String message, String soapCode, String actor) {
        super(message, soapCode);
        this.setSOAPActor(actor);
    }

    public RoutingException(String message) {
        super(message);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public boolean isUseAltNamespace() {
        return this.useAltNamespace;
    }

    public void setUseAltNamespace(boolean useAltNamespace) {
        this.useAltNamespace = useAltNamespace;
    }

    public SOAPMessage getSOAPMessage() {
        SOAPMessage message = new SOAPMessage(this);
        Element header = message.addHeader();
        Element path = header.addElement("path");
        String namespace = this.useAltNamespace ? "http://schemas.xmlsoap.org/rp/" : "http://schemas.xmlsoap.org/rp";
        String prefix = path.getPrefix(namespace, "rp");
        path.setPrefix(prefix);
        Element fault = path.addElement(prefix, "fault");
        fault.addElement(prefix, "code").setInt(this.code);
        fault.addElement(prefix, "reason").setText(this.reason);
        fault.addElement(prefix, "endpoint").setText(this.endpoint);
        return message;
    }
}

