/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.http.reference;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.http.InboundHTTPResponse;
import electric.http.OutboundHTTPRequest;
import electric.soap.ISOAPConstants;
import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.array.ByteArray;
import electric.util.dime.DIMEBuilder;
import electric.util.dime.DIMEReader;
import electric.util.dime.IDIMEConstants;
import electric.util.http.IHTTPConstants;
import electric.util.io.ISource;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.MIMEData;
import electric.util.mime.MemoryDataHandler;
import electric.wsdl.WSDL;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;

public class ClientDIME
implements IGLUEContextConstants,
IDIMEConstants,
IHTTPConstants,
ISOAPConstants,
IGLUELoggingConstants {
    private static boolean enabled = false;
    private static boolean allowEnable = true;

    public static void populateRequest(SOAPMessage soapRequest, OutboundHTTPRequest httpRequest, WSDL wsdl, Enumeration unreferencedAttachments) throws IOException {
        if (!ClientDIME.isEnabled()) {
            return;
        }
        MIMEData[] attachments = soapRequest.getAttachments();
        if (attachments == null) {
            attachments = new MIMEData[]{};
        }
        while (unreferencedAttachments != null && unreferencedAttachments.hasMoreElements()) {
            MIMEData unrefedAttachment = (MIMEData)unreferencedAttachments.nextElement();
            attachments = (MIMEData[])ArrayUtil.addElement(attachments, unrefedAttachment);
        }
        ByteArray byteArray = soapRequest.getByteArray(wsdl);
        MIMEData bodyData = new MIMEData(byteArray.getBytes());
        bodyData.setContentType("http://schemas.xmlsoap.org/soap/envelope/");
        bodyData.headers.setIntHeader("typeFormat", 2);
        DIMEBuilder builder = new DIMEBuilder(bodyData, attachments);
        ISource source = builder.getSource();
        httpRequest.setSource(source);
        httpRequest.setContentType("application/dime");
    }

    public static SOAPMessage readResponse(InboundHTTPResponse httpResponse, SOAPOptimizations optimizations, Context proxyContext, WSDL wsdl) throws IOException, ParseException {
        SOAPMessage soapMessage = new SOAPMessage();
        InputStream httpInput = httpResponse.getInputStream();
        DIMEReader dimeReader = new DIMEReader(httpInput, proxyContext);
        MIMEData startPart = dimeReader.read(new MemoryDataHandler());
        soapMessage.setBytes(startPart.getBytes(), optimizations, wsdl);
        MIMEData[] attachments = new MIMEData[]{};
        while (dimeReader.hasMoreElements()) {
            attachments = (MIMEData[])ArrayUtil.addElement(attachments, dimeReader.read());
        }
        soapMessage.setAttachments(attachments);
        Context threadContext = Context.thread();
        threadContext.removeProperties("responseUnreferencedAttachments");
        int i = 0;
        while (i < attachments.length) {
            MIMEData otherPart = attachments[i];
            threadContext.addProperty("responseUnreferencedAttachments", otherPart);
            ++i;
        }
        return soapMessage;
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("DIME cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
    }

    public static final boolean isEnabled() {
        return enabled;
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"DIME disabled");
    }
}

