/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.http.handler;

import electric.servlet.util.HTTPServletUtil;
import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.util.Context;
import electric.util.array.ByteArray;
import electric.util.http.IHTTPConstants;
import electric.util.io.Streams;
import electric.util.mime.MIMEBuilder;
import electric.util.mime.MIMEData;
import electric.util.mime.MIMEHeaders;
import electric.util.mime.MIMEReader;
import electric.util.mime.MemoryDataHandler;
import electric.wsdl.WSDL;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerMIME
implements IHTTPConstants {
    public static SOAPMessage readRequest(HttpServletRequest httpRequest, SOAPOptimizations optimizations, Context messageContext, WSDL wsdl, Vector unreferencedAttachments) throws IOException, ParseException {
        String contentType = httpRequest.getContentType();
        String location = httpRequest.getHeader("Content-Location");
        ServletInputStream httpInput = httpRequest.getInputStream();
        MIMEReader mimeReader = new MIMEReader((InputStream)httpInput, contentType, location, messageContext, new MemoryDataHandler());
        MIMEData startPart = mimeReader.getStartPart();
        byte[] bytes = Streams.readFully(startPart.getInputStream(), startPart.getContentLength());
        SOAPMessage soapMessage = new SOAPMessage();
        soapMessage.setBytes(bytes, optimizations, wsdl);
        soapMessage.setAttachments(mimeReader.getOtherParts());
        return soapMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResponse(SOAPMessage soapResponse, HttpServletRequest httpRequest, HttpServletResponse httpResponse, WSDL wsdl) throws IOException {
        MIMEHeaders headers = new MIMEHeaders();
        headers.setHeader("Content-Type", "text/xml; charset=UTF-8");
        MIMEData[] attachments = soapResponse.getAttachments();
        ByteArray byteArray = soapResponse.getByteArray(wsdl);
        MIMEBuilder builder = new MIMEBuilder(attachments, byteArray, headers);
        httpResponse.setContentType(builder.getContentType());
        InputStream input = builder.getInputStream();
        int contentLength = builder.getContentLength();
        try {
            HTTPServletUtil.writeContent(httpRequest, httpResponse, input, contentLength);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            input.close();
            throw throwable;
        }
        input.close();
    }
}

