/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.http.handler;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.servlet.util.HTTPServletUtil;
import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.util.dime.DIMEBuilder;
import electric.util.dime.DIMEReader;
import electric.util.dime.IDIMEConstants;
import electric.util.http.IHTTPConstants;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.MIMEData;
import electric.util.mime.MemoryDataHandler;
import electric.wsdl.WSDL;
import electric.xml.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServerDIME
implements IGLUEContextConstants,
IHTTPConstants,
IDIMEConstants,
IGLUELoggingConstants {
    private static boolean enabled = false;
    private static boolean allowEnable = true;

    public static SOAPMessage readRequest(HttpServletRequest httpRequest, SOAPOptimizations optimizations, Context messageContext, WSDL wsdl, Vector unreferencedAttachments) throws IOException, ParseException {
        SOAPMessage soapMessage = new SOAPMessage();
        ServletInputStream httpInput = httpRequest.getInputStream();
        DIMEReader dimeReader = new DIMEReader((InputStream)httpInput, messageContext);
        MIMEData startPart = dimeReader.read(new MemoryDataHandler());
        soapMessage.setBytes(startPart.getBytes(), optimizations, wsdl);
        MIMEData[] attachments = new MIMEData[]{};
        while (dimeReader.hasMoreElements()) {
            attachments = (MIMEData[])ArrayUtil.addElement(attachments, dimeReader.read());
        }
        soapMessage.setAttachments(attachments);
        Context threadContext = Context.thread();
        int i = 0;
        while (i < attachments.length) {
            MIMEData attachment = attachments[i];
            threadContext.addProperty("unreferencedAttachments", attachment);
            ++i;
        }
        return soapMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResponse(SOAPMessage soapResponse, HttpServletRequest httpRequest, HttpServletResponse httpResponse, WSDL wsdl) throws IOException {
        MIMEData[] attachments = soapResponse.getAttachments();
        if (attachments == null) {
            attachments = new MIMEData[]{};
        }
        Context threadContext = Context.thread();
        Enumeration unreferencedAttachments = threadContext.getProperties("responseUnreferencedAttachments");
        while (unreferencedAttachments.hasMoreElements()) {
            MIMEData unreferencedAttachment = (MIMEData)unreferencedAttachments.nextElement();
            attachments = (MIMEData[])ArrayUtil.addElement(attachments, unreferencedAttachment);
        }
        threadContext.removeProperties("responseUnreferencedAttachments");
        MIMEData bodyData = new MIMEData(soapResponse.getByteArray((WSDL)wsdl).bytes);
        bodyData.setContentType("http://schemas.xmlsoap.org/soap/envelope/");
        bodyData.headers.setIntHeader("typeFormat", 2);
        DIMEBuilder builder = new DIMEBuilder(bodyData, attachments);
        httpResponse.setContentType("application/dime");
        InputStream input = builder.getInputStream();
        long contentLength = builder.getContentLength();
        try {
            HTTPServletUtil.writeContent(httpRequest, httpResponse, input, (int)contentLength);
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            input.close();
            throw throwable;
        }
        input.close();
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("DIME cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
    }

    public static final boolean isEnabled() {
        return enabled;
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"DIME disabled");
    }
}

