/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.http.handler;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.glue.context.ThreadContext;
import electric.registry.Registry;
import electric.server.http.IServletHandler;
import electric.server.http.ServletServer;
import electric.service.IService;
import electric.servlet.util.HTTPServletUtil;
import electric.soap.ISOAPConstants;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPException;
import electric.soap.SOAPMessage;
import electric.soap.SOAPOptimizations;
import electric.soap.handlers.SOAPHandlerFactories;
import electric.soap.http.handler.ServerDIME;
import electric.soap.http.handler.ServerMIME;
import electric.soap.http.handler.ServerNoAttachments;
import electric.util.Context;
import electric.util.XURL;
import electric.util.array.ByteArray;
import electric.util.dime.IDIMEConstants;
import electric.util.http.HTTPUtil;
import electric.util.http.IHTTPConstants;
import electric.util.log.Log;
import electric.util.mime.MIMEData;
import electric.util.mime.MIMEHeaders;
import electric.util.string.Strings;
import electric.wsdl.WSDL;
import electric.xml.ParseException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class HTTPToSOAP
implements IServletHandler,
IHTTPConstants,
ISOAPConstants,
IGLUELoggingConstants,
IGLUEContextConstants,
IDIMEConstants {
    static /* synthetic */ Class class$electric$soap$http$handler$HTTPToSOAP;

    public static void startup() {
        ServletServer.addHandlerType(class$electric$soap$http$handler$HTTPToSOAP == null ? (class$electric$soap$http$handler$HTTPToSOAP = HTTPToSOAP.class$("electric.soap.http.handler.HTTPToSOAP")) : class$electric$soap$http$handler$HTTPToSOAP);
    }

    public void init(ServletServer server) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean service(ServletServer server, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (server.getRoot() == null) {
            return false;
        }
        String contentType = httpRequest.getContentType();
        boolean multipart = HTTPUtil.isMultipart(contentType);
        String soapVersion = "http://schemas.xmlsoap.org/soap/envelope/";
        if (contentType != null && contentType.startsWith("application/soap+xml")) {
            soapVersion = "http://www.w3.org/2003/05/soap-envelope";
        } else if (httpRequest.getHeader("SOAPAction") == null && !multipart) {
            return false;
        }
        if (Log.isLogging(IGLUELoggingConstants.HTTP_EVENT)) {
            Log.log(IGLUELoggingConstants.HTTP_EVENT, (Object)("request from " + httpRequest.getRemoteHost() + "\n" + httpRequest));
        }
        String optimized = httpRequest.getHeader("GLUEOptimized");
        SOAPOptimizations optimizations = SOAPOptimizations.getSOAPOptimizations(optimized);
        String path = Strings.splice(server.getRoot(), httpRequest.getPathInfo());
        Object target = null;
        SOAPMessage soapRequest = null;
        WSDL wsdl = null;
        Context serviceContext = null;
        try {
            target = Registry.get(path);
            if (target == null) {
                httpResponse.sendError(500, "service not found");
                return false;
            }
            if (target instanceof IService) {
                wsdl = ((IService)target).getWSDL();
            }
            serviceContext = target instanceof IService ? ((IService)target).getContext() : null;
            Vector unreferencedAttachments = new Vector();
            soapRequest = this.readRequest(httpRequest, optimizations, contentType, serviceContext, multipart, wsdl, unreferencedAttachments, soapVersion);
            int i = 0;
            while (i < unreferencedAttachments.size()) {
                MIMEData attachment = (MIMEData)unreferencedAttachments.elementAt(i);
                ThreadContext.addProperty("unreferencedAttachments", attachment);
                ++i;
            }
            this.readMIMEHeaders(soapRequest, httpRequest);
        }
        catch (ParseException exception) {
            this.writeException(exception, httpRequest, httpResponse, wsdl, 400);
            ThreadContext.removeProperties("unreferencedAttachments");
            return true;
        }
        catch (Throwable throwable) {
            this.writeException(throwable, httpRequest, httpResponse, wsdl, 500);
            ThreadContext.removeProperties("unreferencedAttachments");
            return true;
        }
        try {
            XURL endpoint = new XURL(null, null, -1, path, null);
            IService service = (IService)target;
            ISOAPHandler handlerChain = SOAPHandlerFactories.getSOAPHandlerChain(service);
            Context messageContext = new Context();
            messageContext.setProperty("queryString", httpRequest.getQueryString());
            messageContext.setProperty("endpoint", endpoint);
            messageContext.setProperty("transportSource", httpRequest.getRemoteAddr());
            SOAPMessage soapResponse = handlerChain.handle(soapRequest, messageContext);
            this.writeResponse(soapResponse, httpRequest, httpResponse, wsdl, serviceContext);
            Object var20_22 = null;
        }
        catch (Throwable throwable) {
            Object var20_23 = null;
            ThreadContext.removeProperties("unreferencedAttachments");
            throw throwable;
        }
        ThreadContext.removeProperties("unreferencedAttachments");
        return true;
    }

    private SOAPMessage readRequest(HttpServletRequest httpRequest, SOAPOptimizations optimizations, String contentType, Context serviceContext, boolean multipart, WSDL wsdl, Vector unreferencedAttachments, String soapVersion) throws IOException, ParseException {
        if (!multipart) {
            return ServerNoAttachments.readRequest(httpRequest, optimizations, serviceContext, wsdl, unreferencedAttachments, soapVersion);
        }
        if (HTTPUtil.isDIMEMultipart(contentType)) {
            return ServerDIME.readRequest(httpRequest, optimizations, serviceContext, wsdl, unreferencedAttachments);
        }
        return ServerMIME.readRequest(httpRequest, optimizations, serviceContext, wsdl, unreferencedAttachments);
    }

    private void readMIMEHeaders(SOAPMessage soapRequest, HttpServletRequest httpRequest) {
        Enumeration names = httpRequest.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration headers = httpRequest.getHeaders(name);
            while (headers.hasMoreElements()) {
                soapRequest.addMIMEHeader(name, (String)headers.nextElement());
            }
        }
    }

    public boolean hasUnreferencedAttachments(String directionFlag) {
        return ThreadContext.getProperty(directionFlag) != null;
    }

    private void writeResponse(SOAPMessage soapResponse, HttpServletRequest httpRequest, HttpServletResponse httpResponse, WSDL wsdl, Context serviceContext) throws IOException {
        int response = soapResponse.isException() ? 500 : 200;
        this.setStatusAndHeaders(soapResponse, httpResponse, response);
        if (!soapResponse.hasAttachments() && !this.hasUnreferencedAttachments("responseUnreferencedAttachments")) {
            ServerNoAttachments.writeResponse(soapResponse, httpRequest, httpResponse, wsdl);
        } else if ("dime".equalsIgnoreCase(soapResponse.getAttachmentStyle())) {
            ServerDIME.writeResponse(soapResponse, httpRequest, httpResponse, wsdl);
        } else {
            ServerMIME.writeResponse(soapResponse, httpRequest, httpResponse, wsdl);
        }
    }

    private void writeException(Throwable throwable, HttpServletRequest httpRequest, HttpServletResponse httpResponse, WSDL wsdl, int responseCode) throws IOException {
        SOAPMessage soapResponse = new SOAPMessage();
        soapResponse.setException(new SOAPException(throwable, "Client"));
        this.setStatusAndHeaders(soapResponse, httpResponse, responseCode);
        ByteArray byteArray = soapResponse.getByteArray(wsdl);
        HTTPServletUtil.writeContent(httpRequest, httpResponse, byteArray);
    }

    private void setStatusAndHeaders(SOAPMessage soapResponse, HttpServletResponse httpResponse, int responseStatus) {
        httpResponse.setStatus(responseStatus);
        this.addTransportHeaders(soapResponse, httpResponse);
        if (soapResponse.getOptimizations().hasOptimizations()) {
            httpResponse.setHeader("GLUEOptimized", soapResponse.getOptimizations().getDescription());
        } else {
            httpResponse.setDateHeader("Date", System.currentTimeMillis());
            httpResponse.setContentType("text/xml; charset=UTF-8");
            httpResponse.setHeader("Server", IHTTPConstants.SERVER_TYPE);
        }
    }

    private void addTransportHeaders(SOAPMessage soapResponse, HttpServletResponse httpResponse) {
        MIMEHeaders headers = soapResponse.getMIMEHeaders();
        if (headers == null) {
            return;
        }
        Enumeration names = headers.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Enumeration values = headers.getHeaders(name);
            while (values.hasMoreElements()) {
                httpResponse.addHeader(name, (String)values.nextElement());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

