/*
 * Decompiled with CFR 0.152.
 */
package electric.soap;

import electric.glue.IGLUELoggingConstants;
import electric.soap.SOAPException;
import electric.soap.wsdl.WSDLTagData;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.wsdl.WSDL;
import electric.xml.Element;

public final class SOAPOptimizations
implements IGLUELoggingConstants {
    private static boolean optimizationsEnabled;
    private static boolean allowEnable;
    public static final SOAPOptimizations DEFAULT;
    public static final SOAPOptimizations NONE;
    public static final SOAPOptimizations CONFIGURED;
    private static boolean tagSubstitutionEnabled;
    private static boolean typeOmissionEnabled;
    private static boolean envelopeOmissionEnabled;
    private static boolean hrefInliningEnabled;
    private boolean tagSubstitution;
    private boolean typeOmission;
    private boolean envelopeOmission;
    private boolean hrefInlining;
    private long hashCode;
    private String description;

    public SOAPOptimizations() {
    }

    public SOAPOptimizations(String description) {
        int tagIndex = description.indexOf("tag");
        if (tagIndex != -1) {
            tagIndex += 4;
            StringBuffer buffer = new StringBuffer();
            while (tagIndex < description.length()) {
                char ch;
                if (!Character.isDigit(ch = description.charAt(tagIndex++))) break;
                buffer.append(ch);
            }
            this.hashCode = Integer.parseInt(buffer.toString());
            this.setTagSubstitution(true);
        }
        if (description.indexOf("env") != -1) {
            this.setEnvelopeOmission(true);
        }
        if (description.indexOf("href") != -1) {
            this.setHrefInlining(true);
        }
        if (typeOmissionEnabled) {
            this.setTypeOmission(true);
        }
        this.updateDescription();
    }

    public SOAPOptimizations(SOAPOptimizations optimizations, long hashCode) {
        this.tagSubstitution = optimizations.tagSubstitution;
        this.typeOmission = optimizations.typeOmission;
        this.envelopeOmission = optimizations.envelopeOmission;
        this.hrefInlining = optimizations.hrefInlining;
        this.hashCode = hashCode;
        this.updateDescription();
    }

    public String toString() {
        return "SOAPOptimizations( " + this.getDescription() + ", hashCode=" + this.hashCode + " )";
    }

    public boolean hasOptimizations() {
        return this.description != null;
    }

    public void setTagSubstitution(boolean flag) {
        this.tagSubstitution = flag;
        this.updateDescription();
    }

    public boolean getTagSubstitution() {
        return this.tagSubstitution;
    }

    public void setHrefInlining(boolean flag) {
        this.hrefInlining = flag;
        this.updateDescription();
    }

    public boolean getHrefInlining() {
        return this.hrefInlining;
    }

    public void setEnvelopeOmission(boolean flag) {
        this.envelopeOmission = flag;
        this.updateDescription();
    }

    public boolean getEnvelopeOmission() {
        return this.envelopeOmission;
    }

    public void setTypeOmission(boolean flag) {
        this.typeOmission = flag;
    }

    public boolean getTypeOmission() {
        return this.typeOmission;
    }

    public void clearOptimizations() {
        this.tagSubstitution = false;
        this.typeOmission = false;
        this.envelopeOmission = false;
        this.hrefInlining = false;
        this.updateDescription();
    }

    public String getDescription() {
        return this.description;
    }

    private synchronized void updateDescription() {
        this.description = null;
        if (this.hrefInlining) {
            this.append("href");
        }
        if (this.tagSubstitution) {
            this.append("tag=" + this.hashCode);
        }
        if (this.envelopeOmission) {
            this.append("env");
        }
    }

    private void append(String string) {
        this.description = this.description == null ? string : this.description + "," + string;
    }

    public long getHashCode() {
        return this.hashCode;
    }

    public static void enable() {
        if (optimizationsEnabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("SOAP Optimizations cannot be enabled once it is disabled");
        }
        optimizationsEnabled = Enabler.enable();
    }

    public static boolean isEnabled() {
        return optimizationsEnabled;
    }

    private static void checkOptimizationsEnabled() throws IllegalArgumentException {
        if (!optimizationsEnabled) {
            throw new IllegalArgumentException("optimizations are not enabled. this feature is available only in GLUE Professional");
        }
    }

    public static void disable() {
        optimizationsEnabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"SOAP Optimizations feature disabled");
    }

    public static void setTagSubstitutionEnabled(boolean flag) {
        SOAPOptimizations.checkOptimizationsEnabled();
        tagSubstitutionEnabled = flag;
        CONFIGURED.setTagSubstitution(flag);
    }

    public static boolean isTagSubstitutionEnabled() {
        return tagSubstitutionEnabled;
    }

    public static void setTypeOmissionEnabled(boolean flag) {
        SOAPOptimizations.checkOptimizationsEnabled();
        typeOmissionEnabled = flag;
        CONFIGURED.setTypeOmission(flag);
        DEFAULT.setTypeOmission(flag);
    }

    public static boolean isTypeOmissionEnabled() {
        return typeOmissionEnabled;
    }

    public static void setEnvelopeOmissionEnabled(boolean flag) {
        SOAPOptimizations.checkOptimizationsEnabled();
        envelopeOmissionEnabled = flag;
        CONFIGURED.setEnvelopeOmission(flag);
    }

    public static boolean isEnvelopeOmissionEnabled() {
        return envelopeOmissionEnabled;
    }

    public static void setHrefInliningEnabled(boolean flag) {
        SOAPOptimizations.checkOptimizationsEnabled();
        hrefInliningEnabled = flag;
        CONFIGURED.setHrefInlining(flag);
    }

    public static boolean isHrefInliningEnabled() {
        return hrefInliningEnabled;
    }

    public static boolean hasServerSideOptimizationsEnabled() {
        return tagSubstitutionEnabled || envelopeOmissionEnabled || hrefInliningEnabled;
    }

    public static void disableAllOptimizations() {
        tagSubstitutionEnabled = false;
        typeOmissionEnabled = false;
        envelopeOmissionEnabled = false;
        hrefInliningEnabled = false;
        CONFIGURED.clearOptimizations();
        DEFAULT.clearOptimizations();
    }

    public void stripDisabled() {
        if (!tagSubstitutionEnabled) {
            this.tagSubstitution = false;
            this.hashCode = 0L;
        }
        if (!typeOmissionEnabled) {
            this.typeOmission = false;
        }
        if (!envelopeOmissionEnabled) {
            this.envelopeOmission = false;
        }
        if (!hrefInliningEnabled) {
            this.hrefInlining = false;
        }
        this.updateDescription();
    }

    public static SOAPOptimizations getSOAPOptimizations(String description) {
        if (description == null) {
            return DEFAULT;
        }
        return new SOAPOptimizations(description);
    }

    public static SOAPOptimizations getSOAPOptimizations(Element optimizationsElement) {
        SOAPOptimizations optimizations = new SOAPOptimizations();
        if ("1".equals(optimizationsElement.getAttributeValue("tag"))) {
            optimizations.setTagSubstitution(true);
        }
        if ("1".equals(optimizationsElement.getAttributeValue("href"))) {
            optimizations.setHrefInlining(true);
        }
        if ("1".equals(optimizationsElement.getAttributeValue("env"))) {
            optimizations.setEnvelopeOmission(true);
        }
        return optimizations;
    }

    public static SOAPOptimizations getServerSideSOAPOptimizations() {
        if (!SOAPOptimizations.hasServerSideOptimizationsEnabled()) {
            return null;
        }
        SOAPOptimizations optimizations = new SOAPOptimizations();
        if (SOAPOptimizations.isTagSubstitutionEnabled()) {
            optimizations.setTagSubstitution(true);
        }
        if (SOAPOptimizations.isHrefInliningEnabled()) {
            optimizations.setHrefInlining(true);
        }
        if (SOAPOptimizations.isEnvelopeOmissionEnabled()) {
            optimizations.setEnvelopeOmission(true);
        }
        return optimizations;
    }

    public void writeSOAPOptimizations(Element optimizationsElement) {
        if (this.getTagSubstitution()) {
            optimizationsElement.setAttribute("tag", "1");
        }
        if (this.getHrefInlining()) {
            optimizationsElement.setAttribute("href", "1");
        }
        if (this.getEnvelopeOmission()) {
            optimizationsElement.setAttribute("env", "1");
        }
    }

    public static void checkOptimizations(SOAPOptimizations optimizations, WSDL wsdl) throws SOAPException {
        long serverHashCode;
        if (!optimizations.getTagSubstitution()) {
            return;
        }
        long clientHashCode = optimizations.getHashCode();
        if (clientHashCode != (serverHashCode = WSDLTagData.getTagData(wsdl).getHashCode())) {
            throw new SOAPException("client WSDL does not match server WSDL: reload WSDL or disable tag substitution on the server");
        }
    }

    static {
        allowEnable = true;
        DEFAULT = new SOAPOptimizations();
        NONE = new SOAPOptimizations();
        CONFIGURED = new SOAPOptimizations();
    }
}

