/*
 * Decompiled with CFR 0.152.
 */
package electric.service.object;

import electric.directory.DirectoryException;
import electric.directory.IContainer;
import electric.glue.context.ThreadContext;
import electric.proxy.IReference;
import electric.registry.Registry;
import electric.service.IActivationConstants;
import electric.service.INeedInstantiator;
import electric.service.IService;
import electric.service.descriptor.MethodDescriptor;
import electric.service.reference.ReferenceFactories;
import electric.servlet.cookies.Cookies;
import electric.util.Context;
import electric.util.Value;
import electric.util.WrappedException;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.classloader.IHasClassLoader;
import electric.util.constructor.Constructor;
import electric.util.constructor.IInstantiator;
import electric.util.java.JavaInterface;
import electric.util.reflect.Invocation;
import electric.util.reflect.JavaComment;
import electric.util.reflect.Reflect;
import electric.wsdl.WSDL;
import electric.wsdl.generator.WSDLGenerator;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ObjectService
implements IService,
IContainer,
IReference,
IHasClassLoader,
INeedInstantiator {
    private static final Class[] EXCLUDED = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ObjectService.class$("java.lang.Object")) : class$java$lang$Object};
    private static final String[] NO_ARGS = new String[0];
    private Context context = new Context();
    private Object object;
    private String className;
    private Class javaClass;
    private String description;
    private int mode = -1;
    private WSDL wsdl;
    private String path;
    private Class[] interfaces;
    private MethodDescriptor[] methods;
    private IInstantiator instantiator;
    private IReference referenceChain;
    static /* synthetic */ Class class$java$lang$Object;

    protected ObjectService() {
    }

    public ObjectService(Object object) {
        this.setObject(object);
        this.setDescription("instance of " + object.getClass());
    }

    public ObjectService(String className) {
        this.className = className;
        this.instantiator = new Constructor(className, NO_ARGS);
        this.setDescription("instance of " + className);
    }

    public String toString() {
        return "ObjectService( className=" + this.getClassName() + ", mode=" + this.getModeString() + " )";
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public synchronized Context getContext() {
        return this.context;
    }

    public synchronized void setContext(Context context) {
        this.context = context;
    }

    public synchronized String getPath() {
        if (this.path != null) {
            return this.path;
        }
        this.path = Registry.getPath("/", (Object)this);
        return this.path;
    }

    public synchronized String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        this.description = this.context.getStringProperty("description");
        if (this.description == null) {
            this.description = this.getDefaultDescription();
        }
        return this.description;
    }

    public synchronized void setDescription(String description) {
        this.description = description;
        this.context.setProperty("description", description);
    }

    public String getDefaultDescription() {
        try {
            Class type = this.instantiator.getReturnType();
            Method[] methods = type.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                JavaComment comment;
                JavaInterface javaInterface;
                Method match = Reflect.getInterfaceMethod(methods[i]);
                if (match != null && (javaInterface = JavaInterface.getInterface(match.getDeclaringClass())) != null && (comment = javaInterface.getComment()) != null && comment.getText() != null) {
                    return comment.getText().trim();
                }
                ++i;
            }
        }
        catch (ClassNotFoundException exception) {
            // empty catch block
        }
        return this.getClassName() + " web service";
    }

    public synchronized Object getObject() {
        try {
            switch (this.getMode()) {
                case 0: {
                    return this.getApplicationObject();
                }
                case 1: {
                    return this.getRequestObject();
                }
                case 2: {
                    return this.getSessionObject();
                }
            }
            return null;
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
    }

    private Object getApplicationObject() throws InstantiationException {
        if (this.object == null) {
            this.object = this.newInstance();
        }
        return this.object;
    }

    private Object getRequestObject() throws InstantiationException {
        return this.newInstance();
    }

    private Object getSessionObject() throws IllegalAccessException, InstantiationException {
        HttpSession session = this.getSession();
        Object object = session.getAttribute(this.getPath());
        if (object == null) {
            object = this.newInstance();
            session.setAttribute(this.getPath(), object);
        }
        return object;
    }

    private HttpSession getSession() throws IllegalAccessException, InstantiationException {
        HttpServletRequest request = ThreadContext.getHttpRequest();
        if (request == null) {
            throw new InstantiationException("unable to obtain HTTP request. services with session activation can be invoked only via HTTP");
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            return session;
        }
        Cookie cookie = Cookies.getCookie(request.getCookies(), "TME-GLUE-Session");
        if (cookie != null) {
            HttpServletResponse response = ThreadContext.getHttpResponse();
            cookie.setMaxAge(0);
            response.addCookie(cookie);
            throw new IllegalAccessException("session has expired. cannot create new session object");
        }
        return request.getSession(true);
    }

    private Object newInstance() throws InstantiationException {
        try {
            return this.instantiator.newInstance();
        }
        catch (Throwable throwable) {
            throw new InstantiationException(throwable.toString());
        }
    }

    public void setInstantiator(IInstantiator instantiator) {
        this.instantiator = instantiator;
    }

    public IInstantiator getInstantiator() {
        return this.instantiator;
    }

    protected void setObject(Object object) {
        if (object instanceof Class) {
            this.setClass((Class)object);
        } else {
            this.setClass(object.getClass());
            this.object = object;
        }
    }

    public synchronized String getClassName() {
        if (this.className != null) {
            return this.className;
        }
        this.className = this.context.getStringProperty("className");
        return this.className;
    }

    public synchronized void setClass(Class javaClass) {
        this.className = javaClass.getName();
        this.object = null;
        this.javaClass = javaClass;
        this.context.setProperty("className", this.className);
        this.instantiator = new Constructor(this.className, new String[0]);
        this.instantiator.setClassLoader(javaClass.getClassLoader());
    }

    public static void validateClassName(String className) throws IllegalArgumentException {
        if (className == null) {
            throw new IllegalArgumentException("missing class name");
        }
    }

    public synchronized Class getJavaClass() {
        if (this.javaClass != null) {
            return this.javaClass;
        }
        try {
            String name = this.getClassName();
            if (name != null) {
                this.javaClass = ClassLoaders.loadClass(name);
            }
        }
        catch (Exception exception) {
            throw new WrappedException(exception);
        }
        return this.javaClass;
    }

    public synchronized void setMode(int mode) {
        this.mode = mode;
        this.context.setProperty("activation", this.getModeString());
    }

    public synchronized int getMode() {
        if (this.mode != -1) {
            return this.mode;
        }
        String modeString = this.context.getStringProperty("activation");
        if (modeString == null) {
            this.mode = 0;
        } else {
            this.setMode(modeString);
        }
        return this.mode;
    }

    public static int getMode(String string) {
        int i = 0;
        while (i < IActivationConstants.modes.length) {
            if (IActivationConstants.modes[i].equalsIgnoreCase(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getModeString() {
        return IActivationConstants.modes[this.getMode()];
    }

    public void setMode(String string) throws IllegalArgumentException {
        this.setMode(ObjectService.getMode(string));
    }

    public static void validateMode(String string) throws IllegalArgumentException {
        if (ObjectService.getMode(string) == -1) {
            throw new IllegalArgumentException("mode can only be application, request or session");
        }
    }

    protected synchronized Class[] getInterfaces() throws ClassNotFoundException {
        if (this.interfaces != null) {
            return this.interfaces;
        }
        this.interfaces = new Class[0];
        Enumeration enumeration = this.context.getProperties("interface");
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            Class javaClass = ClassLoaders.loadClass(name, this.getClassLoader());
            this.interfaces = (Class[])ArrayUtil.addElement(this.interfaces, javaClass);
        }
        return this.interfaces;
    }

    protected synchronized MethodDescriptor[] getMethods() throws NoSuchMethodException, ClassNotFoundException {
        if (this.methods != null) {
            return this.methods;
        }
        Enumeration enumeration = this.context.getProperties("method");
        this.methods = new MethodDescriptor[0];
        if (enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                MethodDescriptor descriptor = (MethodDescriptor)enumeration.nextElement();
                descriptor.initialize(this.getJavaClass());
                this.methods = (MethodDescriptor[])ArrayUtil.addElement(this.methods, descriptor);
            }
        } else {
            Method[] javaMethods = this.getJavaClass().getMethods();
            javaMethods = Reflect.getMethodsNotImplementedBy(javaMethods, EXCLUDED);
            int i = 0;
            while (i < javaMethods.length) {
                this.methods = (MethodDescriptor[])ArrayUtil.addElement(this.methods, new MethodDescriptor(javaMethods[i]));
                ++i;
            }
        }
        return this.methods;
    }

    public String getPath(Object object) throws DirectoryException {
        return this.object == object ? "" : null;
    }

    public Value invoke(Method method, Object[] args, Context context) throws Throwable {
        return Invocation.invoke(this.getObject(), method, args);
    }

    public Value invoke(String method, Object[] args, Class[] argTypes, Context context) throws Throwable {
        return Invocation.invoke(this.getObject(), method, args, argTypes);
    }

    public Value invoke(String method, String[] args, Context context) throws Throwable {
        return Invocation.invoke(this.getObject(), method, args);
    }

    public ClassLoader getClassLoader() {
        return this.instantiator.getClassLoader();
    }

    public IReference getReference() {
        if (this.referenceChain == null) {
            this.referenceChain = ReferenceFactories.getReferenceChain(this, this);
        }
        return this.referenceChain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WSDL getWSDL() {
        if (this.wsdl != null) {
            return this.wsdl;
        }
        try {
            try {
                ThreadContext.setProperty("service", this);
                XURL[] endpoints = this.getEndpoints();
                Class[] interfaces = this.getInterfaces();
                if (interfaces.length > 0) {
                    this.wsdl = WSDLGenerator.getWSDL(endpoints, this.getDescription(), this.context, this.getJavaClass(), interfaces);
                }
                this.wsdl = WSDLGenerator.getWSDL(endpoints, this.getDescription(), this.context, this.getMethods(), this.getJavaClass());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var4_5 = null;
                ThreadContext.removeProperty("service");
                return this.wsdl;
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            ThreadContext.removeProperty("service");
            throw throwable;
        }
        ThreadContext.removeProperty("service");
        return this.wsdl;
    }

    protected XURL[] getEndpoints() throws MalformedURLException {
        XURL[] endpoints = null;
        Enumeration enumeration = this.context.getProperties("endpoint");
        if (enumeration.hasMoreElements()) {
            endpoints = new XURL[]{};
            while (enumeration.hasMoreElements()) {
                XURL endpoint = new XURL((String)enumeration.nextElement());
                endpoints = (XURL[])ArrayUtil.addElement(endpoints, endpoint);
            }
        } else {
            String[] urls = Registry.getAllPaths(this);
            if (urls.length == 0) {
                urls = new String[]{Registry.getPath("/", (Object)this)};
            }
            endpoints = new XURL[urls.length];
            int i = 0;
            while (i < endpoints.length) {
                endpoints[i] = new XURL(urls[i]);
                ++i;
            }
        }
        return endpoints;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

