/*
 * Decompiled with CFR 0.152.
 */
package electric.service.instrumentation.listener;

import electric.glue.IGLUEContextConstants;
import electric.service.IService;
import electric.service.instrumentation.Instrumentor;
import electric.service.instrumentation.listener.IInstrumentationListener;

public class InvocationObserver
implements IInstrumentationListener,
IGLUEContextConstants {
    public void prepareService(IService service) {
        service.getContext().setProperty("instrumentor", new Instrumentor());
    }

    public void preInvoke(IService service, String method, int args) {
        Instrumentor instrumentor = this.getInstrumentor(service);
        if (instrumentor != null) {
            instrumentor.startTiming(method, args);
        }
    }

    public void postInvokeSuccess(IService service, String method, int args) {
        Instrumentor instrumentor = this.getInstrumentor(service);
        if (instrumentor != null) {
            instrumentor.stopTiming(method, args);
            instrumentor.addSuccess();
        }
    }

    public void postInvokeFailure(IService service, String method, int args) {
        Instrumentor instrumentor = this.getInstrumentor(service);
        if (instrumentor != null) {
            instrumentor.stopTiming(method, args);
            instrumentor.addFailure();
        }
    }

    private Instrumentor getInstrumentor(IService service) {
        return (Instrumentor)service.getContext().getProperty("instrumentor");
    }
}

