/*
 * Decompiled with CFR 0.152.
 */
package electric.server.jms.sonicmq;

import electric.server.jms.IJMSAdapter;
import electric.util.Context;
import electric.util.UUID;
import javax.jms.JMSException;
import javax.jms.QueueConnectionFactory;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import progress.message.jclient.Queue;
import progress.message.tools.BrokerManager;
import progress.message.tools.IBrokerManagerListener;

public class SonicMQAdapter
implements IJMSAdapter,
IBrokerManagerListener {
    public static final String HOST = "sonicMQHost";
    public static final String USER = "sonicMQUser";
    public static final String PASSWORD = "sonicMQPassword";
    private String defaultHost = "localhost:2506";
    private String userName;
    private String password;
    private BrokerManager brokerManager;
    private QueueConnectionFactory defaultConnFactory;

    public void startup(Context context) throws JMSException {
        if (this.isStarted()) {
            return;
        }
        this.defaultHost = (String)Context.getProperty(context, HOST, this.defaultHost);
        this.userName = (String)Context.getProperty(context, USER, "");
        this.password = (String)Context.getProperty(context, PASSWORD, "");
        this.brokerManager = new BrokerManager((IBrokerManagerListener)this, this.defaultHost, this.userName, this.password);
        try {
            this.brokerManager.connect();
        }
        catch (Exception exception) {
            throw new JMSException("exception while attempting to connect to SonicMQ broker - " + exception.toString());
        }
        this.defaultConnFactory = new progress.message.jclient.QueueConnectionFactory(this.defaultHost, new UUID().getKey(), this.userName, this.password);
    }

    public boolean isStarted() {
        return this.brokerManager != null;
    }

    public void shutdown() throws JMSException {
        if (this.brokerManager != null) {
            this.brokerManager.disconnect();
            this.brokerManager = null;
        }
    }

    public Context getStartupContext() {
        if (!this.isStarted()) {
            throw new IllegalStateException("adapter is not started, unable to gather startup context information");
        }
        Context context = new Context();
        context.setProperty(HOST, this.defaultHost);
        context.setProperty(USER, this.userName);
        context.setProperty(PASSWORD, this.password);
        return context;
    }

    public javax.jms.Queue getQueue(String queueName, boolean create) throws JMSException, NamingException {
        if (create) {
            try {
                this.brokerManager.setQueue(queueName, false, false, 1200, 1400, 1000);
            }
            catch (Exception exception) {
                throw new JMSException("unable to create JMS queue - " + exception.toString());
            }
        }
        String[][] queues = null;
        try {
            queues = this.brokerManager.getQueues(queueName, false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new JMSException("unable to retrieve list of queues from SonicMQ broker - " + exception.toString());
        }
        if (queues == null || queues.length == 0) {
            throw new NameNotFoundException(queueName + " cannot be found");
        }
        int i = 0;
        while (i < queues.length) {
            if (queues[i][0].equalsIgnoreCase(queueName)) {
                return new Queue(queueName);
            }
            ++i;
        }
        throw new NameNotFoundException(queueName + " cannot be found");
    }

    public QueueConnectionFactory getQueueConnectionFactory(String queueConnFactoryName, boolean create) throws JMSException {
        if (create) {
            return new progress.message.jclient.QueueConnectionFactory(this.defaultHost, queueConnFactoryName, this.userName, this.password);
        }
        return this.defaultConnFactory;
    }

    public String getClassName() {
        return "progress.message.tools.BrokerManager";
    }

    public String getProviderName() {
        return "SonicMQ";
    }

    public void brokerShutdown(String host) {
    }

    public void brokerConnectionDropped(String host) {
    }

    public void brokerEventNotification(String description) {
    }

    public void brokerUndeliveredMsgNotification(String broker, String messageID, String destination, long timestamp, int reason, boolean preserved) {
    }
}

