/*
 * Decompiled with CFR 0.152.
 */
package electric.registry.local;

import electric.glue.IGLUELoggingConstants;
import electric.proxy.IReference;
import electric.registry.IRegistry;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.server.Servers;
import electric.util.Context;
import electric.util.XURL;
import electric.util.classloader.ClassLoaders;
import electric.util.classloader.IHasClassLoader;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.string.Strings;
import electric.wsdl.IWSDLConstants;
import java.net.MalformedURLException;

public class LocalRegistry
implements IRegistry,
IWSDLConstants,
IGLUELoggingConstants {
    public IReference bind(String path, Class[] interfaces, Context context) throws RegistryException {
        if (path == null) {
            return null;
        }
        try {
            String endpoint = context.getStringProperty("endpoint");
            if (endpoint == null) {
                return this.bindUsingPath(path, interfaces, context);
            }
            return this.bindUsingEndpoint(endpoint, interfaces, context);
        }
        catch (RegistryException exception) {
            throw exception;
        }
        catch (Exception exception) {
            String error = "could not bind to path: " + path;
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, error, exception);
            }
            throw new RegistryException(error, exception);
        }
    }

    private IReference bindUsingPath(String path, Class[] interfaces, Context context) throws RegistryException, MalformedURLException {
        if (!path.toLowerCase().endsWith(".wsdl")) {
            return null;
        }
        XURL xurl = new XURL(Strings.head(path, '.'));
        String localPath = this.getLocal(xurl);
        if (localPath == null) {
            return null;
        }
        return this.getReference(localPath, interfaces, context);
    }

    private IReference bindUsingEndpoint(String endpoint, Class[] interfaces, Context context) throws RegistryException, MalformedURLException {
        String localPath = this.getLocal(new XURL(endpoint));
        if (localPath == null) {
            return null;
        }
        Context contextCopy = new Context(context);
        contextCopy.removeProperty("endpoint");
        return this.getReference(localPath, interfaces, contextCopy);
    }

    private String getLocal(XURL xurl) {
        return xurl.getProtocol() != null ? Servers.getLocalPath(xurl) : xurl.getFile();
    }

    public boolean publish(String path, Object object, Context context) throws RegistryException {
        return false;
    }

    public boolean unpublish(String path) throws RegistryException {
        return false;
    }

    private IReference getReference(String path, Class[] interfaces, Context context) throws RegistryException {
        ClassLoader cl;
        Object service = Registry.get(path);
        if (service instanceof IHasClassLoader && (cl = ((IHasClassLoader)service).getClassLoader()) != null && !ClassLoaders.isAncestor(cl, ClassLoaders.getContextClassLoader())) {
            String soapLocalPath = Strings.splice("soaplocal:///", path);
            return Registry.getReference(soapLocalPath, interfaces, context);
        }
        return Registry.getReference(path, interfaces, context);
    }
}

