/*
 * Decompiled with CFR 0.152.
 */
package electric.proxy.rebind;

import electric.glue.IGLUELoggingConstants;
import electric.proxy.IReference;
import electric.proxy.rebind.IRebindReferenceListener;
import electric.registry.IRegistry;
import electric.registry.RegistryException;
import electric.util.Context;
import electric.util.Value;
import electric.util.log.Log;
import electric.wsdl.WSDL;
import java.lang.reflect.Method;
import java.rmi.RemoteException;

public class RebindReference
implements IReference,
IGLUELoggingConstants {
    private IRegistry registry;
    private String path;
    private Class[] interfaces;
    private Context context;
    private IReference reference;
    private IRebindReferenceListener listener;

    public RebindReference(IRegistry registry, String path, Class[] interfaces, Context context, IReference reference) {
        this.registry = registry;
        this.path = path;
        this.interfaces = interfaces;
        this.context = context;
        this.reference = reference;
    }

    public void setListener(IRebindReferenceListener listener) {
        this.listener = listener;
    }

    public IRebindReferenceListener getListener() {
        return this.listener;
    }

    public WSDL getWSDL() {
        try {
            return this.getReference().getWSDL();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Value invoke(Method method, Object[] args, Context context) throws Throwable {
        while (true) {
            try {
                return this.getReference().invoke(method, args, context);
            }
            catch (RemoteException exception) {
                this.rebind(exception);
                continue;
            }
            break;
        }
    }

    public Value invoke(String method, Object[] args, Class[] argTypes, Context context) throws Throwable {
        while (true) {
            try {
                return this.getReference().invoke(method, args, argTypes, context);
            }
            catch (RemoteException exception) {
                this.rebind(exception);
                continue;
            }
            break;
        }
    }

    public Value invoke(String method, String[] args, Context context) throws Throwable {
        while (true) {
            try {
                return this.getReference().invoke(method, args, context);
            }
            catch (RemoteException exception) {
                this.rebind(exception);
                continue;
            }
            break;
        }
    }

    public synchronized IReference getReference() throws RegistryException {
        if (this.reference != null) {
            return this.reference;
        }
        this.bind();
        return this.reference;
    }

    public synchronized void setReference(IReference reference) {
        this.reference = reference;
    }

    public synchronized void bind() throws RegistryException {
        if (this.listener != null) {
            this.listener.beginBind();
        }
        this.reference = this.registry.bind(this.path, this.interfaces, this.context);
        if (this.listener != null) {
            this.listener.endBind();
        }
    }

    private void rebind(Exception exception) throws RegistryException {
        if (Log.isLogging(IGLUELoggingConstants.REBINDING_EVENT)) {
            Log.log(IGLUELoggingConstants.REBINDING_EVENT, (Object)("rebind to " + this.path));
        }
        this.bind();
        if (this.reference == null) {
            throw new RegistryException(exception);
        }
    }
}

