/*
 * Decompiled with CFR 0.152.
 */
package electric.proxy.chain;

import electric.proxy.IReference;
import electric.proxy.chain.IChainedReference;
import electric.util.Context;
import electric.util.Value;
import electric.util.list.LinkedList;
import electric.util.list.ListEnumeration;
import electric.util.list.ListNode;
import electric.wsdl.WSDL;
import java.lang.reflect.Method;

public class ReferenceChain
implements IReference {
    private LinkedList chain = new LinkedList();
    private IReference head;

    public void addReference(IReference reference) {
        ListNode tail = this.chain.getLast();
        this.chain.add(new ListNode(reference));
        if (tail == null) {
            this.head = reference;
        } else if (tail.getObject() instanceof IChainedReference) {
            ((IChainedReference)tail.getObject()).setNextReference(reference);
        } else {
            throw new IllegalArgumentException("cannot added a reference to the chain where last element is not chainable");
        }
    }

    public void removeReference(IReference reference) {
        ListEnumeration listEnumeration = this.chain.elements();
        while (listEnumeration.hasMoreElements()) {
            ListNode node = listEnumeration.nextNode();
            if (node.getObject() != reference) continue;
            this.removeNode(node);
            break;
        }
    }

    private void removeNode(ListNode node) {
        ListNode prev = node.getPrevious();
        ListNode next = node.getNext();
        if (prev == null) {
            this.head = next == null ? null : (IReference)next.getObject();
        } else if (next == null) {
            ((IChainedReference)prev.getObject()).setNextReference(null);
        } else {
            ((IChainedReference)prev.getObject()).setNextReference((IReference)next.getObject());
        }
        this.chain.remove(node);
    }

    public boolean removeReference(Class type) {
        IReference reference = this.getReferenceOfType(type);
        if (reference == null) {
            return false;
        }
        this.removeReference(reference);
        return true;
    }

    public IReference getReferenceOfType(Class type) {
        ListEnumeration listEnumeration = this.chain.elements();
        while (listEnumeration.hasMoreElements()) {
            ListNode node = listEnumeration.nextNode();
            if (!type.isAssignableFrom(node.getObject().getClass())) continue;
            return (IReference)node.getObject();
        }
        return null;
    }

    public int getLength() {
        return this.chain.size();
    }

    public WSDL getWSDL() {
        return this.head.getWSDL();
    }

    public Value invoke(Method method, Object[] args, Context context) throws Throwable {
        return this.head.invoke(method, args, context);
    }

    public Value invoke(String method, Object[] args, Class[] argTypes, Context context) throws Throwable {
        return this.head.invoke(method, args, argTypes, context);
    }

    public Value invoke(String method, String[] args, Context context) throws Throwable {
        return this.head.invoke(method, args, context);
    }
}

