/*
 * Decompiled with CFR 0.152.
 */
package electric.jsp;

import electric.glue.IGLUELoggingConstants;
import electric.servlet.HTTPContext;
import electric.util.classloader.ClassLoaders;
import electric.util.classpath.IClassPathSource;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.io.File;
import java.io.IOException;
import javax.servlet.GenericServlet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class JSPServlet
extends GenericServlet
implements IGLUELoggingConstants {
    public static final String CLASSPATH_ATTRIBUTE = "org.apache.catalina.jsp_classpath";
    public static final String CLASSPATH_SOURCE_ATTRIBUTE = "electric.classpathsource";
    public static final String SERVLET_CLASS = "org.apache.jasper.servlet.JspServlet";
    private Servlet theServlet;
    private ServletConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this.theServlet == null) {
            String errorMsg = "unable to locate jasper JspServlet class. make sure jsp.jar, xerces.jar and JDK's tools.jar are available to the application";
            if (Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
                Log.log(ILoggingConstants.WARNING_EVENT, (Object)errorMsg);
            }
            throw new ServletException(errorMsg);
        }
        ClassLoader oldClassLoader = ClassLoaders.getContextClassLoader();
        ClassLoaders.setContextClassLoader(this.getClassLoader());
        try {
            this.setClassPath();
            this.theServlet.service(request, response);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ClassLoaders.setContextClassLoader(oldClassLoader);
            throw throwable;
        }
        ClassLoaders.setContextClassLoader(oldClassLoader);
    }

    private void setClassPath() {
        Object classpathSource = this.config.getServletContext().getAttribute(CLASSPATH_SOURCE_ATTRIBUTE);
        if (classpathSource == null) {
            return;
        }
        String[] classPathValue = ((IClassPathSource)classpathSource).getClassPath();
        StringBuffer classPath = new StringBuffer();
        int i = 0;
        while (i < classPathValue.length) {
            classPath.append(classPathValue[i] + File.pathSeparator);
            ++i;
        }
        this.config.getServletContext().setAttribute(CLASSPATH_ATTRIBUTE, (Object)classPath.toString());
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        ClassLoader loader = this.getClassLoader();
        try {
            if (this.theServlet == null) {
                this.theServlet = (Servlet)ClassLoaders.loadClass(SERVLET_CLASS, loader).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.theServlet != null) {
            this.theServlet.init(config);
        }
    }

    private ClassLoader getClassLoader() {
        if (this.config.getServletContext() instanceof HTTPContext) {
            return ((HTTPContext)this.config.getServletContext()).getClassLoader();
        }
        return this.getClass().getClassLoader();
    }

    public void destroy() {
        if (this.theServlet != null) {
            this.theServlet.destroy();
        }
        this.theServlet = null;
    }
}

