/*
 * Decompiled with CFR 0.152.
 */
package electric.http.loader;

import electric.http.OutboundHTTPRequest;
import electric.util.Context;
import electric.util.ExceptionUtil;
import electric.util.http.IHTTPConstants;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.resourceloader.IResourceLoader;
import electric.util.resourceloader.ResourceLoaders;
import java.io.IOException;
import java.net.ConnectException;

public class HTTPResourceLoader
implements IResourceLoader,
ILoggingConstants,
IHTTPConstants {
    public static void startup() {
        HTTPResourceLoader httpResourceLoader = new HTTPResourceLoader();
        ResourceLoaders.addResourceLoader("http", httpResourceLoader);
        ResourceLoaders.addResourceLoader("https", httpResourceLoader);
    }

    public byte[] loadResource(String path, Context context) throws IOException {
        try {
            return new OutboundHTTPRequest().get(path, context);
        }
        catch (ConnectException exception) {
            String message = exception.getMessage() + ": unable to load file " + path;
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, message, exception);
            }
            throw new java.rmi.ConnectException(message);
        }
        catch (IOException exception) {
            String message = exception.getMessage() + ": unable to load file " + path;
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, message, exception);
            }
            throw (IOException)ExceptionUtil.cloneException(exception, message);
        }
    }
}

