/*
 * Decompiled with CFR 0.152.
 */
package electric.http;

import electric.glue.IGLUEContextConstants;
import electric.glue.IGLUELoggingConstants;
import electric.http.InboundHTTPResponse;
import electric.http.OutboundHTTPRequest;
import electric.http.authentication.ClientAuthenticationException;
import electric.http.authentication.IAuthSession;
import electric.http.authentication.basic.BasicAuthSession;
import electric.http.authentication.digest.DigestAuthSession;
import electric.http.cookies.ClientCookie;
import electric.http.cookies.ClientCookies;
import electric.http.cookies.CookieHolder;
import electric.net.channel.ChannelPool;
import electric.net.channel.ChannelsInUse;
import electric.net.event.NetEvent;
import electric.net.event.NetLog;
import electric.net.socket.SocketChannel;
import electric.net.socket.SocketFactories;
import electric.security.Login;
import electric.security.credentials.PasswordCredentials;
import electric.util.Context;
import electric.util.XURL;
import electric.util.http.AuthHeaderData;
import electric.util.http.HTTPUtil;
import electric.util.http.IHTTPConstants;
import electric.util.list.LinkedList;
import electric.util.log.Log;
import electric.util.string.Base64;
import electric.util.string.Strings;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class HTTPMessage
implements IHTTPConstants,
IGLUELoggingConstants,
IGLUEContextConstants {
    private static final Hashtable realmCache = new Hashtable();
    private static final ChannelPool channelPool = new ChannelPool();
    private static final ChannelsInUse channelsInUse = new ChannelsInUse();
    private static final int authTryLimit = 4;
    private static boolean defaultFollowRedirects = true;
    private boolean followRedirects = defaultFollowRedirects;
    private OutboundHTTPRequest request;
    private InboundHTTPResponse response;
    private XURL endpoint;
    private XURL host;
    private int maxTries;
    private Context context;
    private XURL proxy;
    private int triedAuthentication;
    private int failures;
    private SocketChannel socketChannel;
    private NetEvent previousEvent;
    private boolean smartConnections;
    private IAuthSession authSession;
    private Integer socketReadTimeout;
    private int previousTimeout;
    private long totalBytesWritten;
    private long initialBytesRead;

    public HTTPMessage(OutboundHTTPRequest request, XURL endpoint, int maxTries, Context context) {
        this.request = request;
        this.endpoint = endpoint;
        this.maxTries = maxTries;
        this.context = context;
        this.host = HTTPUtil.getTCPXURL(endpoint);
        String string = (String)Context.getProperty(context, "smartConnections");
        this.smartConnections = Strings.getBoolean(string, false);
        this.socketReadTimeout = (Integer)context.getProperty("clientSocketReadTimeout");
        string = (String)Context.getProperty(context, "followRedirects");
        this.followRedirects = Strings.getBoolean(string, defaultFollowRedirects);
    }

    public XURL getHost() {
        return this.host;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundHTTPResponse send() throws IOException, SecurityException {
        this.previousEvent = NetLog.getEvent(this.endpoint);
        if (this.smartConnections && this.previousEvent != null && !this.previousEvent.retry()) {
            this.previousEvent.rethrow();
        }
        this.proxy = HTTPMessage.getProxy(this.context);
        this.writeCookies();
        this.preAuthenticate();
        while (true) {
            try {
                if (Log.isLogging(IGLUELoggingConstants.HTTP_EVENT)) {
                    Log.log(IGLUELoggingConstants.HTTP_EVENT, (Object)("outbound request to " + this.host + '\n' + this.request + '\n'));
                }
                this.obtainChannel();
                this.writeRequest();
                this.readResponseHeaders();
                this.readCookies(this.request.getRequestURI());
                this.checkForRedirects();
                if (this.postAuthenticate()) continue;
                if (this.previousEvent != null) {
                    NetLog.removeEvents(this.endpoint);
                }
                InboundHTTPResponse inboundHTTPResponse = this.response;
                return inboundHTTPResponse;
            }
            catch (ConnectException exception) {
                this.logAndRethrow(exception);
                continue;
            }
            catch (InterruptedIOException exception) {
                this.logAndRethrow(exception);
                continue;
            }
            catch (NoRouteToHostException exception) {
                this.logAndRethrow(exception);
                continue;
            }
            catch (UnknownHostException exception) {
                this.logAndRethrow(exception);
                continue;
            }
            catch (IOException exception) {
                this.clearChannel();
                if (this.failures < this.maxTries && this.request.canResendSource()) continue;
                this.logAndRethrow(exception);
                continue;
            }
            finally {
                if (this.socketChannel == null || this.response != null) continue;
                this.releaseChannel();
                continue;
            }
            break;
        }
    }

    public static XURL getProxy(Context context) {
        String proxyHost = context.getStringProperty("httpProxyHost");
        if (proxyHost != null) {
            int proxyPort = context.getIntProperty("httpProxyPort", 8000);
            return new XURL("tcp", proxyHost, proxyPort, null, null);
        }
        proxyHost = Context.application().getStringProperty("httpProxyHost");
        if (proxyHost != null) {
            int proxyPort = Context.application().getIntProperty("httpProxyPort", 8000);
            return new XURL("tcp", proxyHost, proxyPort, null, null);
        }
        return null;
    }

    private void logAndRethrow(IOException exception) throws IOException {
        this.clearChannel();
        if (this.previousEvent != null && this.previousEvent.matches(this.endpoint, exception)) {
            this.previousEvent.reoccurred();
        } else {
            NetLog.addEvent(new NetEvent(this.endpoint, exception));
        }
        throw exception;
    }

    private void writeRequest() throws IOException {
        long start = this.socketChannel.getBytesWritten();
        this.request.setChannel(this.socketChannel);
        this.request.setFlushedHeader(false);
        this.request.flushHeader();
        this.request.writeSource();
        this.request.flush();
        long stop = this.socketChannel.getBytesWritten();
        this.totalBytesWritten = stop - start;
    }

    private void readResponseHeaders() throws IOException {
        this.initialBytesRead = this.socketChannel.getBytesRead();
        this.response = new InboundHTTPResponse(this);
        this.response.readHeaders();
        this.socketChannel.setKeepAlive(this.request.isKeepAlive() && this.response.isKeepAlive());
    }

    public long getBytesWritten() {
        return this.totalBytesWritten;
    }

    public long getBytesRead() {
        return this.socketChannel.getBytesRead() - this.initialBytesRead;
    }

    private void writeCookies() {
        CookieHolder[] holders = ClientCookies.getCookieHolders(this.context);
        if (holders == null) {
            return;
        }
        int i = 0;
        while (i < holders.length) {
            ClientCookie cookie = holders[i].getCookie();
            String cookiePath = cookie.getPath();
            if ((cookiePath == null || this.request.getRequestURI().startsWith(cookiePath)) && !holders[i].expired()) {
                this.request.addCookie(cookie);
            }
            ++i;
        }
    }

    private void readCookies(String requestURI) {
        ClientCookie[] cookies = this.response.getCookies(requestURI);
        if (cookies == null) {
            return;
        }
        int i = 0;
        while (i < cookies.length) {
            ClientCookies.addCookie(this.context, cookies[i]);
            ++i;
        }
    }

    public static ChannelPool getChannelPool() {
        return channelPool;
    }

    public static LinkedList getChannels() {
        return channelsInUse.getChannels();
    }

    public static void setMaxCacheSize(int max) {
        channelPool.setMaxCacheSize(max);
    }

    private static SocketChannel getChannel(XURL remote, XURL local) throws IOException {
        SocketChannel channel = (SocketChannel)channelPool.get(remote);
        if (channel != null) {
            channel.setKeepAlive(false);
            return channel;
        }
        Socket socket = null;
        socket = local == null ? SocketFactories.createSocket(remote) : SocketFactories.createSocket(remote, local);
        socket.setTcpNoDelay(true);
        channel = new SocketChannel(socket, remote.getProtocol());
        channelsInUse.add(channel);
        return channel;
    }

    public void releaseChannel() throws IOException {
        if (this.socketChannel.getKeepAlive()) {
            if (this.socketReadTimeout != null) {
                this.socketChannel.setTimeout(this.previousTimeout);
            }
            this.socketChannel.setKeptAlive(true);
            this.socketChannel.setState(2);
            if (this.proxy != null && this.host.getProtocol().equalsIgnoreCase("http")) {
                channelPool.put(this.proxy, this.socketChannel);
            } else {
                channelPool.put(this.host, this.socketChannel);
            }
        } else {
            channelsInUse.remove(this.socketChannel);
            this.socketChannel.close();
            this.socketChannel = null;
        }
    }

    public SocketChannel getChannel() {
        return this.socketChannel;
    }

    private void obtainChannel() throws IOException {
        this.socketChannel = this.proxy == null ? HTTPMessage.getChannel(this.host, this.getLocalXURL()) : (this.host.getProtocol().equalsIgnoreCase("tcp") ? this.getHTTPProxyChannel() : this.getHTTPSProxyChannel());
        if (this.socketReadTimeout != null) {
            this.previousTimeout = this.socketChannel.getTimeout();
            this.socketChannel.setTimeout(this.socketReadTimeout);
        }
        this.socketChannel.setState(0);
    }

    private SocketChannel getHTTPProxyChannel() throws IOException {
        if (Log.isLogging(IGLUELoggingConstants.HTTP_EVENT)) {
            Log.log(IGLUELoggingConstants.HTTP_EVENT, (Object)("route HTTP request via proxy at " + this.proxy));
        }
        String uri = this.request.getRequestURI();
        this.request.setRequestURI("http://" + this.host.getHost() + ":" + this.host.getPort() + uri);
        return HTTPMessage.getChannel(this.proxy, this.getLocalXURL());
    }

    private XURL getLocalXURL() throws MalformedURLException {
        XURL local = null;
        Object obj = this.context.getProperty("localAddress");
        if (obj instanceof String) {
            local = XURL.hasProtocol((String)obj) ? new XURL((String)obj) : new XURL("tcp://" + obj);
        } else if (obj instanceof XURL) {
            local = (XURL)obj;
        }
        return local;
    }

    private SocketChannel getHTTPSProxyChannel() throws IOException {
        SocketChannel channel;
        if (Log.isLogging(IGLUELoggingConstants.HTTP_EVENT)) {
            Log.log(IGLUELoggingConstants.HTTP_EVENT, (Object)("route HTTPS request via proxy at " + this.proxy));
        }
        if ((channel = (SocketChannel)channelPool.get(this.host)) != null) {
            channel.setKeepAlive(false);
            return channel;
        }
        Socket socket = SocketFactories.createSocket(this.proxy);
        socket.setTcpNoDelay(true);
        SocketChannel tunnel = new SocketChannel(socket, "http");
        OutboundHTTPRequest connectRequest = new OutboundHTTPRequest();
        connectRequest.setMethod("CONNECT");
        connectRequest.setVersion("HTTP/1.1");
        connectRequest.setRequestURI(this.host.getHost() + ":" + this.host.getPort());
        PasswordCredentials credentials = HTTPMessage.getProxyCredentials(this.context);
        if (credentials != null) {
            String base64 = Base64.toBase64((credentials.user + ":" + credentials.password).getBytes());
            connectRequest.addHeader("Proxy-Authorization", "Basic " + base64);
        }
        connectRequest.setChannel(tunnel);
        connectRequest.flush();
        InboundHTTPResponse response = new InboundHTTPResponse(connectRequest);
        response.readHeaders();
        int status = response.getStatus();
        if (status == 407) {
            tunnel.close();
            throw new IOException("failed proxy authentication");
        }
        if (status != 200) {
            tunnel.close();
            throw new IOException("could not create HTTPS tunnel, HTTP status code " + status);
        }
        Socket sslSocket = SocketFactories.createSocket(socket, this.host);
        channel = new SocketChannel(sslSocket, this.host.getProtocol());
        channelsInUse.add(channel);
        return channel;
    }

    private void clearChannel() {
        if (this.socketChannel == null) {
            ++this.failures;
        } else {
            if (!this.socketChannel.getKeptAlive()) {
                ++this.failures;
            }
            try {
                this.socketChannel.close();
            }
            catch (Exception error) {
                // empty catch block
            }
            channelsInUse.remove(this.socketChannel);
            this.socketChannel = null;
        }
    }

    public static IAuthSession createAuthSession(String authMethod) {
        if ("Basic".equalsIgnoreCase(authMethod = authMethod.trim())) {
            return new BasicAuthSession();
        }
        if ("Digest".equalsIgnoreCase(authMethod)) {
            return new DigestAuthSession();
        }
        return null;
    }

    public static IAuthSession createAuthSessionFromHeader(String wwwAuthHeader) {
        StringTokenizer tokenizer = new StringTokenizer(wwwAuthHeader, " =");
        String method = tokenizer.nextToken();
        method = method.trim();
        return HTTPMessage.createAuthSession(method);
    }

    public void proxyAuthenticate(PasswordCredentials credentials) {
        String base64 = Base64.toBase64((credentials.user + ":" + credentials.password).getBytes());
        this.request.addHeader("Proxy-Authorization", "Basic " + base64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preAuthenticate() {
        PasswordCredentials proxyCredentials;
        if (this.proxy != null && (proxyCredentials = HTTPMessage.getProxyCredentials(this.context)) != null) {
            this.proxyAuthenticate(proxyCredentials);
        }
        String requestedAuthMethod = this.context.getStringProperty("authMethod");
        this.authSession = (IAuthSession)this.context.getProperty("authSessionState");
        if (requestedAuthMethod != null || this.authSession != null) {
            Context context = this.context;
            synchronized (context) {
                this.authSession = (IAuthSession)this.context.getProperty("authSessionState");
                if (this.authSession == null) {
                    this.authSession = HTTPMessage.createAuthSessionFromHeader(requestedAuthMethod);
                    this.context.setProperty("authSessionState", this.authSession);
                    PasswordCredentials credentials = this.findCredentials();
                    this.authSession.setCredentials(credentials);
                }
            }
            this.authSession.preAuthenticate(this.host, this.request);
        }
        if (this.authSession != null) {
            this.authSession.preAuthenticate(this.host, this.request);
        }
    }

    private boolean postAuthenticate() throws SecurityException {
        int status = this.response.getStatus();
        if (status == 407) {
            throw new SecurityException("proxy authorization refused");
        }
        if (status != 401) {
            this.triedAuthentication = 0;
            return false;
        }
        if (this.triedAuthentication >= 4) {
            throw new SecurityException("authorization refused");
        }
        ++this.triedAuthentication;
        Enumeration headers = this.response.getHeaders("WWW-Authenticate");
        boolean retryAgain = false;
        if (headers.hasMoreElements()) {
            while (headers.hasMoreElements()) {
                retryAgain |= this.authenticateRealm((String)headers.nextElement());
            }
        }
        if (!retryAgain) {
            this.triedAuthentication = 4;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean authenticateRealm(String header) throws SecurityException {
        PasswordCredentials credentials;
        Context context = this.context;
        synchronized (context) {
            this.authSession = (IAuthSession)this.context.getProperty("authSessionState");
            if (this.authSession == null) {
                this.authSession = HTTPMessage.createAuthSessionFromHeader(header);
                if (this.authSession == null) {
                    return false;
                }
                this.context.setProperty("authSessionState", this.authSession);
            }
        }
        AuthHeaderData authData = this.authSession.parseAuthHeader(header);
        HTTPMessage.addRealmName(this.host, this.request.getRequestURI(), authData.realmName);
        if (this.authSession.getCredentials() == null && (credentials = this.findCredentials()) != null) {
            this.authSession.setCredentials(credentials);
        }
        try {
            return this.authSession.authenticateRealm(this.host, this.request, authData);
        }
        catch (SecurityException exception) {
            throw new ClientAuthenticationException(exception.getMessage(), this.response);
        }
    }

    private String realmForURI(XURL host, String requestURI) {
        Hashtable uriToRealm = (Hashtable)realmCache.get(host);
        if (uriToRealm == null) {
            return null;
        }
        Enumeration enumeration = uriToRealm.keys();
        while (enumeration.hasMoreElements()) {
            String uri = (String)enumeration.nextElement();
            if (!requestURI.startsWith(uri)) continue;
            return (String)uriToRealm.get(uri);
        }
        return null;
    }

    private PasswordCredentials findCredentials() {
        String realmName;
        PasswordCredentials credentials = HTTPMessage.getCredentials(this.context);
        if (credentials == null && (realmName = this.realmForURI(this.host, this.request.getRequestURI())) != null) {
            credentials = Login.getCredentials(realmName);
        }
        return credentials;
    }

    public static synchronized void addRealmName(XURL host, String requestURI, String realmName) {
        Hashtable<String, String> uriToRealm = (Hashtable<String, String>)realmCache.get(host);
        if (uriToRealm == null) {
            uriToRealm = new Hashtable<String, String>();
            realmCache.put(host, uriToRealm);
        }
        uriToRealm.put(requestURI, realmName);
    }

    public static PasswordCredentials getCredentials(Context context) {
        String user = context.getStringProperty("authUser");
        if (user != null) {
            String password = context.getStringProperty("authPassword");
            return new PasswordCredentials(user, password);
        }
        return null;
    }

    public static PasswordCredentials getProxyCredentials(Context context) {
        String proxyUser = context.getStringProperty("httpProxyUser");
        if (proxyUser != null) {
            String proxyPassword = context.getStringProperty("httpProxyPassword");
            return new PasswordCredentials(proxyUser, proxyPassword);
        }
        proxyUser = Context.application().getStringProperty("httpProxyUser");
        if (proxyUser != null) {
            String proxyPassword = Context.application().getStringProperty("httpProxyPassword");
            return new PasswordCredentials(proxyUser, proxyPassword);
        }
        return null;
    }

    private void checkForRedirects() throws IOException {
        XURL newHost;
        if (this.response.getStatus() != 302 && this.response.getStatus() != 301) {
            return;
        }
        if (!this.followRedirects) {
            return;
        }
        String location = this.response.getHeader("Location");
        if (Log.isLogging(IGLUELoggingConstants.HTTP_EVENT)) {
            Log.log(IGLUELoggingConstants.HTTP_EVENT, (Object)("Redirecting from " + this.endpoint + " to " + location));
        }
        this.endpoint = new XURL(location);
        this.host = newHost = HTTPUtil.getTCPXURL(this.endpoint);
        this.request.setHeader("Host", this.endpoint.getHost() + ":" + this.endpoint.getPort());
        if (this.socketChannel != null) {
            this.releaseChannel();
        }
        throw new IOException("Redirected to " + location);
    }

    public static boolean isDefaultFollowRedirects() {
        return defaultFollowRedirects;
    }

    public static void setDefaultFollowRedirects(boolean defaultFollowRedirects) {
        HTTPMessage.defaultFollowRedirects = defaultFollowRedirects;
    }
}

