/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.std.config;

import electric.glue.IGLUELoggingConstants;
import electric.glue.std.config.IConfigConstants;
import electric.util.classloader.ClassLoaders;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.product.IConfig;
import electric.util.reflect.Creator;
import electric.webserver.messages.IMessageFactory;
import electric.webserver.messages.MessageFactories;
import electric.xml.Element;
import electric.xml.Elements;

public class MessageFactoriesConfig
implements IConfig,
IConfigConstants,
IGLUELoggingConstants {
    public void config(Element config) throws Throwable {
        Element servletMessages = config.getElement("messageFactories");
        if (servletMessages == null) {
            return;
        }
        Elements factories = servletMessages.getElements("factory");
        while (factories.hasMoreElements()) {
            Element factoryElement = factories.next();
            this.createMessageFactory(factoryElement);
        }
    }

    private void createMessageFactory(Element factoryElement) {
        block4: {
            Element constructorElement = factoryElement.getElement("constructor");
            try {
                if (constructorElement != null) {
                    IMessageFactory factory = (IMessageFactory)Creator.newInstance(factoryElement, null);
                    MessageFactories.addFactory(factory);
                    break block4;
                }
                String className = factoryElement.getString();
                Class factoryClass = ClassLoaders.loadClass(className);
                MessageFactories.addFactory((IMessageFactory)factoryClass.newInstance());
            }
            catch (Throwable exception) {
                String message = "unable to create message factory: " + exception.toString();
                if (Log.isLogging(ILoggingConstants.CONFIG_EVENT)) {
                    Log.log(ILoggingConstants.CONFIG_EVENT, (Object)message);
                }
                if (!Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) break block4;
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Object)message);
            }
        }
    }
}

