/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.pro.console.services;

import electric.console.IConsoleConstants;
import electric.console.services.ConsoleModuleInfo;
import electric.console.services.IConsoleModule;
import electric.console.services.ITreeViewProducer;
import electric.glue.pro.console.services.IConnectionConstants;
import electric.glue.pro.console.services.ISystemConstants;
import electric.service.instrumentation.listener.InvocationCounter;
import electric.util.list.LinkedList;
import electric.util.thread.ThreadPool;
import electric.webserver.WebServer;
import electric.webserver.WebServers;
import electric.xml.Document;
import electric.xml.Element;
import java.text.DecimalFormat;
import java.util.Hashtable;

public class System
implements IConsoleModule,
ITreeViewProducer,
ISystemConstants,
IConsoleConstants,
IConnectionConstants {
    private ConsoleModuleInfo moduleInfo;

    public Document getSystemInfo(Hashtable args) {
        Runtime runtime = Runtime.getRuntime();
        DecimalFormat format = new DecimalFormat();
        format.setMinimumFractionDigits(2);
        Document doc = new Document();
        Element root = new Element("DataUpdate");
        doc.setRoot(root);
        long totalMem = runtime.totalMemory();
        long freeMem = runtime.freeMemory();
        root.setString("TotalMemory", totalMem / 1024L + "K");
        root.setString("FreeMemory", freeMem / 1024L + "K");
        root.setString("UsedMemory", (totalMem - freeMem) / 1024L + "K");
        root.setText("JREVendor", java.lang.System.getProperty("java.vendor"));
        root.setText("JREVersion", java.lang.System.getProperty("java.version"));
        root.setText("OSName", java.lang.System.getProperty("os.name") + " " + java.lang.System.getProperty("os.version"));
        if (args.containsKey("detail")) {
            root.setText("JRESpecVersion", java.lang.System.getProperty("java.specification.version"));
            root.setText("JRESpecVendor", java.lang.System.getProperty("java.specification.vendor"));
            root.setText("JRESpecName", java.lang.System.getProperty("java.specification.name"));
            root.setText("JVMSpecVersion", java.lang.System.getProperty("java.vm.specification.version"));
            root.setText("JVMSpecVendor", java.lang.System.getProperty("java.vm.specification.vendor"));
            root.setText("JVMSpecName", java.lang.System.getProperty("java.vm.specification.name"));
        }
        return doc;
    }

    public Element[] getConsoleTreeViewElement(String sessionID) {
        Element element = new Element("TREE");
        element.addText("System");
        element.setAttribute("Name", "System");
        element.setAttribute("Function", "showDetails");
        element.setAttribute("TARGET", "_root");
        element.setAttribute("HeaderText", "System");
        element.setAttribute("swfURL", this.moduleInfo.getSWFURL());
        element.setAttribute("helpfileURL", this.moduleInfo.getHelpFileURL());
        element.setAttribute("serviceURL", this.moduleInfo.getServiceURL());
        return new Element[]{element};
    }

    public boolean isSessionAware() {
        return false;
    }

    public void setConsoleModuleInfo(ConsoleModuleInfo moduleInfo) {
        this.moduleInfo = moduleInfo;
    }

    public Document getSystemSnapshot(Hashtable args) {
        Document doc = new Document();
        Element snapshot = doc.setRoot("snapshot");
        snapshot.setAttribute("timestamp", java.lang.System.currentTimeMillis() + "");
        long usedMemory = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
        snapshot.setLong("Memory", usedMemory);
        snapshot.setInt("Threads", ThreadPool.getShared().getAllocated());
        int totalConnections = 0;
        WebServer[] webServers = WebServers.getWebServers();
        int i = 0;
        while (i < webServers.length) {
            WebServer webServer = webServers[i];
            LinkedList listOfSockets = webServer.getSocketServer().getChannels();
            totalConnections += listOfSockets.size();
            ++i;
        }
        snapshot.setInt("Sockets", totalConnections);
        snapshot.setInt("Requests", InvocationCounter.getInstance().getTotalRequests());
        snapshot.setInt("Failures", InvocationCounter.getInstance().getTotalFailures());
        return doc;
    }
}

