/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.rules.processors.filter;

import electric.fabric.rules.conditions.IUnaryCondition;
import electric.fabric.rules.processors.Processor;
import electric.soap.SOAPException;
import electric.soap.SOAPMessage;
import electric.util.Context;
import electric.util.array.ArrayUtil;
import java.rmi.RemoteException;

public class Filter
extends Processor {
    private String message;
    private String code;
    private IUnaryCondition[] conditions;

    public Filter() {
    }

    public Filter(String message, String code) {
        this(message, code, new IUnaryCondition[0]);
    }

    public Filter(String message, String code, IUnaryCondition[] conditions) {
        this.message = message;
        this.code = code;
        this.conditions = conditions;
    }

    public String toString() {
        return "Filter( message=" + this.message + ", code=" + this.code + " )";
    }

    public Object deepCopy() {
        return this.shallowCopy();
    }

    public Object shallowCopy() {
        return new Filter(this.message, this.code, this.conditions);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setConditions(IUnaryCondition[] conditions) {
        this.conditions = conditions;
    }

    public void addCondition(IUnaryCondition condition) {
        this.conditions = (IUnaryCondition[])ArrayUtil.addElement(this.conditions, condition);
    }

    public IUnaryCondition[] getConditions() {
        return this.conditions;
    }

    public SOAPMessage handle(SOAPMessage request, Context messageContext) throws RemoteException, SecurityException {
        if (this.conditions.length == 0) {
            return this.reject(request, messageContext);
        }
        int i = 0;
        while (i < this.conditions.length) {
            if (this.conditions[i].satisfiedBy(request, messageContext)) {
                return this.reject(request, messageContext);
            }
            ++i;
        }
        return this.nextHandler.handle(request, messageContext);
    }

    private SOAPMessage reject(SOAPMessage request, Context messageContext) {
        SOAPMessage response = new SOAPMessage();
        response.setException(new SOAPException(this.message, this.code));
        return response;
    }
}

