/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.rules.actions.message;

import electric.fabric.rules.actions.IAction;
import electric.proxy.IProxy;
import electric.registry.Registry;
import electric.registry.RegistryException;
import electric.soap.SOAPMessage;
import electric.util.Context;
import electric.util.time.TimeUtil;
import java.util.Vector;

public class SendMessage
implements IAction {
    public String url;
    public String operation;
    public String message;
    public boolean includeRequest = true;
    public boolean includeResponse = true;
    public boolean includeTimestamp = true;
    private transient IProxy proxy;

    public SendMessage() {
    }

    public SendMessage(String url, String operation, String message) {
        this.url = url;
        this.operation = operation;
        this.message = message;
    }

    public String toString() {
        return "SendMessage( url=" + this.url + ", operation=" + this.operation + ", message=" + this.message + " )";
    }

    public void perform(SOAPMessage request, SOAPMessage response, Context messageContext) {
        try {
            IProxy proxy = this.getProxy();
            Vector<Object> args = new Vector<Object>();
            if (this.includeRequest) {
                args.addElement(request.getDocument().toString());
            }
            if (this.includeResponse) {
                args.addElement(response.getDocument().toString());
            }
            if (this.includeTimestamp) {
                args.addElement(new Long(TimeUtil.now()));
            }
            if (this.message != null) {
                args.addElement(this.message);
            }
            Object[] objects = new Object[args.size()];
            args.copyInto(objects);
            proxy.invoke(this.operation, objects);
        }
        catch (Throwable throwable) {}
    }

    private synchronized IProxy getProxy() throws RegistryException {
        if (this.proxy != null) {
            return this.proxy;
        }
        this.proxy = Registry.bind(this.url);
        return this.proxy;
    }
}

