/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.endpoints;

import electric.fabric.endpoints.Endpoint;
import electric.fabric.endpoints.EndpointManager;
import electric.fabric.endpoints.EndpointManagerException;
import electric.util.time.TimeUtil;
import java.util.Vector;

public final class EndpointRefresher
implements Runnable {
    private static final long DEFAULT_REFRESH_CYCLE = 60000L;
    private static long refreshCycle = 60000L;
    private EndpointManager manager;
    private boolean stop = false;

    public EndpointRefresher(EndpointManager manager) {
        this.manager = manager;
    }

    public static void setRefreshCycle(long milliseconds) {
        refreshCycle = milliseconds;
    }

    public static long getRefreshCycle() {
        return refreshCycle;
    }

    public void run() {
        while (!this.stop) {
            try {
                this.refreshEndpoints();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(refreshCycle);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stop() {
        this.stop = true;
    }

    private void refreshEndpoints() throws EndpointManagerException {
        Vector endpoints = this.manager.getEndpointsToRefresh();
        if (!endpoints.isEmpty()) {
            this.refresh(endpoints);
        }
    }

    private void refresh(Vector endpoints) {
        long now = TimeUtil.now();
        String[] keys = new String[endpoints.size()];
        int i = 0;
        while (i < endpoints.size()) {
            keys[i] = ((Endpoint)endpoints.elementAt(i)).getKey();
            ++i;
        }
        try {
            this.manager.getXDBClient().dieUpdate(keys, now + 300000L);
            int i2 = 0;
            while (i2 < endpoints.size()) {
                ((Endpoint)endpoints.elementAt(i2)).setTimeOfLastRefresh(now);
                ++i2;
            }
        }
        catch (Exception exception) {}
    }
}

