/*
 * Decompiled with CFR 0.152.
 */
package electric.directory.persistent;

import electric.directory.Directory;
import electric.directory.DirectoryException;
import electric.directory.IDirectory;
import electric.util.dictionary.persistent.IEntry;
import electric.util.dictionary.transactional.TransactionalDictionary;
import electric.util.file.FileUtil;
import electric.util.string.Strings;
import java.io.File;
import java.util.Enumeration;

public class PersistentDirectory
extends Directory
implements IEntry {
    public PersistentDirectory(String root) throws DirectoryException {
        this(root, false);
    }

    public PersistentDirectory(String root, boolean delete) throws DirectoryException {
        super(new TransactionalDictionary(root, delete));
        File dir = new File(root);
        File[] files = FileUtil.listFiles(dir);
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                String key = Strings.fromFilename(files[i].getName());
                this.put(key, new PersistentDirectory(files[i].getPath(), delete));
            }
            ++i;
        }
    }

    public String toString() {
        return this.toString("PersistentDirectory");
    }

    public Object peek(String path) throws DirectoryException {
        return this.getTransactionalDictionary().peek(path);
    }

    public IDirectory newSubdirectory(String name) throws DirectoryException {
        String filename = Strings.toFilename(name);
        String root = this.getTransactionalDictionary().getRoot() + File.separator + filename;
        PersistentDirectory subdirectory = new PersistentDirectory(root);
        subdirectory.setEncoded(this.getTransactionalDictionary().getEncoded());
        subdirectory.setParent(this);
        this.put(name, subdirectory);
        subdirectory.setSync(this.getTransactionalDictionary().getSync());
        return subdirectory;
    }

    public void delete() throws DirectoryException {
        try {
            this.getTransactionalDictionary().delete();
            super.delete();
        }
        catch (Throwable throwable) {
            throw new DirectoryException(throwable.toString());
        }
    }

    protected TransactionalDictionary getTransactionalDictionary() {
        return (TransactionalDictionary)this.dictionary;
    }

    public boolean getEncoded() {
        return this.getTransactionalDictionary().getEncoded();
    }

    public void setEncoded(boolean encoded) {
        this.getTransactionalDictionary().setEncoded(encoded);
    }

    public void setSync(boolean flag) {
        TransactionalDictionary dictionary = this.getTransactionalDictionary();
        dictionary.setSync(flag);
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            Object object = dictionary.peek(key);
            if (!(object instanceof PersistentDirectory)) continue;
            ((PersistentDirectory)object).setSync(flag);
        }
    }

    public boolean getSync() {
        return this.getTransactionalDictionary().getSync();
    }

    public void putEntry() {
    }

    public void removedEntry() {
        try {
            this.delete();
        }
        catch (Exception exception) {}
    }

    public Object loadEntry() {
        return this;
    }
}

