/*
 * Decompiled with CFR 0.152.
 */
package electric.console;

import electric.console.handlers.DefaultHandler;
import electric.console.handlers.IConsoleHandler;
import electric.console.handlers.LayoutHandler;
import electric.console.handlers.ResourceHandler;
import electric.console.handlers.ServiceHandler;
import electric.glue.IGLUELoggingConstants;
import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.mime.MIMETypes;
import electric.util.string.Strings;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public final class ConsoleServlet
extends HttpServlet
implements IGLUELoggingConstants {
    private static boolean enabled = false;
    private static boolean allowEnable = true;
    private static IConsoleHandler[] dispatchers = new IConsoleHandler[0];
    static /* synthetic */ Class class$electric$console$ConsoleServlet;

    public void init() throws ServletException {
        if (!ConsoleServlet.isEnabled()) {
            return;
        }
        ConsoleServlet.addConsoleHandler(new DefaultHandler());
        ConsoleServlet.addConsoleHandler(new LayoutHandler());
        ConsoleServlet.addConsoleHandler(new ResourceHandler());
        ConsoleServlet.addConsoleHandler(new ServiceHandler(this));
    }

    public static void addConsoleHandler(IConsoleHandler handler) {
        dispatchers = (IConsoleHandler[])ArrayUtil.addElement(dispatchers, handler);
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("Console cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"real-time console feature disabled");
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.service(this.getServletContext(), request, response);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void service(ServletContext context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!ConsoleServlet.isEnabled()) {
            ConsoleServlet.loadResource("console/notavailable.html", context, response);
            return;
        }
        String pathInfo = request.getPathInfo();
        String queryString = request.getQueryString();
        Hashtable queryParams = HttpUtils.parseQueryString((String)(queryString == null ? "" : queryString));
        int i = 0;
        while (i < dispatchers.length) {
            if (dispatchers[i].handle(pathInfo, queryParams, context, request, response)) {
                return;
            }
            ++i;
        }
    }

    public static void loadResource(String path, ServletContext context, HttpServletResponse response) throws IOException {
        if (path.length() == 0) {
            return;
        }
        String contentType = context.getMimeType(path);
        if (contentType == null) {
            String ext = Strings.extension(path);
            contentType = MIMETypes.getMimeType(ext);
        }
        response.setContentType(contentType);
        byte[] bytes = ClassLoaders.loadResource("file:/" + path);
        response.getOutputStream().write(bytes);
    }

    public void addHandler(IConsoleHandler dispatcher) {
        dispatchers = (IConsoleHandler[])ArrayUtil.addElement(dispatchers, dispatcher);
    }

    public void addHandler(String dispatcherName) throws Exception {
        Class dispatcherClass = ClassLoaders.loadClass(dispatcherName);
        Object dispatcher = null;
        Constructor ctor = dispatcherClass.getConstructor(class$electric$console$ConsoleServlet == null ? (class$electric$console$ConsoleServlet = ConsoleServlet.class$("electric.console.ConsoleServlet")) : class$electric$console$ConsoleServlet);
        dispatcher = ctor != null ? ctor.newInstance(this) : dispatcherClass.newInstance();
        dispatchers = (IConsoleHandler[])ArrayUtil.addElement(dispatchers, dispatcher);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

