/*
 * Decompiled with CFR 0.152.
 */
package electric.cluster.tools;

import electric.cluster.IClusterConstants;
import electric.cluster.server.ApplicationServer;
import electric.glue.IGLUEConfigConstants;
import electric.glue.context.ServiceContext;
import electric.glue.enterprise.config.Config;
import electric.registry.Registry;
import electric.util.Context;
import electric.util.product.Product;
import electric.util.string.Strings;
import electric.util.tool.ToolUtil;
import electric.xml.Element;

public class Slave
implements IClusterConstants,
IGLUEConfigConstants {
    private static String port = null;
    static /* synthetic */ Class class$electric$cluster$server$IApplicationServer;

    public static void main(String[] args) throws Throwable {
        Slave.processArgs(args);
        Slave.startSlave();
    }

    private static void processArgs(String[] args) throws Throwable {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.length() == 1) {
                throw new IllegalArgumentException("a plain - is not a valid argument");
            }
            switch (arg.charAt(1)) {
                case 'D': {
                    ToolUtil.setProperty(arg);
                    break;
                }
                case 'h': {
                    Slave.printUsage();
                    System.exit(-1);
                }
                case 'p': {
                    port = args[++i];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                }
            }
            ++i;
        }
    }

    private static void printUsage() {
        System.out.println("usage: slave [-Dname=value]* [-h] [-c clustername] [-p port]");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -Dname=value   = set java system property");
        System.out.println("  -h             = print help and exit");
        System.out.println("  -p port        = run slave on specified port");
    }

    private static void startSlave() throws Throwable {
        Slave.validatePort();
        Product.addPlugin(new Config());
        System.setProperty("glue.master", "false");
        Element glueConfig = Product.getConfig("glue", null);
        Product.startupAsServer(null, glueConfig, null);
        ApplicationServer application = ApplicationServer.getInstance();
        ServiceContext context = new ServiceContext();
        context.addProperty("service.systemService", "true");
        Registry.publish("system/enterprise", (Object)application, class$electric$cluster$server$IApplicationServer == null ? (class$electric$cluster$server$IApplicationServer = Slave.class$("electric.cluster.server.IApplicationServer")) : class$electric$cluster$server$IApplicationServer, (Context)context);
        application.start();
    }

    public static void validatePort() {
        if (port != null) {
            if (Strings.isInteger(port)) {
                System.setProperty("glue.port", port);
            } else {
                System.out.println("error message: the port parameter must be an integer");
                Slave.printUsage();
                System.exit(-1);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

