/*
 * Decompiled with CFR 0.152.
 */
package electric.application.web.servlets;

import electric.application.DeploymentException;
import electric.application.web.WebApplication;
import electric.application.web.managed.ObjectManager;
import electric.application.web.servlets.JSPMonitor;
import electric.application.web.servlets.ManagedServlets;
import electric.application.web.servlets.WebMonitor;
import electric.glue.IGLUELoggingConstants;
import electric.glue.std.config.IConfigConstants;
import electric.servlet.Config;
import electric.servlet.HTTPContext;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.util.thread.IdleTask;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;

public final class ServletManager
extends ObjectManager
implements IGLUELoggingConstants,
IConfigConstants {
    private WebMonitor webMonitor;
    private JSPMonitor jspMonitor;

    public ServletManager(WebApplication application) {
        super(application);
        if (application.isHotDeployable()) {
            this.webMonitor = new WebMonitor(this, application.getWebInfRoot());
            this.jspMonitor = new JSPMonitor(application);
        }
    }

    public String getObjectType() {
        return "servlets";
    }

    public void start() throws Exception {
        this.startWebApp();
        if (this.webMonitor != null) {
            this.webMonitor.start();
        }
        if (this.jspMonitor != null) {
            this.jspMonitor.start();
        }
        super.start();
    }

    public void stop() throws Exception {
        this.stopWebApp();
        if (this.webMonitor != null) {
            this.webMonitor.stop();
        }
        if (this.jspMonitor != null) {
            this.jspMonitor.stop();
        }
        super.stop();
    }

    public void startWebApp() {
        Elements configs = this.application.getConfig().getElements("webServer");
        while (configs.hasMoreElements()) {
            try {
                Element config = configs.next();
                ManagedServlets managedServlets = new ManagedServlets(this, config);
                this.add(managedServlets.getHTTPContext().getPath(), managedServlets);
            }
            catch (Exception exception) {
                if (!Log.isLogging(IGLUELoggingConstants.DEPLOY_EVENT | ILoggingConstants.ERROR_EVENT)) continue;
                Log.log(IGLUELoggingConstants.DEPLOY_EVENT | ILoggingConstants.ERROR_EVENT, this.getAppName() + ": could not start web application", exception);
            }
        }
    }

    public void stopWebApp() {
        this.stopAll();
    }

    public void restartWebApp() {
        IdleTask idleTask = new IdleTask();
        this.stopWebApp();
        this.startWebApp();
        idleTask.stop();
    }

    public String[] getServletNames() {
        TreeSet<String> servletNames = new TreeSet<String>();
        Enumeration enumeration = this.nameToObject.elements();
        while (enumeration.hasMoreElements()) {
            ManagedServlets context = (ManagedServlets)enumeration.nextElement();
            HTTPContext httpContext = context.getHTTPContext();
            Vector configs = httpContext.getConfigs();
            Enumeration configEnum = configs.elements();
            while (configEnum.hasMoreElements()) {
                Config config = (Config)configEnum.nextElement();
                servletNames.add(config.getServletName());
            }
        }
        String[] servletNamesArray = new String[servletNames.size()];
        servletNames.toArray(servletNamesArray);
        return servletNamesArray;
    }

    public void enableServlet(String name) throws DeploymentException {
        ManagedServlets context = this.getManagedServletsWithServlet(name);
        if (context == null) {
            throw new IllegalArgumentException("could not enable missing servlet " + name);
        }
        context.enableServlet(name);
    }

    public void disableServlet(String name) throws DeploymentException {
        ManagedServlets context = this.getManagedServletsWithServlet(name);
        if (context == null) {
            throw new IllegalArgumentException("could not disable missing servlet " + name);
        }
        context.disableServlet(name);
    }

    public HTTPContext getServletContext(String name) {
        ManagedServlets servlets = this.getManagedServletsWithServlet(name);
        return servlets.getHTTPContext();
    }

    private ManagedServlets getManagedServletsWithServlet(String name) {
        Enumeration enumeration = this.nameToObject.elements();
        while (enumeration.hasMoreElements()) {
            ManagedServlets context = (ManagedServlets)enumeration.nextElement();
            Config config = context.getConfigWithServletName(name);
            if (config == null) continue;
            return context;
        }
        return null;
    }

    public String getAppName() {
        return this.application.getAppName();
    }
}

