/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.ContentHandlerAlreadyRegisteredException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.transforms.Transform;
import org.apache.xml.security.transforms.implementations.FuncHere;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.I18n;
import org.apache.xml.security.utils.PRNG;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolver;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.compiler.FuncLoader;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.functions.Function;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Init {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$Init == null ? (class$org$apache$xml$security$Init = Init.class$("org.apache.xml.security.Init")) : class$org$apache$xml$security$Init).getName());
    private static boolean _alreadyInitialized = false;
    public static HashMap _contentHandlerHash;
    static /* synthetic */ Class class$org$apache$xml$security$Init;
    static /* synthetic */ Class class$org$apache$xml$security$transforms$implementations$FuncHere;

    public static final boolean isInitialized() {
        return _alreadyInitialized;
    }

    public static synchronized void init() {
        if (!_alreadyInitialized) {
            _alreadyInitialized = true;
            try {
                Object object;
                Object object2;
                Object[] objectArray;
                Object[] objectArray2;
                long l = System.currentTimeMillis();
                long l2 = System.currentTimeMillis();
                PRNG.init(new SecureRandom());
                long l3 = System.currentTimeMillis();
                long l4 = System.currentTimeMillis();
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                documentBuilderFactory.setValidating(false);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                String string = System.getProperty("org.apache.xml.security.resource.config");
                InputStream inputStream = Class.forName("org.apache.xml.security.Init").getResourceAsStream(string != null ? string : "resource/config.xml");
                Document document = documentBuilder.parse(inputStream);
                long l5 = System.currentTimeMillis();
                Element element = document.createElementNS(null, "nscontext");
                element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:x", "http://www.xmlsecurity.org/NS/#configuration");
                long l6 = System.currentTimeMillis();
                Attr attr = (Attr)XPathAPI.selectSingleNode((Node)document, (String)"/x:Configuration/x:ResourceBundles/@defaultLanguageCode", (Node)element);
                Attr attr2 = (Attr)XPathAPI.selectSingleNode((Node)document, (String)"/x:Configuration/x:ResourceBundles/@defaultCountryCode", (Node)element);
                String string2 = attr == null ? null : attr.getNodeValue();
                String string3 = attr2 == null ? null : attr2.getNodeValue();
                I18n.init(string2, string3);
                long l7 = System.currentTimeMillis();
                long l8 = System.currentTimeMillis();
                FunctionTable.installFunction((String)"here", (Expression)new FuncHere());
                log.debug((Object)("Registered class " + (class$org$apache$xml$security$transforms$implementations$FuncHere == null ? (class$org$apache$xml$security$transforms$implementations$FuncHere = Init.class$("org.apache.xml.security.transforms.implementations.FuncHere")) : class$org$apache$xml$security$transforms$implementations$FuncHere).getName() + " for XPath function 'here()' function in internal table"));
                FuncHereLoader funcHereLoader = new FuncHereLoader();
                for (int i = 0; i < FunctionTable.m_functions.length; ++i) {
                    FuncLoader funcLoader = FunctionTable.m_functions[i];
                    if (funcLoader == null) continue;
                    log.debug((Object)("Func " + i + " " + funcLoader.getName()));
                    if (!funcLoader.getName().equals(funcHereLoader.getName())) continue;
                    FunctionTable.m_functions[i] = funcHereLoader;
                }
                long l9 = System.currentTimeMillis();
                long l10 = System.currentTimeMillis();
                Canonicalizer.init();
                NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:CanonicalizationMethods/x:CanonicalizationMethod", (Node)element);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    String string4 = ((Element)nodeList.item(i)).getAttributeNS(null, "URI");
                    String string5 = ((Element)nodeList.item(i)).getAttributeNS(null, "JAVACLASS");
                    boolean bl = true;
                    try {
                        Class<?> clazz = Class.forName(string5);
                        objectArray2 = clazz.getMethods();
                        for (int j = 0; j < objectArray2.length; ++j) {
                            Method method = objectArray2[j];
                            if (!method.getDeclaringClass().getName().equals(string5)) continue;
                            log.debug(method.getDeclaringClass());
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        objectArray2 = new Object[]{string4, string5};
                        log.fatal((Object)I18n.translate("algorithm.classDoesNotExist", objectArray2));
                        bl = false;
                    }
                    if (!bl) continue;
                    log.debug((Object)("Canonicalizer.register(" + string4 + ", " + string5 + ")"));
                    Canonicalizer.register(string4, string5);
                }
                long l11 = System.currentTimeMillis();
                long l12 = System.currentTimeMillis();
                Transform.init();
                NodeList nodeList2 = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:TransformAlgorithms/x:TransformAlgorithm", (Node)element);
                for (int i = 0; i < nodeList2.getLength(); ++i) {
                    objectArray2 = ((Element)nodeList2.item(i)).getAttributeNS(null, "URI");
                    String string6 = ((Element)nodeList2.item(i)).getAttributeNS(null, "JAVACLASS");
                    boolean bl = true;
                    try {
                        Class.forName(string6);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        Object[] objectArray3 = new Object[]{objectArray2, string6};
                        log.fatal((Object)I18n.translate("algorithm.classDoesNotExist", objectArray3));
                        bl = false;
                    }
                    if (!bl) continue;
                    log.debug((Object)("Transform.register(" + (String)objectArray2 + ", " + string6 + ")"));
                    Transform.register((String)objectArray2, string6);
                }
                long l13 = System.currentTimeMillis();
                long l14 = System.currentTimeMillis();
                Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"/x:Configuration/x:JCEAlgorithmMappings", (Node)element);
                JCEMapper.init(element2);
                long l15 = System.currentTimeMillis();
                long l16 = System.currentTimeMillis();
                SignatureAlgorithm.providerInit();
                NodeList nodeList3 = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:SignatureAlgorithms/x:SignatureAlgorithm", (Node)element);
                for (int i = 0; i < nodeList3.getLength(); ++i) {
                    String string7 = ((Element)nodeList3.item(i)).getAttributeNS(null, "URI");
                    String string8 = ((Element)nodeList3.item(i)).getAttributeNS(null, "JAVACLASS");
                    boolean bl = true;
                    try {
                        Class<?> clazz = Class.forName(string8);
                        objectArray = clazz.getMethods();
                        for (int j = 0; j < objectArray.length; ++j) {
                            object2 = objectArray[j];
                            if (!((Method)object2).getDeclaringClass().getName().equals(string8)) continue;
                            log.debug(((Method)object2).getDeclaringClass());
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        objectArray = new Object[]{string7, string8};
                        log.fatal((Object)I18n.translate("algorithm.classDoesNotExist", objectArray));
                        bl = false;
                    }
                    if (!bl) continue;
                    log.debug((Object)("SignatureAlgorithm.register(" + string7 + ", " + string8 + ")"));
                    SignatureAlgorithm.register(string7, string8);
                }
                long l17 = System.currentTimeMillis();
                long l18 = System.currentTimeMillis();
                ResourceResolver.init();
                NodeList nodeList4 = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:ResourceResolvers/x:Resolver", (Node)element);
                for (int i = 0; i < nodeList4.getLength(); ++i) {
                    objectArray = ((Element)nodeList4.item(i)).getAttributeNS(null, "JAVACLASS");
                    String string9 = ((Element)nodeList4.item(i)).getAttributeNS(null, "DESCRIPTION");
                    if (string9 != null && string9.length() > 0) {
                        log.debug((Object)("Register Resolver: " + (String)objectArray + ": " + string9));
                    } else {
                        log.debug((Object)("Register Resolver: " + (String)objectArray + ": For unknown purposes"));
                    }
                    ResourceResolver.register((String)objectArray);
                }
                long l19 = System.currentTimeMillis();
                long l20 = System.currentTimeMillis();
                try {
                    KeyInfo.init();
                    _contentHandlerHash = new HashMap(10);
                    object2 = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:KeyInfo/x:ContentHandler", (Node)element);
                    for (int i = 0; i < object2.getLength(); ++i) {
                        String string10 = ((Element)object2.item(i)).getAttributeNS(null, "NAMESPACE");
                        String string11 = ((Element)object2.item(i)).getAttributeNS(null, "LOCALNAME");
                        object = ((Element)object2.item(i)).getAttributeNS(null, "JAVACLASS");
                        log.debug((Object)("KeyInfoContent: " + string10 + " " + string11 + " " + (String)object));
                        Init.registerKeyInfoContentHandler(string10, string11, (String)object);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
                long l21 = System.currentTimeMillis();
                long l22 = System.currentTimeMillis();
                KeyResolver.init();
                object = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:KeyResolver/x:Resolver", (Node)element);
                for (int i = 0; i < object.getLength(); ++i) {
                    String string12 = ((Element)object.item(i)).getAttributeNS(null, "JAVACLASS");
                    String string13 = ((Element)object.item(i)).getAttributeNS(null, "DESCRIPTION");
                    if (string13 != null && string13.length() > 0) {
                        log.debug((Object)("Register Resolver: " + string12 + ": " + string13));
                    } else {
                        log.debug((Object)("Register Resolver: " + string12 + ": For unknown purposes"));
                    }
                    KeyResolver.register(string12);
                }
                long l23 = System.currentTimeMillis();
                long l24 = System.currentTimeMillis();
                log.debug((Object)"Now I try to bind prefixes:");
                NodeList nodeList5 = XPathAPI.selectNodeList((Node)document, (String)"/x:Configuration/x:PrefixMappings/x:PrefixMapping", (Node)element);
                for (int i = 0; i < nodeList5.getLength(); ++i) {
                    String string14 = ((Element)nodeList5.item(i)).getAttributeNS(null, "namespace");
                    String string15 = ((Element)nodeList5.item(i)).getAttributeNS(null, "prefix");
                    log.debug((Object)("Now I try to bind " + string15 + " to " + string14));
                    ElementProxy.setDefaultPrefix(string14, string15);
                }
                long l25 = System.currentTimeMillis();
                long l26 = System.currentTimeMillis();
                log.debug((Object)("XX_init                             " + (int)(l26 - l) + " ms"));
                log.debug((Object)("  XX_prng                           " + (int)(l3 - l2) + " ms"));
                log.debug((Object)("  XX_parsing                        " + (int)(l5 - l4) + " ms"));
                log.debug((Object)("  XX_configure_i18n                 " + (int)(l7 - l6) + " ms"));
                log.debug((Object)("  XX_configure_reg_c14n             " + (int)(l11 - l10) + " ms"));
                log.debug((Object)("  XX_configure_reg_here             " + (int)(l9 - l8) + " ms"));
                log.debug((Object)("  XX_configure_reg_jcemapper        " + (int)(l15 - l14) + " ms"));
                log.debug((Object)("  XX_configure_reg_keyInfo          " + (int)(l21 - l20) + " ms"));
                log.debug((Object)("  XX_configure_reg_keyResolver      " + (int)(l23 - l22) + " ms"));
                log.debug((Object)("  XX_configure_reg_prefixes         " + (int)(l25 - l24) + " ms"));
                log.debug((Object)("  XX_configure_reg_resourceresolver " + (int)(l19 - l18) + " ms"));
                log.debug((Object)("  XX_configure_reg_sigalgos         " + (int)(l17 - l16) + " ms"));
                log.debug((Object)("  XX_configure_reg_transforms       " + (int)(l13 - l12) + " ms"));
            }
            catch (Exception exception) {
                log.fatal((Object)"Bad: ", (Throwable)exception);
                exception.printStackTrace();
            }
        }
    }

    public static void readUserConfiguration() throws XMLSecurityException {
        try {
            String string = System.getProperty("user.home") + "/" + ".xmlsecurityconfig";
            FileInputStream fileInputStream = new FileInputStream(string);
            Init.readUserConfiguration(fileInputStream);
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("generic.EmptyMessage", iOException);
        }
    }

    public static void readUserConfiguration(String string) throws XMLSecurityException {
        try {
            InputStream inputStream = null;
            File file = new File(string);
            inputStream = file.exists() ? new FileInputStream(file) : new URL(string).openStream();
            Init.readUserConfiguration(inputStream);
        }
        catch (IOException iOException) {
            throw new XMLSecurityException("generic.EmptyMessage", iOException);
        }
    }

    public static void readUserConfiguration(InputStream inputStream) throws XMLSecurityException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            Element element = XMLUtils.createDSctx(document, "x", "http://www.xmlsecurity.org/NS/#configuration");
            NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)"/x:AppConfiguration/x:KeyStore", (Node)element);
            for (int i = 0; i < nodeList.getLength(); ++i) {
            }
        }
        catch (Exception exception) {
            throw new XMLSecurityException("generic.EmptyMessage", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerKeyInfoContentHandler(String string, String string2, String string3) throws ContentHandlerAlreadyRegisteredException {
        String string4 = Init.qualifyNamespace(string, string2);
        if (_contentHandlerHash.containsKey(string4)) {
            log.error((Object)"Already registered");
            Object[] objectArray = new Object[]{string4, (String)_contentHandlerHash.get(string4)};
            throw new ContentHandlerAlreadyRegisteredException("algorithm.alreadyRegistered", objectArray);
        }
        HashMap hashMap = _contentHandlerHash;
        synchronized (hashMap) {
            _contentHandlerHash.put(string4, string3);
            log.debug((Object)("Init._contentHandlerHash.put(\"" + string4 + "\", \"" + string3 + "\")"));
            log.debug((Object)("Init._contentHandlerHash.size()=" + _contentHandlerHash.size()));
        }
    }

    private static String qualifyNamespace(String string, String string2) {
        return "{" + string + "}" + string2;
    }

    public static String getKeyInfoContentHandler(String string, String string2) {
        String string3 = Init.qualifyNamespace(string, string2);
        log.debug((Object)("Asked for handler for " + string3));
        if (_contentHandlerHash == null) {
            log.debug((Object)"But I can't help (hash==null) ");
            return null;
        }
        if (_contentHandlerHash.size() == 0) {
            log.debug((Object)"But I can't help (size()==0)");
            return null;
        }
        Set set = _contentHandlerHash.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            if (!string4.equals(string3)) continue;
            return (String)_contentHandlerHash.get(string4);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class FuncHereLoader
    extends FuncLoader {
        public FuncHereLoader() {
            super((class$org$apache$xml$security$transforms$implementations$FuncHere == null ? (class$org$apache$xml$security$transforms$implementations$FuncHere = Init.class$("org.apache.xml.security.transforms.implementations.FuncHere")) : class$org$apache$xml$security$transforms$implementations$FuncHere).getName(), 0);
        }

        public Function getFunction() throws TransformerException {
            return new FuncHere();
        }

        public String getName() {
            return (class$org$apache$xml$security$transforms$implementations$FuncHere == null ? (class$org$apache$xml$security$transforms$implementations$FuncHere = Init.class$("org.apache.xml.security.transforms.implementations.FuncHere")) : class$org$apache$xml$security$transforms$implementations$FuncHere).getName();
        }
    }
}

