/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.event.CVSEvent;
import org.netbeans.lib.cvsclient.event.FileAddedEvent;
import org.netbeans.lib.cvsclient.event.FileUpdatedEvent;
import org.netbeans.lib.cvsclient.file.FileHandler;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class UpdatedResponse
implements Response {
    private static final boolean DEBUG = false;
    private String localPath;
    private String repositoryPath;
    private String entryLine;
    private String mode;
    protected String localFile;
    private DateFormat dateFormatter;

    UpdatedResponse() {
    }

    public void process(LoggedDataInputStream dis, ResponseServices services) throws ResponseException {
        try {
            CVSEvent e;
            Date d;
            this.localPath = dis.readLine();
            this.repositoryPath = dis.readLine();
            this.entryLine = dis.readLine();
            this.mode = dis.readLine();
            String nextLine = dis.readLine();
            boolean useGzip = nextLine.charAt(0) == 'z';
            int length = Integer.parseInt(useGzip ? nextLine.substring(1) : nextLine);
            String filePath = services.convertPathname(this.localPath, this.repositoryPath);
            File newFile = new File(filePath);
            this.localFile = newFile.getAbsolutePath();
            Entry entry = new Entry(this.entryLine);
            FileHandler fileHandler = useGzip ? services.getGzipFileHandler() : services.getUncompressedFileHandler();
            fileHandler.setNextFileDate(services.getNextFileDate());
            if (entry.isBinary()) {
                fileHandler.writeBinaryFile(filePath, this.mode, dis, length);
            } else {
                fileHandler.writeTextFile(filePath, this.mode, dis, length);
            }
            String conflictString = null;
            if (entry.getConflict() != null && entry.getConflict().charAt(0) == '+') {
                if (entry.getConflict().charAt(1) == '=') {
                    d = new Date(newFile.lastModified());
                    conflictString = this.getEntryConflict(d, true);
                } else {
                    conflictString = entry.getConflict().substring(1);
                }
            } else {
                d = new Date(newFile.lastModified());
                conflictString = this.getEntryConflict(d, false);
            }
            entry.setConflict(conflictString);
            if (entry.isNewUserFile()) {
                entry.setConflict("dummy timestamp");
            }
            services.updateAdminData(this.localPath, this.repositoryPath, entry);
            if (newFile.exists()) {
                e = new FileAddedEvent(this, filePath);
                services.getEventManager().fireCVSEvent(e);
            } else {
                e = new FileUpdatedEvent(this, filePath);
                services.getEventManager().fireCVSEvent(e);
            }
        }
        catch (IOException e) {
            throw new ResponseException(e);
        }
    }

    protected String getEntryConflict(Date date, boolean hadConflicts) {
        return this.getDateFormatter().format(date);
    }

    protected DateFormat getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new SimpleDateFormat(Entry.getLastModifiedDateFormatter().toPattern(), Locale.US);
            this.dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT+0000"));
        }
        return this.dateFormatter;
    }

    public boolean isTerminalResponse() {
        return false;
    }
}

