/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.response;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.netbeans.lib.cvsclient.response.Response;
import org.netbeans.lib.cvsclient.response.ResponseException;
import org.netbeans.lib.cvsclient.response.ResponseServices;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;

class ModTimeResponse
implements Response {
    protected static final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.US);
    protected static final String SERVER_DATE_FORMAT = "dd MMM yyyy HH:mm:ss";

    static {
        dateFormatter.setTimeZone(TimeZone.getTimeZone("GMT+0000"));
    }

    ModTimeResponse() {
    }

    public void process(LoggedDataInputStream dis, ResponseServices services) throws ResponseException {
        try {
            String dateString = dis.readLine();
            Date date = dateFormatter.parse(dateString.substring(0, dateString.length() - 6));
            if (date.getTime() < 0L) {
                if (date.getYear() < 100 && date.getYear() >= 70) {
                    date.setYear(date.getYear() + 1900);
                } else if (date.getYear() >= 0 && date.getYear() < 70) {
                    date.setYear(date.getYear() + 2000);
                } else {
                    date.setYear(2000 + date.getYear());
                }
            }
            services.setNextFileDate(date);
        }
        catch (Exception e) {
            throw new ResponseException(e);
        }
    }

    public boolean isTerminalResponse() {
        return false;
    }
}

