/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.netbeans.lib.cvsclient.file.WriteTextFilePreprocessor;
import org.netbeans.lib.cvsclient.util.BugLog;
import org.netbeans.lib.cvsclient.util.ByteArray;

public class WriteRcsDiffFilePreprocessor
implements WriteTextFilePreprocessor {
    private static final int CHUNK_SIZE = 32768;
    private static final int READ_REMAINING = -2;
    private String lineEnding = "\n";

    public String getLineEnding() {
        return this.lineEnding;
    }

    public void setLineEnding(String lineEnding) {
        this.lineEnding = lineEnding;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copyTextFileToLocation(InputStream processedInput, File fileToWrite) throws IOException {
        ReadInfo tempFileReader = null;
        OutputStream out = null;
        ReadInfo tempDiffReader = null;
        File tempFile = null;
        try {
            try {
                tempDiffReader = new ReadInfo(new BufferedInputStream(processedInput));
                tempFileReader = new ReadInfo(new BufferedInputStream(new FileInputStream(fileToWrite)));
                File cvsSubdir = new File(fileToWrite.getParent(), "CVS");
                tempFile = File.createTempFile(".#merg", "cvs", cvsSubdir);
                out = new BufferedOutputStream(new FileOutputStream(tempFile));
                boolean fileStart = false;
                boolean diffCount = false;
                byte[] diff2 = tempDiffReader.readLine();
                while (true) {
                    block34: {
                        int count;
                        int startLine;
                        if (diff2 == null || diff2.length <= 0) {
                            this.readToLine(-2, tempFileReader, out);
                            if (tempFile == null) return;
                            tempFileReader.close();
                            out.close();
                            if (!fileToWrite.delete()) throw new IOException();
                            boolean ok = tempFile.renameTo(fileToWrite);
                            if (ok) return;
                            throw new IOException();
                        }
                        if (diff2[0] == 100) {
                            startLine = WriteRcsDiffFilePreprocessor.getStart(diff2);
                            count = WriteRcsDiffFilePreprocessor.getLength(diff2);
                            if (startLine >= 0 && count > 0) {
                                this.readToLine(startLine - 1, tempFileReader, out);
                                this.readToLine(startLine - 1 + count, tempFileReader, null);
                                break block34;
                            } else {
                                BugLog.getInstance().bug("wrong parsing.." + new String(diff2));
                                throw new IOException();
                            }
                        }
                        if (diff2[0] == 97) {
                            startLine = WriteRcsDiffFilePreprocessor.getStart(diff2);
                            count = WriteRcsDiffFilePreprocessor.getLength(diff2);
                            if (startLine >= 0 && count > 0) {
                                this.readToLine(startLine, tempFileReader, out);
                                tempDiffReader.setLineNumber(0);
                                this.readToLine(count, tempDiffReader, out);
                            } else {
                                BugLog.getInstance().bug("wrong parsing.." + new String(diff2));
                                throw new IOException();
                            }
                        }
                    }
                    diff2 = tempDiffReader.readLine();
                }
            }
            catch (Exception exc) {
                BugLog.getInstance().showException(exc);
                return;
            }
        }
        finally {
            if (tempDiffReader != null) {
                try {
                    tempDiffReader.close();
                }
                catch (IOException iOException) {}
            }
            if (tempFileReader != null) {
                try {
                    tempFileReader.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void readToLine(int finalLine, ReadInfo reader, OutputStream out) throws IOException {
        while (reader.getLineNumber() < finalLine || finalLine == -2) {
            byte[] line = reader.readLine();
            if (line == null) {
                return;
            }
            if (out == null) continue;
            out.write(line);
            out.write(this.getLineEnding().getBytes());
        }
    }

    private static int indexOf(byte[] bytes, byte b) {
        return WriteRcsDiffFilePreprocessor.indexOf(bytes, b, 0);
    }

    private static int indexOf(byte[] bytes, byte b, int start) {
        int index = -1;
        int i = start;
        while (i < bytes.length) {
            if (bytes[i] == b) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private static int getStart(byte[] diffLine) {
        int spacePos = WriteRcsDiffFilePreprocessor.indexOf(diffLine, (byte)32);
        if (spacePos > 0) {
            String number = new String(diffLine, 1, spacePos - 1);
            try {
                int toReturn = Integer.parseInt(number);
                return toReturn;
            }
            catch (NumberFormatException exc) {
                return -1;
            }
        }
        return -1;
    }

    private static int getLength(byte[] diffLine) {
        int spacePos = WriteRcsDiffFilePreprocessor.indexOf(diffLine, (byte)32);
        if (spacePos > 0) {
            int end = WriteRcsDiffFilePreprocessor.indexOf(diffLine, (byte)32, spacePos + 1);
            if (end < 0) {
                end = diffLine.length;
            }
            String number = new String(diffLine, spacePos + 1, end - spacePos - 1);
            try {
                int toReturn = Integer.parseInt(number);
                return toReturn;
            }
            catch (NumberFormatException exc) {
                return -1;
            }
        }
        return -1;
    }

    private static class ReadInfo {
        private PushbackInputStream in;
        private int readLength;
        private int startIndex;
        private int lineNumber;
        private ByteArray line;

        public ReadInfo(InputStream in) {
            this.in = new PushbackInputStream(in, 1);
            this.readLength = -1;
            this.startIndex = 0;
            this.lineNumber = 0;
            this.line = new ByteArray();
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public void setLineNumber(int lineNumber) {
            this.lineNumber = lineNumber;
        }

        public byte[] readLine() throws IOException {
            this.line.reset();
            boolean end = false;
            while (true) {
                int b;
                if ((b = this.in.read()) == -1) {
                    end = true;
                    break;
                }
                if (b == 10) {
                    ++this.lineNumber;
                    break;
                }
                if (b == 13) {
                    int next = this.in.read();
                    if (next != 10) {
                        this.in.unread(next);
                    }
                    ++this.lineNumber;
                    break;
                }
                this.line.add((byte)b);
            }
            byte[] bytes = this.line.getBytes();
            if (end && bytes.length == 0) {
                bytes = null;
            }
            return bytes;
        }

        public void close() throws IOException {
            if (this.in != null) {
                this.in.close();
            }
        }
    }
}

