/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.text.MessageFormat;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.connection.AbstractConnection;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;
import org.netbeans.lib.cvsclient.util.NonClosingOutputStream;

public class ExtConnection
extends AbstractConnection {
    public static final int DEFAULT_PORT = 22;
    private final String userName;
    private final String password;
    private final int port;
    private final String hostName;
    private Session session;
    private ChannelExec channel;

    public ExtConnection(CVSRoot cvsRoot) {
        if (!"ext".equals(cvsRoot.getMethod())) {
            throw new IllegalArgumentException("CVS Root '" + cvsRoot + "' does not represent :ext: connection type.");
        }
        String userName = cvsRoot.getUserName();
        if (userName == null) {
            userName = System.getProperty("user.name");
        }
        this.userName = userName;
        this.password = cvsRoot.getPassword();
        this.hostName = cvsRoot.getHostName();
        this.setRepository(cvsRoot.getRepository());
        int port = cvsRoot.getPort();
        if (port == 0) {
            port = 22;
        }
        this.port = port;
    }

    private void openConnection(final String password) throws AuthenticationException, CommandAbortedException {
        if (this.hostName == null) {
            String locMessage = AuthenticationException.getBundleString("AuthenticationException.HostIsNull");
            throw new AuthenticationException("HostIsNull", locMessage);
        }
        try {
            JSch jsch = new JSch();
            this.session = jsch.getSession(this.getUserName(), this.getHostName(), this.getPort());
            this.session.setUserInfo(new UserInfo(){

                public String getPassphrase() {
                    return null;
                }

                public String getPassword() {
                    return password;
                }

                public boolean promptPassword(String message) {
                    return true;
                }

                public boolean promptPassphrase(String message) {
                    return true;
                }

                public boolean promptYesNo(String message) {
                    return true;
                }

                public void showMessage(String message) {
                    System.err.println("Message from ssh: " + message);
                }
            });
            this.session.connect();
            this.channel = (ChannelExec)this.session.openChannel("exec");
            this.channel.setCommand("cvs server");
            this.channel.setXForwarding(false);
            LoggedDataOutputStream outputStream = new LoggedDataOutputStream(this.channel.getOutputStream());
            this.setOutputStream(outputStream);
            LoggedDataInputStream inputStream = new LoggedDataInputStream(this.channel.getInputStream());
            this.setInputStream(inputStream);
            this.channel.setErrStream((OutputStream)new NonClosingOutputStream(System.err));
            this.channel.connect();
            if (Thread.interrupted()) {
                this.reset();
                String localMsg = CommandException.getLocalMessage("Client.connectionAborted", null);
                throw new CommandAbortedException("Aborted during connecting to the server.", localMsg);
            }
        }
        catch (ConnectException ex) {
            this.reset();
            String locMessage = this.getLocalMessage("AuthenticationException.ConnectException", new Object[]{this.hostName, new Integer(this.port)});
            throw new AuthenticationException("ConnectException", ex, locMessage);
        }
        catch (NoRouteToHostException ex) {
            this.reset();
            String locMessage = this.getLocalMessage("AuthenticationException.NoRouteToHostException", new Object[]{this.hostName});
            throw new AuthenticationException("NoRouteToHostException", ex, locMessage);
        }
        catch (IOException ex) {
            this.reset();
            String locMessage = this.getLocalMessage("AuthenticationException.IOException", new Object[]{this.hostName});
            throw new AuthenticationException("IOException", ex, locMessage);
        }
        catch (JSchException e) {
            this.reset();
            String locMessage = this.getLocalMessage("AuthenticationException.JSchException", new Object[0]);
            throw new AuthenticationException("JSchException", e, locMessage);
        }
    }

    private void reset() {
        this.session = null;
        this.channel = null;
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    public void verify() throws AuthenticationException {
        try {
            this.open();
        }
        catch (CommandAbortedException commandAbortedException) {
            // empty catch block
        }
        if (this.session == null || this.channel == null) {
            return;
        }
        try {
            this.channel.disconnect();
        }
        finally {
            try {
                this.session.disconnect();
            }
            finally {
                this.reset();
            }
        }
    }

    public void open() throws AuthenticationException, CommandAbortedException {
        this.openConnection(this.getPassword());
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void close() throws IOException {
        if (!this.isOpen()) {
            return;
        }
        try {
            this.channel.disconnect();
        }
        finally {
            try {
                this.session.disconnect();
            }
            finally {
                this.reset();
            }
        }
    }

    public void modifyInputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyInputStream(this.getInputStream());
    }

    public void modifyOutputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyOutputStream(this.getOutputStream());
    }

    private String getLocalMessage(String key, Object[] arguments) {
        String locMessage = AuthenticationException.getBundleString(key);
        if (locMessage == null) {
            return null;
        }
        locMessage = MessageFormat.format(locMessage, arguments);
        return locMessage;
    }

    public boolean isOpen() {
        return this.session != null && this.channel != null && this.session.isConnected();
    }
}

