/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.connection;

import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ExtConnection;
import org.netbeans.lib.cvsclient.connection.LocalConnection;
import org.netbeans.lib.cvsclient.connection.PServerConnection;

public class ConnectionFactory {
    protected ConnectionFactory() {
    }

    public static Connection getConnection(String cvsRoot) throws IllegalArgumentException {
        CVSRoot root = CVSRoot.parse(cvsRoot);
        return ConnectionFactory.getConnection(root);
    }

    public static Connection getConnection(CVSRoot root) throws IllegalArgumentException {
        if (root.isLocal()) {
            LocalConnection con = new LocalConnection();
            con.setRepository(root.getRepository());
            return con;
        }
        String method = root.getMethod();
        if ("pserver" == method) {
            PServerConnection con = new PServerConnection(root);
            return con;
        }
        if ("ext" == method) {
            return new ExtConnection(root);
        }
        throw new IllegalArgumentException("Unrecognized CVS Root: " + root);
    }
}

