/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.commandLine.command;

import java.io.File;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateCommand;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateInformation;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateLine;
import org.netbeans.lib.cvsclient.commandLine.GetOpt;
import org.netbeans.lib.cvsclient.commandLine.ListenerProvider;
import org.netbeans.lib.cvsclient.commandLine.command.CommandProvider;
import org.netbeans.lib.cvsclient.event.CVSAdapter;
import org.netbeans.lib.cvsclient.event.CVSListener;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;
import org.netbeans.lib.cvsclient.event.TerminationEvent;

public class locbundlecheck
extends CVSAdapter
implements CommandProvider {
    private PrintStream out;
    private PrintStream err;
    private int realEnd = 0;
    private HashMap originalBundles;
    private HashMap localizedBundles;
    private String local;
    private String workDir;
    static /* synthetic */ Class class$0;

    public locbundlecheck() {
    }

    public String getName() {
        return "locbundlecheck";
    }

    public String[] getSynonyms() {
        return new String[]{"lbch", "lbcheck"};
    }

    public String getUsage() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.netbeans.lib.cvsclient.commandLine.command.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ResourceBundle.getBundle(String.valueOf(clazz.getPackage().getName()) + ".Bundle").getString("locbundlecheck.usage");
    }

    public void printShortDescription(PrintStream out) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.netbeans.lib.cvsclient.commandLine.command.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String msg = ResourceBundle.getBundle(String.valueOf(clazz.getPackage().getName()) + ".Bundle").getString("locbundlecheck.shortDescription");
        out.print(msg);
    }

    public void printLongDescription(PrintStream out) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.netbeans.lib.cvsclient.commandLine.command.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String msg = ResourceBundle.getBundle(String.valueOf(clazz.getPackage().getName()) + ".Bundle").getString("locbundlecheck.longDescription");
        out.println(msg);
    }

    public Command createCommand(String[] args, int index, GlobalOptions gopt, String workDir) {
        LocBundleAnnotateCommand command = new LocBundleAnnotateCommand();
        String getOptString = command.getOptString();
        GetOpt go = new GetOpt(args, String.valueOf(getOptString) + "i:");
        int ch = -1;
        go.optIndexSet(index);
        boolean usagePrint = false;
        String localization = null;
        while ((ch = go.getopt()) != -1) {
            if (ch == 105) {
                localization = go.optArgGet();
                command.setLocalization(localization);
                continue;
            }
            boolean ok = command.setCVSCommand((char)ch, go.optArgGet());
            if (ok) continue;
            usagePrint = true;
        }
        if (usagePrint || localization == null) {
            throw new IllegalArgumentException(this.getUsage());
        }
        int fileArgsIndex = go.optIndexGet();
        if (fileArgsIndex < args.length) {
            ArrayList fls = new ArrayList();
            if (workDir == null) {
                workDir = System.getProperty("user.dir");
            }
            command.setWorkDir(workDir);
            File workingDir = new File(workDir);
            int i = fileArgsIndex;
            while (i < args.length) {
                File fl = new File(workingDir, args[i]);
                if (fl.exists() && fl.isDirectory()) {
                    locbundlecheck.addFilesInDir(fls, fl, localization);
                } else if (fl.exists() && fl.getName().endsWith(".properties")) {
                    locbundlecheck.addFiles(fls, fl, localization);
                } else {
                    throw new IllegalArgumentException();
                }
                ++i;
            }
            if (fls.size() > 0) {
                File[] fileArgs = new File[fls.size()];
                fileArgs = fls.toArray(fileArgs);
                command.setFiles(fileArgs);
            } else {
                throw new IllegalArgumentException(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.no_file_spec"));
            }
        }
        return command;
    }

    private static void addFiles(Collection fileList, File origFile, String localization) {
        String origPath = origFile.getAbsolutePath();
        String enarg = String.valueOf(origPath.substring(0, origPath.length() - ".properties".length())) + "_" + localization + ".properties";
        File addfl = new File(enarg);
        fileList.add(origFile);
        if (addfl.exists()) {
            fileList.add(addfl);
        }
    }

    private static void addFilesInDir(Collection fileList, File origFile, String localization) {
        File[] files = origFile.listFiles();
        if (files != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                if (files[i].exists() && files[i].isDirectory()) {
                    locbundlecheck.addFilesInDir(fileList, files[i], localization);
                } else if (files[i].exists() && "Bundle.properties".equals(files[i].getName())) {
                    locbundlecheck.addFiles(fileList, files[i], localization);
                }
                ++i;
            }
        }
    }

    locbundlecheck(PrintStream stdout, PrintStream stderr, String localization, String workDir) {
        this.out = stdout;
        this.err = stderr;
        this.originalBundles = new HashMap();
        this.localizedBundles = new HashMap();
        this.local = localization;
        this.workDir = workDir;
    }

    public void fileInfoGenerated(FileInfoEvent e) {
        FileInfoContainer cont = e.getInfoContainer();
        if (cont.getFile().getName().indexOf("_" + this.local) >= 0) {
            this.localizedBundles.put(cont.getFile().getAbsolutePath(), cont);
        } else {
            this.originalBundles.put(cont.getFile().getAbsolutePath(), cont);
        }
        if (this.realEnd == 2) {
            this.generateOutput();
        }
    }

    public void commandTerminated(TerminationEvent e) {
        if (this.realEnd == 0) {
            this.realEnd = 1;
            return;
        }
        this.realEnd = 2;
    }

    private void generateOutput() {
        Iterator it = this.originalBundles.keySet().iterator();
        while (it.hasNext()) {
            String origPath = (String)it.next();
            int dotIndex = origPath.lastIndexOf(".");
            if (dotIndex < 0) {
                throw new IllegalStateException(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.illegal_state"));
            }
            String locPath = String.valueOf(origPath.substring(0, dotIndex)) + "_" + this.local + origPath.substring(dotIndex);
            AnnotateInformation origInfo = (AnnotateInformation)this.originalBundles.get(origPath);
            AnnotateInformation locInfo = (AnnotateInformation)this.localizedBundles.get(locPath);
            if (locInfo == null) {
                this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.noLocalizedFile"), origPath));
                continue;
            }
            this.localizedBundles.remove(locPath);
            HashMap origPropMap = this.createPropMap(origInfo);
            HashMap locPropMap = this.createPropMap(locInfo);
            String printFile = origPath;
            if (origPath.startsWith(this.workDir) && ((printFile = origPath.substring(this.workDir.length())).startsWith("/") || printFile.startsWith("\\"))) {
                printFile = printFile.substring(1);
            }
            this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.File"), printFile));
            Iterator propIt = origPropMap.keySet().iterator();
            while (propIt.hasNext()) {
                String prop = (String)propIt.next();
                AnnotateLine origLine = (AnnotateLine)origPropMap.get(prop);
                AnnotateLine locLine = (AnnotateLine)locPropMap.get(prop);
                if (locLine == null) {
                    this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.propMissing"), prop));
                    continue;
                }
                if (origLine.getDate().compareTo(locLine.getDate()) <= 0) continue;
                this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.prop_updated"), prop));
            }
        }
        if (this.localizedBundles.size() > 0) {
            Iterator locIt = this.localizedBundles.keySet().iterator();
            while (locIt.hasNext()) {
                String prop = (String)locIt.next();
                this.out.println(MessageFormat.format(ResourceBundle.getBundle("org/netbeans/lib/cvsclient/commandLine/command/Bundle").getString("locbundlecheck.prop_removed"), prop));
            }
        }
    }

    private HashMap createPropMap(AnnotateInformation info) {
        HashMap<String, AnnotateLine> propMap = new HashMap<String, AnnotateLine>();
        AnnotateLine line = info.getFirstLine();
        while (line != null) {
            String content = line.getContent();
            if (content.startsWith("#")) {
                line = info.getNextLine();
                continue;
            }
            int index = content.indexOf(61);
            if (index > 0) {
                String key = content.substring(0, index);
                propMap.put(key, line);
            }
            line = info.getNextLine();
        }
        return propMap;
    }

    private static class LocBundleAnnotateCommand
    extends AnnotateCommand
    implements ListenerProvider {
        private String loc;
        private String workDir;

        private LocBundleAnnotateCommand() {
        }

        public CVSListener createCVSListener(PrintStream stdout, PrintStream stderr) {
            return new locbundlecheck(stdout, stderr, this.loc, this.workDir);
        }

        public void setLocalization(String loc) {
            this.loc = loc;
        }

        public void setWorkDir(String dir) {
            this.workDir = dir;
        }
    }
}

