/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.commandLine;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ResourceBundle;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.commandLine.BasicListener;
import org.netbeans.lib.cvsclient.commandLine.CommandFactory;
import org.netbeans.lib.cvsclient.commandLine.GetOpt;
import org.netbeans.lib.cvsclient.commandLine.ListenerProvider;
import org.netbeans.lib.cvsclient.commandLine.command.CommandProvider;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionFactory;
import org.netbeans.lib.cvsclient.connection.PServerConnection;
import org.netbeans.lib.cvsclient.connection.StandardScrambler;
import org.netbeans.lib.cvsclient.event.CVSListener;

public class CVSCommand {
    private static final String HELP_OPTIONS = "--help-options";
    private static final String HELP_COMMANDS = "--help-commands";
    private static final String HELP_SYNONYMS = "--help-synonyms";
    private String repository;
    private String localPath;
    private Connection connection;
    private Client client;
    private GlobalOptions globalOptions;
    private int port = 0;
    static /* synthetic */ Class class$0;

    public boolean executeCommand(Command command) throws CommandException, AuthenticationException {
        return this.client.executeCommand(command, this.globalOptions);
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public void setGlobalOptions(GlobalOptions globalOptions) {
        this.globalOptions = globalOptions;
    }

    private void connect(CVSRoot root, String password) throws IllegalArgumentException, AuthenticationException, CommandAbortedException {
        this.connection = ConnectionFactory.getConnection(root);
        if ("pserver".equals(root.getMethod())) {
            ((PServerConnection)this.connection).setEncodedPassword(password);
            if (this.port > 0) {
                ((PServerConnection)this.connection).setPort(this.port);
            }
        }
        this.connection.open();
        this.client = new Client(this.connection, new StandardAdminHandler());
        this.client.setLocalPath(this.localPath);
    }

    private void addListener(CVSListener listener) {
        if (this.client != null) {
            this.client.getEventManager().addCVSListener(listener);
        }
    }

    private void close(PrintStream stderr) {
        try {
            this.connection.close();
        }
        catch (IOException e) {
            stderr.println("Unable to close connection: " + e);
        }
    }

    private static String getCVSRoot(String workingDir) {
        String root = null;
        BufferedReader r = null;
        if (workingDir == null) {
            workingDir = System.getProperty("user.dir");
        }
        try {
            try {
                File f = new File(workingDir);
                File rootFile = new File(f, "CVS/Root");
                if (rootFile.exists()) {
                    r = new BufferedReader(new FileReader(rootFile));
                    root = r.readLine();
                }
            }
            catch (IOException iOException) {}
        }
        finally {
            try {
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException e) {
                System.err.println("Warning: could not close CVS/Root file!");
            }
        }
        if (root == null) {
            root = System.getProperty("cvs.root");
        }
        return root;
    }

    private static int processGlobalOptions(String[] args, GlobalOptions globalOptions, PrintStream stderr) {
        String getOptString = globalOptions.getOptString();
        GetOpt go = new GetOpt(args, getOptString);
        int ch = -1;
        boolean usagePrint = false;
        while ((ch = go.getopt()) != -1) {
            boolean success = globalOptions.setCVSCommand((char)ch, go.optArgGet());
            if (success) continue;
            usagePrint = true;
        }
        if (usagePrint) {
            CVSCommand.showUsage(stderr);
            return -10;
        }
        return go.optIndexGet();
    }

    private static void showUsage(PrintStream stderr) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.netbeans.lib.cvsclient.commandLine.CVSCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String usageStr = ResourceBundle.getBundle(String.valueOf(clazz.getPackage().getName()) + ".Bundle").getString("MSG_HelpUsage");
        stderr.println(MessageFormat.format(usageStr, HELP_OPTIONS, HELP_COMMANDS, HELP_SYNONYMS));
    }

    private static boolean performLogin(String userName, String hostName, String repository, int port, GlobalOptions globalOptions) {
        PServerConnection c = new PServerConnection();
        c.setUserName(userName);
        String password = null;
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            System.out.print("Enter password: ");
            password = in.readLine();
        }
        catch (IOException e) {
            System.err.println("Could not read password: " + e);
            return false;
        }
        String encodedPassword = StandardScrambler.getInstance().scramble(password);
        c.setEncodedPassword(encodedPassword);
        c.setHostName(hostName);
        c.setRepository(repository);
        c.setPort(port);
        try {
            c.verify();
        }
        catch (AuthenticationException e) {
            System.err.println("Could not login to host " + hostName);
            return false;
        }
        File passFile = new File(System.getProperty("cvs.passfile", String.valueOf(System.getProperty("user.home")) + "/.cvspass"));
        BufferedWriter writer = null;
        BufferedReader reader = null;
        try {
            try {
                if (passFile.createNewFile()) {
                    writer = new BufferedWriter(new FileWriter(passFile));
                    writer.write(String.valueOf(globalOptions.getCVSRoot()) + " " + encodedPassword);
                    writer.close();
                } else {
                    String line;
                    File tempFile = File.createTempFile("cvs", "tmp", globalOptions.getTempDir());
                    reader = new BufferedReader(new FileReader(passFile));
                    writer = new BufferedWriter(new FileWriter(tempFile));
                    while ((line = reader.readLine()) != null) {
                        if (line.startsWith(globalOptions.getCVSRoot())) {
                            writer.write(String.valueOf(globalOptions.getCVSRoot()) + " " + encodedPassword);
                            continue;
                        }
                        writer.write(line);
                    }
                    reader.close();
                    writer.close();
                    File temp2File = File.createTempFile("cvs", "tmp", globalOptions.getTempDir());
                    passFile.renameTo(temp2File);
                    tempFile.renameTo(passFile);
                    temp2File.delete();
                    tempFile.delete();
                }
            }
            catch (IOException e) {
                System.err.println("Error: could not write password file to " + passFile);
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        System.err.println("Logged in successfully to repository " + repository + " on host " + hostName);
        return true;
    }

    private static String lookupPassword(String CVSRoot2, String CVSRootWithPort, PrintStream stderr) {
        File passFile = new File(System.getProperty("cvs.passfile", String.valueOf(System.getProperty("user.home")) + "/.cvspass"));
        BufferedReader reader = null;
        String password = null;
        try {
            try {
                String line;
                reader = new BufferedReader(new FileReader(passFile));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("/1 ")) {
                        line = line.substring("/1 ".length());
                    }
                    if (line.startsWith(CVSRoot2)) {
                        password = line.substring(CVSRoot2.length() + 1);
                    } else {
                        if (!line.startsWith(CVSRootWithPort)) continue;
                        password = line.substring(CVSRootWithPort.length() + 1);
                    }
                    break;
                }
            }
            catch (IOException e) {
                stderr.println("Could not read password for host: " + e);
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        stderr.println("Warning: could not close password file.");
                    }
                }
                return null;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    stderr.println("Warning: could not close password file.");
                }
            }
        }
        if (password == null) {
            stderr.println("Didn't find password for CVSROOT '" + CVSRoot2 + "'.");
        }
        return password;
    }

    public static void main(String[] args) {
        if (CVSCommand.processCommand(args, null, System.getProperty("user.dir"), System.out, System.err)) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public static boolean processCommand(String[] args, File[] files, String localPath, PrintStream stdout, PrintStream stderr) {
        return CVSCommand.processCommand(args, files, localPath, 0, stdout, stderr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean processCommand(String[] args, File[] files, String localPath, int port, PrintStream stdout, PrintStream stderr) {
        if (args.length > 0) {
            if (HELP_OPTIONS.equals(args[0])) {
                CVSCommand.printHelpOptions(stdout);
                return true;
            }
            if (HELP_COMMANDS.equals(args[0])) {
                CVSCommand.printHelpCommands(stdout);
                return true;
            }
            if (HELP_SYNONYMS.equals(args[0])) {
                CVSCommand.printHelpSynonyms(stdout);
                return true;
            }
        }
        try {
            localPath = new File(localPath).getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GlobalOptions globalOptions = new GlobalOptions();
        globalOptions.setCVSRoot(CVSCommand.getCVSRoot(localPath));
        int commandIndex = -1;
        try {
            commandIndex = CVSCommand.processGlobalOptions(args, globalOptions, stderr);
            if (commandIndex == -10) {
                return true;
            }
        }
        catch (IllegalArgumentException e) {
            stderr.println("Invalid argument: " + e);
            return false;
        }
        if (globalOptions.isShowHelp()) {
            CVSCommand.printHelp(commandIndex, args, stdout, stderr);
            return true;
        }
        if (globalOptions.isShowVersion()) {
            CVSCommand.printVersion(stdout, stderr);
            return true;
        }
        if (globalOptions.getCVSRoot() == null) {
            stderr.println("No CVS root is set. Use the cvs.root property, e.g. java -Dcvs.root=\":pserver:user@host:/usr/cvs\" or start the application in a directory containing a CVS subdirectory or use the -d command switch.");
            return false;
        }
        CVSRoot root = null;
        String cvsRoot = globalOptions.getCVSRoot();
        try {
            root = CVSRoot.parse(cvsRoot);
        }
        catch (IllegalArgumentException e) {
            stderr.println("Incorrect format for CVSRoot: " + cvsRoot + "\nThe correct format is: " + "[:method:][[user][:password]@][hostname:[port]]/path/to/repository" + "\nwhere \"method\" is pserver.");
            return false;
        }
        if (commandIndex >= args.length) {
            CVSCommand.showUsage(stderr);
            return false;
        }
        String command = args[commandIndex];
        if (command.equals("login")) {
            if ("pserver".equals(root.getMethod())) {
                return CVSCommand.performLogin(root.getUserName(), root.getHostName(), root.getRepository(), root.getPort(), globalOptions);
            }
            stderr.println("login does not apply for connection type '" + root.getMethod() + "'");
            return false;
        }
        Command c = null;
        try {
            c = CommandFactory.getDefault().createCommand(command, args, ++commandIndex, globalOptions, localPath);
        }
        catch (IllegalArgumentException e) {
            stderr.println("Illegal argument: " + e.getMessage());
            return false;
        }
        if (files != null && c instanceof BasicCommand) {
            ((BasicCommand)c).setFiles(files);
        }
        String password = null;
        if ("pserver".equals(root.getMethod())) {
            password = root.getPassword();
            if (password != null) {
                password = StandardScrambler.getInstance().scramble(password);
            } else {
                if (port > 0) {
                    root.setPort(port);
                }
                if ((password = CVSCommand.lookupPassword(cvsRoot, root.toString(), stderr)) == null) {
                    password = StandardScrambler.getInstance().scramble("");
                }
            }
        }
        CVSCommand cvsCommand = new CVSCommand();
        cvsCommand.setGlobalOptions(globalOptions);
        cvsCommand.setRepository(root.getRepository());
        if (port > 0) {
            cvsCommand.port = port;
        }
        cvsCommand.setLocalPath(localPath);
        try {
            boolean status2;
            cvsCommand.connect(root, password);
            CVSListener list = c instanceof ListenerProvider ? ((ListenerProvider)((Object)c)).createCVSListener(stdout, stderr) : new BasicListener(stdout, stderr);
            cvsCommand.addListener(list);
            boolean bl = status2 = cvsCommand.executeCommand(c);
            return bl;
        }
        catch (AuthenticationException aex) {
            stderr.println(aex.getLocalizedMessage());
            return false;
        }
        catch (CommandAbortedException caex) {
            stderr.println("Error: " + caex);
            Thread.currentThread().interrupt();
            return false;
        }
        catch (Exception t) {
            stderr.println("Error: " + t);
            t.printStackTrace(stderr);
            return false;
        }
        finally {
            if (cvsCommand != null) {
                cvsCommand.close(stderr);
            }
        }
    }

    private static void printHelpOptions(PrintStream stdout) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.netbeans.lib.cvsclient.commandLine.CVSCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String options = ResourceBundle.getBundle(String.valueOf(clazz.getPackage().getName()) + ".Bundle").getString("MSG_HelpOptions");
        stdout.println(options);
    }

    private static void printHelpCommands(PrintStream stdout) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.netbeans.lib.cvsclient.commandLine.CVSCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String msg = ResourceBundle.getBundle(String.valueOf(clazz.getPackage().getName()) + ".Bundle").getString("MSG_CVSCommands");
        stdout.println(msg);
        CommandProvider[] providers = CommandFactory.getDefault().getCommandProviders();
        Arrays.sort(providers, new CommandProvidersComparator());
        int maxNameLength = 0;
        int i = 0;
        while (i < providers.length) {
            int l = providers[i].getName().length();
            if (maxNameLength < l) {
                maxNameLength = l;
            }
            ++i;
        }
        maxNameLength += 2;
        i = 0;
        while (i < providers.length) {
            stdout.print("\t" + providers[i].getName());
            char[] spaces = new char[maxNameLength - providers[i].getName().length()];
            Arrays.fill(spaces, ' ');
            stdout.print(new String(spaces));
            providers[i].printShortDescription(stdout);
            stdout.println();
            ++i;
        }
    }

    private static void printHelpSynonyms(PrintStream stdout) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.netbeans.lib.cvsclient.commandLine.CVSCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String msg = ResourceBundle.getBundle(String.valueOf(clazz.getPackage().getName()) + ".Bundle").getString("MSG_CVSSynonyms");
        stdout.println(msg);
        CommandProvider[] providers = CommandFactory.getDefault().getCommandProviders();
        Arrays.sort(providers, new CommandProvidersComparator());
        int maxNameLength = 0;
        int i = 0;
        while (i < providers.length) {
            int l = providers[i].getName().length();
            if (maxNameLength < l) {
                maxNameLength = l;
            }
            ++i;
        }
        maxNameLength += 2;
        i = 0;
        while (i < providers.length) {
            String[] synonyms = providers[i].getSynonyms();
            if (synonyms.length > 0) {
                stdout.print("\t" + providers[i].getName());
                char[] spaces = new char[maxNameLength - providers[i].getName().length()];
                Arrays.fill(spaces, ' ');
                stdout.print(new String(spaces));
                int j = 0;
                while (j < synonyms.length) {
                    stdout.print(String.valueOf(synonyms[j]) + " ");
                    ++j;
                }
                stdout.println();
            }
            ++i;
        }
    }

    private static void printHelp(int commandIndex, String[] args, PrintStream stdout, PrintStream stderr) {
        if (commandIndex >= args.length) {
            CVSCommand.showUsage(stdout);
        } else {
            String cmdName = args[commandIndex];
            CommandProvider provider = CommandFactory.getDefault().getCommandProvider(cmdName);
            if (provider == null) {
                CVSCommand.printUnknownCommand(cmdName, stderr);
            } else {
                provider.printLongDescription(stdout);
            }
        }
    }

    private static void printVersion(PrintStream stdout, PrintStream stderr) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.netbeans.lib.cvsclient.commandLine.CVSCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String version = clazz.getPackage().getSpecificationVersion();
        stdout.println("Java Concurrent Versions System (JavaCVS) " + version + " (client)");
    }

    private static void printUnknownCommand(String commandName, PrintStream out) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.netbeans.lib.cvsclient.commandLine.CVSCommand");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String msg = ResourceBundle.getBundle(String.valueOf(clazz.getPackage().getName()) + ".Bundle").getString("MSG_UnknownCommand");
        out.println(MessageFormat.format(msg, commandName));
        CVSCommand.printHelpCommands(out);
    }

    private static final class CommandProvidersComparator
    implements Comparator {
        private CommandProvidersComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof CommandProvider) || !(o2 instanceof CommandProvider)) {
                throw new IllegalArgumentException("Can not compare objects " + o1 + " and " + o2);
            }
            return ((CommandProvider)o1).getName().compareTo(((CommandProvider)o2).getName());
        }
    }
}

