/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.log;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.lib.cvsclient.command.FileInfoContainer;
import org.netbeans.lib.cvsclient.util.BugLog;

public class LogInformation
extends FileInfoContainer {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private File file;
    private String repositoryFilename;
    private String headRevision;
    private String branch;
    private String accessList;
    private String keywordSubstitution;
    private String totalRevisions;
    private String selectedRevisions;
    private String description;
    private String locks;
    private final List revisions = new ArrayList();
    private final List symbolicNames = new ArrayList();
    private StringBuffer symNamesBuffer;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getRepositoryFilename() {
        return this.repositoryFilename;
    }

    public void setRepositoryFilename(String repositoryFilename) {
        this.repositoryFilename = repositoryFilename;
    }

    public String getHeadRevision() {
        return this.headRevision;
    }

    public void setHeadRevision(String headRevision) {
        this.headRevision = headRevision;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public String getAccessList() {
        return this.accessList;
    }

    public void setAccessList(String accessList) {
        this.accessList = accessList;
    }

    public String getKeywordSubstitution() {
        return this.keywordSubstitution;
    }

    public void setKeywordSubstitution(String keywordSubstitution) {
        this.keywordSubstitution = keywordSubstitution;
    }

    public String getTotalRevisions() {
        return this.totalRevisions;
    }

    public void setTotalRevisions(String totalRevisions) {
        this.totalRevisions = totalRevisions;
    }

    public String getSelectedRevisions() {
        return this.selectedRevisions;
    }

    public void setSelectedRevisions(String selectedRevisions) {
        this.selectedRevisions = selectedRevisions;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLocks() {
        return this.locks;
    }

    public void setLocks(String locks) {
        this.locks = locks;
    }

    public void addRevision(Revision newRevision) {
        this.revisions.add(newRevision);
    }

    public List getRevisionList() {
        return this.revisions;
    }

    public Revision getRevision(String number) {
        Iterator it = this.revisions.iterator();
        while (it.hasNext()) {
            Revision item = (Revision)it.next();
            if (!item.getNumber().equals(number)) continue;
            return item;
        }
        return null;
    }

    public void addSymbolicName(String symName, String revisionNumber) {
        SymName newName = new SymName();
        newName.setName(symName);
        newName.setRevision(revisionNumber);
        this.symbolicNames.add(newName);
    }

    public List getAllSymbolicNames() {
        return this.symbolicNames;
    }

    public List getSymNamesForRevision(String revNumber) {
        Iterator it = this.symbolicNames.iterator();
        LinkedList<SymName> list = new LinkedList<SymName>();
        while (it.hasNext()) {
            SymName item = (SymName)it.next();
            if (!item.getRevision().equals(revNumber)) continue;
            list.add(item);
        }
        return list;
    }

    public SymName getSymName(String symName) {
        Iterator it = this.symbolicNames.iterator();
        while (it.hasNext()) {
            SymName item = (SymName)it.next();
            if (!item.getName().equals(symName)) continue;
            return item;
        }
        return null;
    }

    public Revision createNewRevision(String number) {
        Revision rev = new Revision();
        rev.setNumber(number);
        return rev;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(30);
        buf.append("\nFile: " + (this.file != null ? this.file.getAbsolutePath() : "null"));
        buf.append("\nRepositoryFile: " + this.repositoryFilename);
        buf.append("\nHead revision: " + this.headRevision);
        return buf.toString();
    }

    public class SymName {
        private String name;
        private String revision;

        public String getName() {
            return this.name;
        }

        public void setName(String symName) {
            this.name = symName;
        }

        public void setRevision(String rev) {
            this.revision = rev;
        }

        public String getRevision() {
            return this.revision;
        }
    }

    public class Revision {
        private String number;
        private Date date;
        private String dateString;
        private String author;
        private String state;
        private String lines;
        private String message;
        private String branches;

        public LogInformation getLogInfoHeader() {
            return LogInformation.this;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public Date getDate() {
            return this.date;
        }

        public String getDateString() {
            return this.dateString;
        }

        public void setDateString(String dateString) {
            this.dateString = dateString;
            if (dateString == null) {
                this.date = null;
                return;
            }
            try {
                this.date = DATE_FORMAT.parse(dateString);
            }
            catch (Exception ex) {
                BugLog.getInstance().bug("Couldn't parse date " + dateString);
            }
        }

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }

        public String getLines() {
            return this.lines;
        }

        public void setLines(String lines) {
            this.lines = lines;
        }

        public int getAddedLines() {
            if (this.lines != null) {
                int start = this.lines.indexOf(43);
                int end = this.lines.indexOf(32);
                if (start >= 0 && end > start) {
                    String added = this.lines.substring(start + 1, end);
                    try {
                        int toReturn = Integer.parseInt(added);
                        return toReturn;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            return 0;
        }

        public int getRemovedLines() {
            int start;
            if (this.lines != null && (start = this.lines.indexOf(45)) >= 0) {
                String removed = this.lines.substring(start + 1);
                try {
                    int toReturn = Integer.parseInt(removed);
                    return toReturn;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return 0;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getBranches() {
            return this.branches;
        }

        public void setBranches(String branches) {
            this.branches = branches;
        }
    }
}

