/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.annotate;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.annotate.AnnotateBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.TerminationEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.EntryRequest;

public class AnnotateCommand
extends BasicCommand {
    protected EventManager eventManager;
    private boolean useHeadIfNotFound;
    private String annotateByDate;
    private String annotateByRevision;

    public Builder createBuilder(EventManager eventMan) {
        return new AnnotateBuilder(eventMan, this);
    }

    public void execute(ClientServices client, EventManager em) throws CommandException, AuthenticationException {
        this.eventManager = em;
        client.ensureConnection();
        super.execute(client, em);
        this.excludeBinaryFiles(this.requests);
        try {
            try {
                if (this.useHeadIfNotFound) {
                    this.requests.add(1, new ArgumentRequest("-f"));
                }
                if (this.annotateByDate != null && this.annotateByDate.length() > 0) {
                    this.requests.add(1, new ArgumentRequest("-D"));
                    this.requests.add(2, new ArgumentRequest(this.getAnnotateByDate()));
                }
                if (this.annotateByRevision != null && this.annotateByRevision.length() > 0) {
                    this.requests.add(1, new ArgumentRequest("-r"));
                    this.requests.add(2, new ArgumentRequest(this.getAnnotateByRevision()));
                }
                this.addRequestForWorkingDirectory(client);
                this.addArgumentRequests();
                this.addRequest(CommandRequest.ANNOTATE);
                client.processRequests(this.requests);
            }
            catch (CommandException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new CommandException(ex, ex.getLocalizedMessage());
            }
        }
        finally {
            this.requests.clear();
        }
    }

    private void excludeBinaryFiles(List requests) {
        Iterator it = requests.iterator();
        while (it.hasNext()) {
            EntryRequest req;
            Object obj = it.next();
            if (!(obj instanceof EntryRequest) || !(req = (EntryRequest)obj).getEntry().isBinary()) continue;
            it.remove();
            if (!it.hasNext()) continue;
            it.next();
            it.remove();
        }
    }

    public void commandTerminated(TerminationEvent e) {
        if (this.builder != null) {
            this.builder.outputDone();
        }
    }

    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public void setUseHeadIfNotFound(boolean useHeadIfNotFound) {
        this.useHeadIfNotFound = useHeadIfNotFound;
    }

    public String getAnnotateByDate() {
        return this.annotateByDate;
    }

    public void setAnnotateByDate(String annotateByDate) {
        this.annotateByDate = annotateByDate;
    }

    public String getAnnotateByRevision() {
        return this.annotateByRevision;
    }

    public void setAnnotateByRevision(String annotateByRevision) {
        this.annotateByRevision = annotateByRevision;
    }

    public String getCVSCommand() {
        StringBuffer toReturn = new StringBuffer("annotate ");
        toReturn.append(this.getCVSArguments());
        File[] files = this.getFiles();
        if (files != null) {
            int index = 0;
            while (index < files.length) {
                toReturn.append(String.valueOf(files[index].getName()) + " ");
                ++index;
            }
        }
        return toReturn.toString();
    }

    public boolean setCVSCommand(char opt, String optArg) {
        if (opt == 'R') {
            this.setRecursive(true);
        } else if (opt == 'l') {
            this.setRecursive(false);
        } else if (opt == 'r') {
            this.setAnnotateByRevision(optArg);
        } else if (opt == 'D') {
            this.setAnnotateByDate(optArg);
        } else if (opt == 'f') {
            this.setUseHeadIfNotFound(true);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "Rlr:D:f";
    }

    public void resetCVSCommand() {
        this.setRecursive(true);
        this.setAnnotateByDate(null);
        this.setAnnotateByRevision(null);
        this.setUseHeadIfNotFound(false);
    }

    public String getCVSArguments() {
        StringBuffer toReturn = new StringBuffer("");
        if (!this.isRecursive()) {
            toReturn.append("-l ");
        }
        if (this.getAnnotateByRevision() != null) {
            toReturn.append("-r ");
            toReturn.append(this.getAnnotateByRevision());
            toReturn.append(" ");
        }
        if (this.getAnnotateByDate() != null) {
            toReturn.append("-D ");
            toReturn.append(this.getAnnotateByDate());
            toReturn.append(" ");
        }
        if (this.isUseHeadIfNotFound()) {
            toReturn.append("-f ");
        }
        return toReturn.toString();
    }
}

