/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.ofbiz.test;

import com.atlassian.core.action.ActionDispatcher;
import com.atlassian.core.action.DefaultActionDispatcher;
import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.ofbiz.test.mock.MockSequenceUtil;
import com.atlassian.core.ofbiz.util.EntityUtils;
import com.opensymphony.user.DuplicateEntityException;
import com.opensymphony.user.Group;
import com.opensymphony.user.ImmutableException;
import com.opensymphony.user.User;
import com.opensymphony.user.UserManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.MemoryHelper;
import org.ofbiz.core.entity.SequenceUtil;
import org.ofbiz.core.entity.model.ModelEntity;
import webwork.action.ActionContext;

public class UtilsForTests {
    public static GenericValue getTestEntity(String entity, Map fields) {
        try {
            return EntityUtils.createValue(entity, fields);
        }
        catch (GenericEntityException e) {
            throw new EntityException(e);
        }
    }

    public static User getTestUser(String username) {
        try {
            return UserManager.getInstance().createUser(username);
        }
        catch (DuplicateEntityException e) {
            throw new DuplicateException(e);
        }
        catch (ImmutableException e) {
            throw new UnchangeableException(e);
        }
    }

    public static Group getTestGroup(String groupname) {
        try {
            return UserManager.getInstance().createGroup(groupname);
        }
        catch (DuplicateEntityException e) {
            throw new DuplicateException(e);
        }
        catch (ImmutableException e) {
            throw new UnchangeableException(e);
        }
    }

    public static GenericValue getTestConstant(String entity, Map params) {
        try {
            if (params == null) {
                params = new HashMap<String, String>();
            }
            if (params.get("id") == null) {
                String id = EntityUtils.getNextStringId(entity);
                params.put("id", id);
            }
            GenericValue v = CoreFactory.getGenericDelegator().makeValue(entity, params);
            v = v.create();
            return v;
        }
        catch (GenericEntityException e) {
            throw new EntityException(e);
        }
    }

    public static void cleanUsers() throws Exception {
        Iterator iterator = UserManager.getInstance().getUsers().iterator();
        while (iterator.hasNext()) {
            ((User)iterator.next()).remove();
        }
        iterator = UserManager.getInstance().getGroups().iterator();
        while (iterator.hasNext()) {
            ((Group)iterator.next()).remove();
        }
    }

    public static void cleanWebWork() {
        ActionContext.setContext((ActionContext)new ActionContext());
        CoreFactory.setActionDispatcher((ActionDispatcher)new DefaultActionDispatcher());
    }

    public static void cleanOFBiz() {
        MemoryHelper.clearCache();
        String helperName = CoreFactory.getGenericDelegator().getEntityHelperName("SequenceValueItem");
        ModelEntity seqEntity = CoreFactory.getGenericDelegator().getModelEntity("SequenceValueItem");
        CoreFactory.getGenericDelegator().setSequencer((SequenceUtil)new MockSequenceUtil(helperName, seqEntity, "seqName", "seqId"));
    }

    public static void checkSingleElementCollection(TestCase test, Collection collection, Object expected) {
        Assert.assertEquals((int)1, (int)collection.size());
        Assert.assertTrue((boolean)collection.contains(expected));
    }

    public static class UnchangeableException
    extends RuntimeException {
        UnchangeableException(ImmutableException ex) {
            super((Throwable)ex);
        }
    }

    public static class EntityException
    extends RuntimeException {
        EntityException(GenericEntityException ex) {
            super(ex);
        }
    }

    public static class DuplicateException
    extends RuntimeException {
        DuplicateException(DuplicateEntityException ex) {
            super((Throwable)ex);
        }
    }
}

