/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ClobDBAccess;
import oracle.sql.DatumWithConnection;

public class CLOB
extends DatumWithConnection
implements Clob {
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    ClobDBAccess dbaccess;
    private int dbChunkSize = -1;
    private short csform;
    boolean isFree = false;
    boolean fromObject = false;
    long cachedLengthOfClobInChars = -1L;
    char[] prefetchData = null;
    int prefetchDataSize = 0;
    boolean activePrefetch = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Jul_31_19:28:36_PDT_2009";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    protected CLOB() {
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection) throws SQLException {
        this(oracleConnection, null);
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, boolean bl) throws SQLException {
        this(oracleConnection, byArray);
        this.fromObject = bl;
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray) throws SQLException {
        super(byArray);
        if (byArray != null) {
            this.csform = (byArray[5] & 0x40) != 0 && (byArray[5] & 0xFFFFFF80) == 0 ? (short)2 : (short)1;
        }
        CLOB.assertNotNull(oracleConnection);
        this.setPhysicalConnectionOf(oracleConnection);
        this.dbaccess = ((OracleConnection)oracleConnection).createClobDBAccess();
    }

    public CLOB(oracle.jdbc.OracleConnection oracleConnection, byte[] byArray, short s2) throws SQLException {
        this(oracleConnection, byArray);
        this.csform = s2;
    }

    public boolean isNCLOB() {
        return this.csform == 2;
    }

    public long length() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        long l2 = -1L;
        l2 = this.activePrefetch && this.cachedLengthOfClobInChars != -1L ? this.cachedLengthOfClobInChars : this.getDBAccess().length(this);
        return l2;
    }

    public String getSubString(long l2, int n2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 < 0 || l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string = null;
        if (n2 == 0 || this.activePrefetch && (this.cachedLengthOfClobInChars == 0L || this.cachedLengthOfClobInChars > 0L && l2 - 1L >= this.cachedLengthOfClobInChars)) {
            string = new String();
        } else if (this.prefetchData != null && this.prefetchDataSize > 0 && this.cachedLengthOfClobInChars == (long)this.prefetchDataSize && l2 + (long)n2 - 1L <= this.cachedLengthOfClobInChars) {
            string = new String(this.prefetchData, (int)l2 - 1, n2);
        } else {
            char[] cArray = this.getDBAccess().getCharBufferSync(n2);
            int n3 = this.getChars(l2, n2, cArray);
            string = n3 > 0 ? new String(cArray, 0, n3) : new String();
            this.getDBAccess().cacheBufferSync(cArray);
        }
        return string;
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newReader(this, this.getBufferSize(), 0L);
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), 0L);
    }

    public long position(String string, long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().position(this, string, l2);
    }

    public long position(Clob clob, long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().position(this, (CLOB)clob, l2);
    }

    public int getChars(long l2, int n2, char[] cArray) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().getChars(this, l2, n2, cArray);
    }

    public Writer getCharacterOutputStream() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.setCharacterStream(1L);
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.setAsciiStream(1L);
    }

    public byte[] getLocator() {
        return this.getBytes();
    }

    public void setLocator(byte[] byArray) {
        this.setBytes(byArray);
    }

    public int putChars(long l2, char[] cArray) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().putChars(this, l2, cArray, 0, cArray != null ? cArray.length : 0);
    }

    public int putChars(long l2, char[] cArray, int n2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().putChars(this, l2, cArray, 0, n2);
    }

    public int putChars(long l2, char[] cArray, int n2, int n3) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().putChars(this, l2, cArray, n2, n3);
    }

    public int putString(long l2, String string) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.setString(l2, string);
    }

    public int getChunkSize() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.dbChunkSize <= 0) {
            this.dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.dbChunkSize;
    }

    public int getBufferSize() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n2 = this.getChunkSize();
        int n3 = 0;
        n3 = n2 >= 32768 || n2 <= 0 ? 32768 : 32768 / n2 * n2;
        return n3;
    }

    public static CLOB empty_lob() throws SQLException {
        return CLOB.getEmptyCLOB();
    }

    public static CLOB getEmptyCLOB() throws SQLException {
        byte[] byArray = new byte[86];
        byArray[1] = 84;
        byArray[5] = 24;
        CLOB cLOB = new CLOB();
        cLOB.setShareBytes(byArray);
        return cLOB;
    }

    public boolean isEmptyLob() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (this.shareBytes()[5] & 0x10) != 0;
    }

    public boolean isSecureFile() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        boolean bl = (this.shareBytes()[7] & 0xFFFFFF80) != 0;
        return bl;
    }

    public OutputStream getAsciiOutputStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l2, false);
    }

    public Writer getCharacterOutputStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newWriter(this, this.getBufferSize(), l2, false);
    }

    public InputStream getAsciiStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newInputStream(this, this.getBufferSize(), l2);
    }

    public Reader getCharacterStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newReader(this, this.getBufferSize(), l2);
    }

    public void trim(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.truncate(l2);
    }

    public static CLOB createTemporary(Connection connection, boolean bl, int n2) throws SQLException {
        return CLOB.createTemporary(connection, bl, n2, (short)1);
    }

    public static CLOB createTemporary(Connection connection, boolean bl, int n2, short s2) throws SQLException {
        int n3 = n2;
        if (n2 == 1) {
            n3 = 10;
        }
        if (n2 == 2) {
            n3 = 12;
        }
        if (connection == null || n3 != 10 && n3 != 12) {
            SQLException sQLException = DatabaseError.createSqlException(null, 68, "'conn' should not be null and 'duration' should either be equal to DURATION_SESSION or DURATION_CALL");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        OracleConnection oracleConnection = ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin();
        CLOB cLOB = CLOB.getDBAccess(oracleConnection).createTemporaryClob(oracleConnection, bl, n3, s2);
        cLOB.csform = s2;
        return cLOB;
    }

    public static void freeTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return;
        }
        cLOB.freeTemporary();
    }

    public static boolean isTemporary(CLOB cLOB) throws SQLException {
        if (cLOB == null) {
            return false;
        }
        return cLOB.isTemporary();
    }

    public void freeTemporary() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.getDBAccess().freeTemporary(this, this.fromObject);
    }

    public boolean isTemporary() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().isTemporary(this);
    }

    public void open(int n2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.getDBAccess().open(this, n2);
    }

    public void close() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.getDBAccess().close(this);
    }

    public boolean isOpen() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().isOpen(this);
    }

    public int setString(long l2, String string) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n2 = 0;
        if (string != null && string.length() != 0) {
            n2 = this.putChars(l2, string.toCharArray());
        }
        return n2;
    }

    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 < 1L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'pos' should not be < 1");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 < 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'offset' should not be < 0");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n2 + n3 > string.length()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, " 'offset + len' should not be exceed string length. ");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n4 = 0;
        if (string != null && string.length() != 0) {
            n4 = this.putChars(l2, string.toCharArray(), n2, n3);
        }
        return n4;
    }

    public OutputStream setAsciiStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), l2, true);
    }

    public Writer setCharacterStream(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.getDBAccess().newWriter(this, this.getBufferSize(), l2, true);
    }

    public void truncate(long l2) throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (l2 < 0L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, " 'len' should not be < 0");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.getDBAccess().trim(this, l2);
    }

    public Object toJdbc() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this;
    }

    public boolean isConvertibleTo(Class clazz) {
        String string = clazz.getName();
        return string.compareTo("java.io.InputStream") == 0 || string.compareTo("java.io.Reader") == 0;
    }

    public Reader characterStreamValue() throws SQLException {
        return this.getCharacterStream();
    }

    public InputStream asciiStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public InputStream binaryStreamValue() throws SQLException {
        return this.getAsciiStream();
    }

    public String stringValue() throws SQLException {
        Reader reader = this.getCharacterStream();
        int n2 = this.getBufferSize();
        int n3 = 0;
        StringWriter stringWriter = new StringWriter(n2);
        char[] cArray = new char[n2];
        try {
            while ((n3 = reader.read(cArray)) != -1) {
                stringWriter.write(cArray, 0, n3);
            }
        }
        catch (IOException iOException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 151);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return stringWriter.getBuffer().substring(0);
    }

    public Object makeJdbcArray(int n2) {
        return new CLOB[n2];
    }

    public ClobDBAccess getDBAccess() throws SQLException {
        if (this.dbaccess == null) {
            if (this.isEmptyLob()) {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 98);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.dbaccess = this.getInternalConnection().createClobDBAccess();
        }
        if (this.getPhysicalConnection().isClosed()) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.dbaccess;
    }

    public static ClobDBAccess getDBAccess(Connection connection) throws SQLException {
        return ((oracle.jdbc.OracleConnection)connection).physicalConnectionWithin().createClobDBAccess();
    }

    public Connection getJavaSqlConnection() throws SQLException {
        if (this.isFree) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return super.getJavaSqlConnection();
    }

    public final void setLength(long l2) {
        this.cachedLengthOfClobInChars = l2;
    }

    public final void setChunkSize(int n2) {
        this.dbChunkSize = n2;
    }

    public final void setPrefetchedData(char[] cArray) {
        if (cArray == null) {
            this.setPrefetchedData(null, 0);
        } else {
            this.setPrefetchedData(cArray, cArray.length);
        }
    }

    public final void setPrefetchedData(char[] cArray, int n2) {
        this.prefetchData = cArray;
        this.prefetchDataSize = n2;
    }

    public final char[] getPrefetchedData() {
        return this.prefetchData;
    }

    public final int getPrefetchedDataSize() {
        return this.prefetchDataSize;
    }

    public final void setActivePrefetch(boolean bl) {
        if (this.activePrefetch && !bl) {
            this.clearCachedData();
        }
        this.activePrefetch = bl;
    }

    public final void clearCachedData() {
        this.cachedLengthOfClobInChars = -1L;
        this.prefetchData = null;
    }

    public final boolean isActivePrefetch() {
        return this.activePrefetch;
    }
}

