/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.servlet.ContentTypeResolver;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadStrategy;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginResourceDownload
implements DownloadStrategy {
    private static final Log log = LogFactory.getLog(PluginResourceDownload.class);
    private String characterEncoding = "UTF-8";
    private PluginResourceLocator pluginResourceLocator;
    private ContentTypeResolver contentTypeResolver;

    public PluginResourceDownload() {
    }

    public PluginResourceDownload(PluginResourceLocator pluginResourceLocator, ContentTypeResolver contentTypeResolver, String characterEncoding) {
        this.characterEncoding = characterEncoding;
        this.pluginResourceLocator = pluginResourceLocator;
        this.contentTypeResolver = contentTypeResolver;
    }

    @Override
    public boolean matches(String urlPath) {
        return this.pluginResourceLocator.matches(urlPath);
    }

    @Override
    public void serveFile(HttpServletRequest request, HttpServletResponse response) throws DownloadException {
        try {
            String requestUri = URLDecoder.decode(request.getRequestURI(), this.characterEncoding);
            DownloadableResource downloadableResource = this.pluginResourceLocator.getDownloadableResource(requestUri, this.getQueryParameters(request));
            if (downloadableResource == null) {
                log.info((Object)("Could not locate resource: " + request.getRequestURI()));
                response.sendError(404);
                return;
            }
            if (downloadableResource.isResourceModified(request, response)) {
                log.info((Object)("Plugin Resource has been modified since plugin was loaded. Skipping: " + requestUri));
                return;
            }
            String contentType = this.getContentType(requestUri, downloadableResource);
            if (contentType != null) {
                response.setContentType(contentType);
            }
            downloadableResource.serveResource(request, response);
        }
        catch (IOException e) {
            throw new DownloadException(e);
        }
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContentTypeResolver(ContentTypeResolver contentTypeResolver) {
        this.contentTypeResolver = contentTypeResolver;
    }

    public void setPluginResourceLocator(PluginResourceLocator pluginResourceLocator) {
        this.pluginResourceLocator = pluginResourceLocator;
    }

    private String getContentType(String requestUri, DownloadableResource downloadableResource) {
        String contentType = downloadableResource.getContentType();
        if (contentType == null) {
            return this.contentTypeResolver.getContentType(requestUri);
        }
        return contentType;
    }

    private Map<String, String> getQueryParameters(HttpServletRequest request) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        Map parameters = request.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            if (entry.getValue() == null || ((String[])entry.getValue()).length <= 0) continue;
            result.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return result;
    }
}

