/*
 * Decompiled with CFR 0.152.
 */
package com.infomata.data;

import com.infomata.data.DataFormat;
import com.infomata.data.DataRow;
import java.util.Iterator;

public class FixedWidthFormat
implements DataFormat {
    private int[] beg = null;
    private int[] width = null;
    private static final char SPACE = ' ';

    public FixedWidthFormat(int[] widths) {
        this.beg = new int[widths.length];
        this.width = new int[widths.length];
        System.arraycopy(widths, 0, this.width, 0, widths.length);
        System.arraycopy(widths, 0, this.beg, 1, widths.length - 1);
        if (this.beg.length > 2) {
            for (int i = 2; i < this.beg.length; ++i) {
                int n = i;
                this.beg[n] = this.beg[n] + this.beg[i - 1];
            }
        }
    }

    public DataRow parseLine(String line) {
        DataRow row = null;
        if (line != null) {
            row = new DataRow();
            for (int i = 0; i < this.width.length; ++i) {
                if (i == this.width.length - 1) {
                    row.add(line.substring(this.beg[i]).trim());
                    continue;
                }
                String val = line.substring(this.beg[i], this.beg[i + 1]);
                row.add(val.trim());
            }
        }
        return row;
    }

    public String format(DataRow row) {
        StringBuffer o = new StringBuffer();
        Iterator i = row.iterator();
        for (int cnt = 0; i.hasNext() && cnt < this.beg.length; ++cnt) {
            String c = (String)i.next();
            int diff = this.width[cnt] - c.length();
            if (diff > 0) {
                o.append(c);
                for (int j = 0; j < diff; ++j) {
                    o.append(' ');
                }
                continue;
            }
            if (diff < 0) {
                o.append(c.substring(0, this.width[cnt]));
                continue;
            }
            o.append(c);
        }
        return o.toString();
    }
}

