/*
 * Decompiled with CFR 0.152.
 */
package com.infomata.data;

import com.infomata.data.DataFormat;
import com.infomata.data.DataRow;
import java.util.Iterator;

public class CSVFormat
implements DataFormat {
    private DataRow row = null;
    private String remainder = null;
    private static final char QUOTE = '\"';
    private static final char NEW_LINE = '\n';
    private static final char COMMA = ',';

    public String format(DataRow row) {
        StringBuffer o = new StringBuffer();
        Iterator items = row.iterator();
        while (items.hasNext()) {
            if (o.length() > 0) {
                o.append(",");
            }
            String cell = (String)items.next();
            o.append(this.encode(cell));
        }
        return o.toString();
    }

    public DataRow parseLine(String line) {
        DataRow res = null;
        if (this.row == null) {
            this.row = new DataRow();
        } else {
            line = this.remainder + '\n' + line;
        }
        int offset = 0;
        boolean paired = true;
        if (line != null) {
            char[] cs = line.toCharArray();
            for (int i = 0; i < cs.length; ++i) {
                if (cs[i] == '\"') {
                    paired = !paired;
                    continue;
                }
                if (cs[i] != ',' || !paired) continue;
                this.row.add(CSVFormat.decode(cs, offset, i - offset));
                offset = i + 1;
            }
            if (paired) {
                if (offset < cs.length) {
                    this.row.add(CSVFormat.decode(cs, offset, cs.length - offset));
                }
                res = this.row;
                this.row = null;
            } else {
                this.remainder = new String(cs, offset, cs.length - offset);
            }
        }
        return res;
    }

    private String encode(String datum) {
        String res = null;
        if (datum == null) {
            res = "null";
        } else if (datum.length() == 0) {
            res = "";
        } else if (datum.indexOf(34) >= 0 || datum.indexOf(44) >= 0 || datum.indexOf(10) >= 0 || Character.isWhitespace(datum.charAt(0))) {
            StringBuffer o = new StringBuffer();
            o.append('\"');
            char[] cs = datum.toCharArray();
            for (int i = 0; i < cs.length; ++i) {
                if (cs[i] == '\"') {
                    o.append('\"');
                }
                o.append(cs[i]);
            }
            o.append('\"');
            res = o.toString();
        } else {
            res = datum;
        }
        return res;
    }

    private static String decode(char[] cs, int offset, int len) {
        while (Character.isWhitespace(cs[offset]) && offset < cs.length) {
            ++offset;
            --len;
        }
        int end = offset + len - 1;
        StringBuffer o = new StringBuffer();
        if (cs[offset] == '\"' && cs[end] == '\"') {
            for (int i = offset + 1; i < end; ++i) {
                if (cs[i] == '\"') {
                    ++i;
                }
                if (i >= end) continue;
                o.append(cs[i]);
            }
        } else {
            o.append(cs, offset, len);
        }
        return o.toString();
    }
}

