/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.stats;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilHttp;
import org.ofbiz.core.util.UtilProperties;
import org.ofbiz.core.util.UtilValidate;

public class VisitHandler {
    public static final String module = VisitHandler.class.getName();

    public static void setInitialVisit(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String webappName = UtilHttp.getApplicationName((HttpServletRequest)request);
        StringBuffer fullRequestUrl = UtilHttp.getFullRequestUrl((HttpServletRequest)request);
        String initialLocale = request.getLocale() != null ? request.getLocale().toString() : "";
        String initialRequest = fullRequestUrl.toString();
        String initialReferrer = request.getHeader("Referer") != null ? request.getHeader("Referer") : "";
        String initialUserAgent = request.getHeader("User-Agent") != null ? request.getHeader("User-Agent") : "";
        session.setAttribute("_CLIENT_LOCALE_", (Object)request.getLocale());
        session.setAttribute("_CLIENT_REQUEST_", (Object)initialRequest);
        session.setAttribute("_CLIENT_USER_AGENT_", (Object)initialUserAgent);
        session.setAttribute("_CLIENT_REFERER_", (Object)initialUserAgent);
        VisitHandler.setInitials(request, session, initialLocale, initialRequest, initialReferrer, initialUserAgent, webappName);
    }

    public static void setInitials(HttpServletRequest request, HttpSession session, String initialLocale, String initialRequest, String initialReferrer, String initialUserAgent, String webappName) {
        GenericValue visit = VisitHandler.getVisit(session);
        if (visit != null) {
            visit.set("initialLocale", (Object)initialLocale);
            if (initialRequest != null) {
                visit.set("initialRequest", (Object)(initialRequest.length() > 250 ? initialRequest.substring(0, 250) : initialRequest));
            }
            if (initialReferrer != null) {
                visit.set("initialReferrer", (Object)(initialReferrer.length() > 250 ? initialReferrer.substring(0, 250) : initialReferrer));
            }
            if (initialUserAgent != null) {
                visit.set("initialUserAgent", (Object)(initialUserAgent.length() > 250 ? initialUserAgent.substring(0, 250) : initialUserAgent));
            }
            visit.set("webappName", (Object)webappName);
            visit.set("clientIpAddress", (Object)request.getRemoteAddr());
            visit.set("clientHostName", (Object)request.getRemoteHost());
            visit.set("clientUser", (Object)request.getRemoteUser());
            try {
                visit.store();
            }
            catch (GenericEntityException e) {
                Debug.logError((Throwable)e, (String)"Could not update visit:", (String)module);
            }
        }
    }

    public static void setUserLogin(HttpSession session, GenericValue userLogin, boolean userCreated) {
        if (userLogin == null) {
            return;
        }
        GenericValue visit = VisitHandler.getVisit(session);
        if (visit != null) {
            visit.set("userLoginId", userLogin.get("userLoginId"));
            visit.set("partyId", userLogin.get("partyId"));
            visit.set("userCreated", (Object)new Boolean(userCreated));
            try {
                visit.store();
            }
            catch (GenericEntityException e) {
                Debug.logError((Throwable)e, (String)"Could not update visit:", (String)module);
            }
        }
    }

    public static String getVisitId(HttpSession session) {
        GenericValue visit = VisitHandler.getVisit(session);
        if (visit != null) {
            return visit.getString("visitId");
        }
        return null;
    }

    public static GenericValue getVisit(HttpSession session) {
        if (!UtilProperties.propertyValueEqualsIgnoreCase((String)"serverstats", (String)"stats.persist.visit", (String)"false")) {
            GenericValue visit = (GenericValue)session.getAttribute("visit");
            if (visit == null) {
                GenericDelegator delegator = null;
                String delegatorName = (String)session.getAttribute("delegatorName");
                if (UtilValidate.isNotEmpty((String)delegatorName)) {
                    delegator = GenericDelegator.getGenericDelegator((String)delegatorName);
                }
                if (delegator == null) {
                    Debug.logError((String)"Could not find delegator with delegatorName in session, not creating Visit entity", (String)module);
                } else {
                    visit = delegator.makeValue("Visit", null);
                    Long nextId = delegator.getNextSeqId("Visit");
                    if (nextId == null) {
                        Debug.logError((String)"Not persisting visit, could not get next seq id", (String)module);
                        visit = null;
                    } else {
                        visit.set("visitId", (Object)nextId.toString());
                        visit.set("sessionId", (Object)session.getId());
                        visit.set("fromDate", (Object)new Timestamp(session.getCreationTime()));
                        try {
                            InetAddress address = InetAddress.getLocalHost();
                            if (address != null) {
                                visit.set("serverIpAddress", (Object)address.getHostAddress());
                                visit.set("serverHostName", (Object)address.getHostName());
                            } else {
                                Debug.logError((String)"Unable to get localhost internet address, was null", (String)module);
                            }
                        }
                        catch (UnknownHostException e) {
                            Debug.logError((String)("Unable to get localhost internet address: " + e.toString()), (String)module);
                        }
                        try {
                            visit.create();
                            session.setAttribute("visit", (Object)visit);
                        }
                        catch (GenericEntityException e) {
                            Debug.logError((Throwable)e, (String)"Could not create new visit:", (String)module);
                            visit = null;
                        }
                    }
                }
            }
            if (visit == null) {
                Debug.logWarning((String)"Could not find or create the visit...");
            }
            return visit;
        }
        return null;
    }
}

