/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.stats;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.stats.VisitHandler;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilHttp;
import org.ofbiz.core.util.UtilMisc;
import org.ofbiz.core.util.UtilProperties;

public class ServerHitBin {
    public static final String module = ServerHitBin.class.getName();
    public static final int REQUEST = 1;
    public static final int EVENT = 2;
    public static final int VIEW = 3;
    public static final int ENTITY = 4;
    public static final int SERVICE = 5;
    public static final String[] typeNames = new String[]{"", "Request", "Event", "View", "Entity", "Service"};
    public static final String[] typeIds = new String[]{"", "REQUEST", "EVENT", "VIEW", "ENTITY", "SERVICE"};
    public static Map requestHistory = new HashMap();
    public static Map eventHistory = new HashMap();
    public static Map viewHistory = new HashMap();
    public static Map entityHistory = new HashMap();
    public static Map serviceHistory = new HashMap();
    public static Map requestSinceStarted = new HashMap();
    public static Map eventSinceStarted = new HashMap();
    public static Map viewSinceStarted = new HashMap();
    public static Map entitySinceStarted = new HashMap();
    public static Map serviceSinceStarted = new HashMap();
    GenericDelegator delegator;
    String delegatorName;
    String id;
    int type;
    boolean limitLength;
    long startTime;
    long endTime;
    long numberHits;
    long totalRunningTime;
    long minTime;
    long maxTime;

    public static void countRequest(String id, HttpServletRequest request, long startTime, long runningTime, GenericValue userLogin, GenericDelegator delegator) {
        ServerHitBin.countHit(id, 1, request, startTime, runningTime, userLogin, delegator);
    }

    public static void countEvent(String id, HttpServletRequest request, long startTime, long runningTime, GenericValue userLogin, GenericDelegator delegator) {
        ServerHitBin.countHit(id, 2, request, startTime, runningTime, userLogin, delegator);
    }

    public static void countView(String id, HttpServletRequest request, long startTime, long runningTime, GenericValue userLogin, GenericDelegator delegator) {
        ServerHitBin.countHit(id, 3, request, startTime, runningTime, userLogin, delegator);
    }

    public static void countEntity(String id, HttpServletRequest request, long startTime, long runningTime, GenericValue userLogin, GenericDelegator delegator) {
        ServerHitBin.countHit(id, 4, request, startTime, runningTime, userLogin, delegator);
    }

    public static void countService(String id, HttpServletRequest request, long startTime, long runningTime, GenericValue userLogin, GenericDelegator delegator) {
        ServerHitBin.countHit(id, 5, request, startTime, runningTime, userLogin, delegator);
    }

    public static void countHit(String id, int type, HttpServletRequest request, long startTime, long runningTime, GenericValue userLogin, GenericDelegator delegator) {
        if (!"true".equals(UtilProperties.getPropertyValue((String)"serverstats", (String)("stats.enable." + typeIds[type])))) {
            return;
        }
        ServerHitBin.countHit(id, type, request, startTime, runningTime, userLogin, delegator, true);
    }

    public static void advanceAllBins(long toTime) {
        ServerHitBin.advanceAllBins(toTime, requestHistory);
        ServerHitBin.advanceAllBins(toTime, eventHistory);
        ServerHitBin.advanceAllBins(toTime, viewHistory);
        ServerHitBin.advanceAllBins(toTime, entityHistory);
        ServerHitBin.advanceAllBins(toTime, serviceHistory);
    }

    static void advanceAllBins(long toTime, Map binMap) {
        for (Map.Entry entry : binMap.entrySet()) {
            if (entry.getValue() == null) continue;
            ServerHitBin bin = (ServerHitBin)entry.getValue();
            bin.advanceBin(toTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected static void countHit(String id, int type, HttpServletRequest request, long startTime, long runningTime, GenericValue userLogin, GenericDelegator delegator, boolean isOriginal) {
        Class<ServerHitBin> clazz;
        if (delegator == null) {
            throw new IllegalArgumentException("The delgator passed to countHit cannot be null");
        }
        ServerHitBin bin = null;
        LinkedList<ServerHitBin> binList = null;
        switch (type) {
            case 1: {
                binList = (LinkedList)requestHistory.get(id);
                break;
            }
            case 2: {
                binList = (LinkedList)eventHistory.get(id);
                break;
            }
            case 3: {
                binList = (LinkedList)viewHistory.get(id);
                break;
            }
            case 4: {
                binList = (LinkedList)entityHistory.get(id);
                break;
            }
            case 5: {
                binList = (LinkedList)serviceHistory.get(id);
                break;
            }
        }
        if (binList == null) {
            clazz = ServerHitBin.class;
            // MONITORENTER : org.ofbiz.core.stats.ServerHitBin.class
            switch (type) {
                case 1: {
                    binList = (LinkedList)requestHistory.get(id);
                    break;
                }
                case 2: {
                    binList = (LinkedList)eventHistory.get(id);
                    break;
                }
                case 3: {
                    binList = (LinkedList)viewHistory.get(id);
                    break;
                }
                case 4: {
                    binList = (LinkedList)entityHistory.get(id);
                    break;
                }
                case 5: {
                    binList = (LinkedList)serviceHistory.get(id);
                    break;
                }
            }
            if (binList == null) {
                binList = new LinkedList<ServerHitBin>();
                switch (type) {
                    case 1: {
                        requestHistory.put(id, binList);
                        break;
                    }
                    case 2: {
                        eventHistory.put(id, binList);
                        break;
                    }
                    case 3: {
                        viewHistory.put(id, binList);
                        break;
                    }
                    case 4: {
                        entityHistory.put(id, binList);
                        break;
                    }
                    case 5: {
                        serviceHistory.put(id, binList);
                        break;
                    }
                }
            }
            // MONITOREXIT : clazz
        }
        if (binList.size() > 0) {
            bin = (ServerHitBin)binList.getFirst();
        }
        if (bin == null) {
            clazz = ServerHitBin.class;
            // MONITORENTER : org.ofbiz.core.stats.ServerHitBin.class
            if (binList.size() > 0) {
                bin = (ServerHitBin)binList.getFirst();
            }
            if (bin == null) {
                bin = new ServerHitBin(id, type, true, delegator);
                binList.addFirst(bin);
            }
            // MONITOREXIT : clazz
        }
        bin.addHit(startTime, runningTime);
        if (isOriginal && !"GLOBAL".equals(id)) {
            bin.saveHit(request, startTime, runningTime, userLogin);
        }
        if (!"GLOBAL".equals(id)) {
            ServerHitBin.countHitSinceStart(id, type, startTime, runningTime, isOriginal, delegator);
        }
        if (id.indexOf(46) > 0) {
            ServerHitBin.countHit(id.substring(0, id.lastIndexOf(46)), type, request, startTime, runningTime, userLogin, delegator, false);
        }
        if (!isOriginal) return;
        if ("GLOBAL".equals(id)) return;
        ServerHitBin.countHit("GLOBAL", type, request, startTime, runningTime, userLogin, delegator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void countHitSinceStart(String id, int type, long startTime, long runningTime, boolean isOriginal, GenericDelegator delegator) {
        if (delegator == null) {
            throw new IllegalArgumentException("The delgator passed to countHitSinceStart cannot be null");
        }
        ServerHitBin bin = null;
        switch (type) {
            case 1: {
                bin = (ServerHitBin)requestSinceStarted.get(id);
                break;
            }
            case 2: {
                bin = (ServerHitBin)eventSinceStarted.get(id);
                break;
            }
            case 3: {
                bin = (ServerHitBin)viewSinceStarted.get(id);
                break;
            }
            case 4: {
                bin = (ServerHitBin)entitySinceStarted.get(id);
                break;
            }
            case 5: {
                bin = (ServerHitBin)serviceSinceStarted.get(id);
                break;
            }
        }
        if (bin == null) {
            Class<ServerHitBin> clazz = ServerHitBin.class;
            // MONITORENTER : org.ofbiz.core.stats.ServerHitBin.class
            switch (type) {
                case 1: {
                    bin = (ServerHitBin)requestSinceStarted.get(id);
                    break;
                }
                case 2: {
                    bin = (ServerHitBin)eventSinceStarted.get(id);
                    break;
                }
                case 3: {
                    bin = (ServerHitBin)viewSinceStarted.get(id);
                    break;
                }
                case 4: {
                    bin = (ServerHitBin)entitySinceStarted.get(id);
                    break;
                }
                case 5: {
                    bin = (ServerHitBin)serviceSinceStarted.get(id);
                    break;
                }
            }
            if (bin == null) {
                bin = new ServerHitBin(id, type, false, delegator);
                switch (type) {
                    case 1: {
                        requestSinceStarted.put(id, bin);
                        break;
                    }
                    case 2: {
                        eventSinceStarted.put(id, bin);
                        break;
                    }
                    case 3: {
                        viewSinceStarted.put(id, bin);
                        break;
                    }
                    case 4: {
                        entitySinceStarted.put(id, bin);
                        break;
                    }
                    case 5: {
                        serviceSinceStarted.put(id, bin);
                        break;
                    }
                }
            }
            // MONITOREXIT : clazz
        }
        bin.addHit(startTime, runningTime);
        if (!isOriginal) return;
        ServerHitBin.countHitSinceStart("GLOBAL", type, startTime, runningTime, false, delegator);
    }

    public ServerHitBin(String id, int type, boolean limitLength, GenericDelegator delegator) {
        if (delegator == null) {
            throw new IllegalArgumentException("The delgator passed to countHitSinceStart cannot be null");
        }
        this.id = id;
        this.type = type;
        this.limitLength = limitLength;
        this.delegator = delegator;
        this.delegatorName = delegator.getDelegatorName();
        this.reset(this.getEvenStartingTime());
    }

    public GenericDelegator getDelegator() {
        if (this.delegator == null) {
            this.delegator = GenericDelegator.getGenericDelegator((String)this.delegatorName);
        }
        if (this.delegator == null) {
            throw new IllegalArgumentException("Could not perform stats operation: could not find delegator with name: " + this.delegatorName);
        }
        return this.delegator;
    }

    long getEvenStartingTime() {
        long curTime = System.currentTimeMillis();
        long binLength = ServerHitBin.getNewBinLength();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(curTime));
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        while (cal.getTime().getTime() < curTime - binLength) {
            cal.add(14, (int)binLength);
        }
        return cal.getTime().getTime();
    }

    static long getNewBinLength() {
        long binLength = (long)UtilProperties.getPropertyNumber((String)"serverstats", (String)"stats.bin.length.millis");
        if (binLength <= 0L) {
            binLength = 1800000L;
        }
        if (binLength > 3600000L) {
            binLength = 3600000L;
        }
        return binLength;
    }

    void reset(long startTime) {
        this.startTime = startTime;
        if (this.limitLength) {
            long binLength = ServerHitBin.getNewBinLength();
            this.endTime = startTime + binLength - 1L;
        } else {
            this.endTime = 0L;
        }
        this.numberHits = 0L;
        this.totalRunningTime = 0L;
        this.minTime = Long.MAX_VALUE;
        this.maxTime = 0L;
    }

    ServerHitBin(ServerHitBin oldBin) {
        this.id = oldBin.id;
        this.type = oldBin.type;
        this.limitLength = oldBin.limitLength;
        this.delegator = oldBin.delegator;
        this.delegatorName = oldBin.delegatorName;
        this.startTime = oldBin.startTime;
        this.endTime = oldBin.endTime;
        this.numberHits = oldBin.numberHits;
        this.totalRunningTime = oldBin.totalRunningTime;
        this.minTime = oldBin.minTime;
        this.maxTime = oldBin.maxTime;
    }

    public String getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeString() {
        return typeNames[this.type];
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.limitLength ? this.endTime : System.currentTimeMillis();
    }

    public String getStartTimeString() {
        return new Timestamp(this.getStartTime()).toString();
    }

    public String getEndTimeString() {
        return new Timestamp(this.getEndTime()).toString();
    }

    public long getBinLength() {
        return this.getEndTime() - this.getStartTime();
    }

    public double getBinLengthMinutes() {
        return (double)this.getBinLength() / 60000.0;
    }

    public long getNumberHits() {
        return this.numberHits;
    }

    public long getTotalRunningTime() {
        return this.totalRunningTime;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public double getMinTimeSeconds() {
        return (double)this.minTime / 1000.0;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public double getMaxTimeSeconds() {
        return (double)this.maxTime / 1000.0;
    }

    public double getAvgTime() {
        return (double)this.totalRunningTime / (double)this.numberHits;
    }

    public double getAvgTimeSeconds() {
        return this.getAvgTime() / 1000.0;
    }

    public double getHitsPerMinute() {
        return (double)this.numberHits / this.getBinLengthMinutes();
    }

    synchronized void addHit(long startTime, long runningTime) {
        this.advanceBin(startTime + runningTime);
        ++this.numberHits;
        this.totalRunningTime += runningTime;
        if (runningTime < this.minTime) {
            this.minTime = runningTime;
        }
        if (runningTime > this.maxTime) {
            this.maxTime = runningTime;
        }
    }

    synchronized void advanceBin(long toTime) {
        while (this.limitLength && toTime > this.endTime) {
            LinkedList binList = null;
            switch (this.type) {
                case 1: {
                    binList = (LinkedList)requestHistory.get(this.id);
                    break;
                }
                case 2: {
                    binList = (LinkedList)eventHistory.get(this.id);
                    break;
                }
                case 3: {
                    binList = (LinkedList)viewHistory.get(this.id);
                    break;
                }
                case 4: {
                    binList = (LinkedList)entityHistory.get(this.id);
                    break;
                }
                case 5: {
                    binList = (LinkedList)serviceHistory.get(this.id);
                }
            }
            binList.removeFirst();
            if (this.numberHits > 0L) {
                binList.addFirst(new ServerHitBin(this));
                if (UtilProperties.propertyValueEqualsIgnoreCase((String)"serverstats", (String)("stats.persist." + typeIds[this.type] + ".bin"), (String)"true")) {
                    GenericValue serverHitBin = this.delegator.makeValue("ServerHitBin", null);
                    Long nextId = this.getDelegator().getNextSeqId("ServerHitBin");
                    if (nextId == null) {
                        Debug.logError((String)"Not persisting ServerHitBin, could not get next seq id", (String)module);
                    } else {
                        serverHitBin.set("serverHitBinId", (Object)nextId.toString());
                        serverHitBin.set("contentId", (Object)this.id);
                        serverHitBin.set("hitTypeId", (Object)typeIds[this.type]);
                        serverHitBin.set("binStartDateTime", (Object)new Timestamp(this.startTime));
                        serverHitBin.set("binEndDateTime", (Object)new Timestamp(this.endTime));
                        serverHitBin.set("numberHits", (Object)new Long(this.numberHits));
                        serverHitBin.set("totalTimeMillis", (Object)new Long(this.totalRunningTime));
                        serverHitBin.set("minTimeMillis", (Object)new Long(this.minTime));
                        serverHitBin.set("maxTimeMillis", (Object)new Long(this.maxTime));
                        try {
                            InetAddress address = InetAddress.getLocalHost();
                            if (address != null) {
                                serverHitBin.set("serverIpAddress", (Object)address.getHostAddress());
                                serverHitBin.set("serverHostName", (Object)address.getHostName());
                            } else {
                                Debug.logError((String)"Unable to get localhost internet address, was null", (String)module);
                            }
                        }
                        catch (UnknownHostException e) {
                            Debug.logError((String)("Unable to get localhost internet address: " + e.toString()), (String)module);
                        }
                        try {
                            serverHitBin.create();
                        }
                        catch (GenericEntityException e) {
                            Debug.logError((Throwable)e, (String)"Could not save ServerHitBin:", (String)module);
                        }
                    }
                }
            }
            this.reset(this.endTime + 1L);
            binList.addFirst(this);
        }
    }

    void saveHit(HttpServletRequest request, long startTime, long runningTime, GenericValue userLogin) {
        if (UtilProperties.propertyValueEqualsIgnoreCase((String)"serverstats", (String)("stats.persist." + typeIds[this.type] + ".hit"), (String)"true")) {
            if (this.type == 4 && this.id.indexOf("ServerHit") > 0) {
                return;
            }
            GenericValue serverHitType = null;
            try {
                serverHitType = this.delegator.findByPrimaryKeyCache("ServerHitType", UtilMisc.toMap((String)"hitTypeId", (Object)typeIds[this.type]));
            }
            catch (GenericEntityException e) {
                Debug.logError((Throwable)e, (String)module);
            }
            if (serverHitType == null) {
                Debug.logWarning((String)("The datamodel data has not been loaded; cannot find hitTypeId '" + typeIds[this.type] + " not storing ServerHit."), (String)module);
                return;
            }
            String visitId = VisitHandler.getVisitId(request.getSession());
            if (visitId == null || visitId.length() == 0) {
                Debug.logWarning((String)"Could not find a visitId, so not storing ServerHit. This is probably a configuration error. If you turn of persistance of visits you should also turn off persistence of hits.");
                return;
            }
            GenericValue serverHit = this.delegator.makeValue("ServerHit", null);
            serverHit.set("visitId", (Object)visitId);
            serverHit.set("hitStartDateTime", (Object)new Timestamp(startTime));
            serverHit.set("hitTypeId", (Object)typeIds[this.type]);
            if (userLogin != null) {
                serverHit.set("userLoginId", userLogin.get("userLoginId"));
                serverHit.set("partyId", userLogin.get("partyId"));
            }
            serverHit.set("contentId", (Object)this.id);
            serverHit.set("runningTimeMillis", (Object)new Long(runningTime));
            String fullRequestUrl = UtilHttp.getFullRequestUrl((HttpServletRequest)request).toString();
            serverHit.set("requestUrl", (Object)(fullRequestUrl.length() > 250 ? fullRequestUrl.substring(0, 250) : fullRequestUrl));
            String referrerUrl = request.getHeader("Referer") != null ? request.getHeader("Referer") : "";
            serverHit.set("referrerUrl", (Object)(referrerUrl.length() > 250 ? referrerUrl.substring(0, 250) : referrerUrl));
            try {
                InetAddress address = InetAddress.getLocalHost();
                if (address != null) {
                    serverHit.set("serverIpAddress", (Object)address.getHostAddress());
                    serverHit.set("serverHostName", (Object)address.getHostName());
                } else {
                    Debug.logError((String)"Unable to get localhost internet address, was null", (String)module);
                }
            }
            catch (UnknownHostException e) {
                Debug.logError((String)("Unable to get localhost internet address: " + e.toString()), (String)module);
            }
            try {
                serverHit.create();
            }
            catch (GenericEntityException e) {
                Debug.logError((Throwable)e, (String)"Could not save ServerHit:", (String)module);
            }
        }
    }
}

