/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.generic;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelField;
import org.ofbiz.core.entity.model.ModelFieldType;
import org.ofbiz.core.entity.model.ModelReader;
import org.ofbiz.core.security.Security;
import org.ofbiz.core.util.Debug;

public class GenericWebEvent {
    public static String updateGeneric(HttpServletRequest request, HttpServletResponse response) {
        String fval;
        String fvalTime;
        String fvalDate;
        ModelFieldType type;
        ModelField field;
        int fnum;
        String errMsg = "";
        String entityName = request.getParameter("entityName");
        if (entityName == null || entityName.length() <= 0) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)"The entityName was not specified, but is required.");
            Debug.logWarning((String)"[GenericWebEvent.updateGeneric] The entityName was not specified, but is required.");
            return "error";
        }
        Security security = (Security)request.getAttribute("security");
        GenericDelegator delegator = (GenericDelegator)request.getAttribute("delegator");
        if (security == null) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)"The security object was not found in the request, please check the control servlet init.");
            Debug.logWarning((String)"[updateGeneric] The security object was not found in the request, please check the control servlet init.");
            return "error";
        }
        if (delegator == null) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)"The delegator object was not found in the request, please check the control servlet init.");
            Debug.logWarning((String)"[updateGeneric] The delegator object was not found in the request, please check the control servlet init.");
            return "error";
        }
        ModelReader reader = delegator.getModelReader();
        ModelEntity entity = null;
        try {
            entity = reader.getModelEntity(entityName);
        }
        catch (GenericEntityException e) {
            Debug.logError((Throwable)e);
        }
        String updateMode = request.getParameter("UPDATE_MODE");
        if (updateMode == null || updateMode.length() <= 0) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)"Update Mode was not specified, but is required.");
            Debug.logWarning((String)("[updateGeneric] Update Mode was not specified, but is required; entityName: " + entityName));
            return "error";
        }
        if (!security.hasEntityPermission("ENTITY_DATA", "_" + updateMode, request.getSession()) && !security.hasEntityPermission(entity.getPlainTableName(), "_" + updateMode, request.getSession())) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)("You do not have sufficient permissions to " + updateMode + " " + entity.getEntityName() + " (" + entity.getPlainTableName() + "_" + updateMode + " or " + entity.getPlainTableName() + "_ADMIN needed)."));
            return "error";
        }
        GenericValue findByEntity = delegator.makeValue(entityName, null);
        for (fnum = 0; fnum < entity.getPksSize(); ++fnum) {
            field = entity.getPk(fnum);
            type = null;
            try {
                type = delegator.getEntityFieldType(entity, field.getType());
            }
            catch (GenericEntityException e) {
                Debug.logWarning((Throwable)e);
                errMsg = errMsg + "<li> Fatal error: field type \"" + field.getType() + "\" not found";
            }
            if (type.getJavaType().equals("Timestamp") || type.getJavaType().equals("java.sql.Timestamp")) {
                fvalDate = request.getParameter(field.getName() + "_DATE");
                fvalTime = request.getParameter(field.getName() + "_TIME");
                if (fvalDate == null || fvalDate.length() <= 0) continue;
                try {
                    findByEntity.setString(field.getName(), fvalDate + " " + fvalTime);
                }
                catch (Exception e) {
                    errMsg = errMsg + "<li>" + field.getColName() + " conversion failed: \"" + fvalDate + " " + fvalTime + "\" is not a valid " + type.getJavaType();
                    Debug.logWarning((String)("[updateGeneric] " + field.getColName() + " conversion failed: \"" + fvalDate + " " + fvalTime + "\" is not a valid " + type.getJavaType() + "; entityName: " + entityName));
                }
                continue;
            }
            fval = request.getParameter(field.getName());
            if (fval == null || fval.length() <= 0) continue;
            try {
                findByEntity.setString(field.getName(), fval);
                continue;
            }
            catch (Exception e) {
                errMsg = errMsg + "<li>" + field.getColName() + " conversion failed: \"" + fval + "\" is not a valid " + type.getJavaType();
                Debug.logWarning((String)("[updateGeneric] " + field.getColName() + " conversion failed: \"" + fval + "\" is not a valid " + type.getJavaType() + "; entityName: " + entityName));
            }
        }
        if (updateMode.equals("DELETE")) {
            try {
                delegator.removeByPrimaryKey(findByEntity.getPrimaryKey());
            }
            catch (GenericEntityException e) {
                Debug.logWarning((Throwable)e);
                request.setAttribute("_ERROR_MESSAGE_", (Object)"Delete failed (write error)");
                return "error";
            }
            return "success";
        }
        for (fnum = 0; fnum < entity.getNopksSize(); ++fnum) {
            field = entity.getNopk(fnum);
            type = null;
            try {
                type = delegator.getEntityFieldType(entity, field.getType());
            }
            catch (GenericEntityException e) {
                Debug.logWarning((Throwable)e);
                errMsg = errMsg + "<li> Fatal error: field type \"" + field.getType() + "\" not found";
            }
            if (type.getJavaType().equals("Timestamp") || type.getJavaType().equals("java.sql.Timestamp")) {
                fvalDate = request.getParameter(field.getName() + "_DATE");
                fvalTime = request.getParameter(field.getName() + "_TIME");
                if (fvalDate == null || fvalDate.length() <= 0) continue;
                try {
                    findByEntity.setString(field.getName(), fvalDate + " " + fvalTime);
                }
                catch (Exception e) {
                    errMsg = errMsg + "<li>" + field.getColName() + " conversion failed: \"" + fvalDate + " " + fvalTime + "\" is not a valid " + type.getJavaType();
                    Debug.logWarning((String)("[updateGeneric] " + field.getColName() + " conversion failed: \"" + fvalDate + " " + fvalTime + "\" is not a valid " + type.getJavaType() + "; entityName: " + entityName));
                }
                continue;
            }
            fval = request.getParameter(field.getName());
            if (fval == null || fval.length() <= 0) continue;
            try {
                findByEntity.setString(field.getName(), fval);
                continue;
            }
            catch (Exception e) {
                errMsg = errMsg + "<li>" + field.getColName() + " conversion failed: \"" + fval + "\" is not a valid " + type.getJavaType();
                Debug.logWarning((String)("[updateGeneric] " + field.getColName() + " conversion failed: \"" + fval + "\" is not a valid " + type.getJavaType() + "; entityName: " + entityName));
            }
        }
        if (updateMode.equals("CREATE")) {
            GenericValue tempEntity = null;
            try {
                tempEntity = delegator.findByPrimaryKey(findByEntity.getPrimaryKey());
            }
            catch (GenericEntityException e) {
                Debug.logWarning((Throwable)e);
                request.setAttribute("_ERROR_MESSAGE_", (Object)"Create failed while checking if exists (read error)");
                return "error";
            }
            if (tempEntity != null) {
                errMsg = errMsg + "<li>" + entity.getEntityName() + " already exists with primary key: " + findByEntity.getPrimaryKey().toString() + "; please change.";
                Debug.logWarning((String)("[updateGeneric] " + entity.getEntityName() + " already exists with primary key: " + findByEntity.getPrimaryKey().toString() + "; please change."));
            }
        }
        for (int fnum2 = 0; fnum2 < entity.getFieldsSize(); ++fnum2) {
            field = entity.getField(fnum2);
            for (int j = 0; j < field.getValidatorsSize(); ++j) {
                String message;
                Boolean resultBool;
                Method valMethod;
                Class<?> valClass;
                String curValidate = field.getValidator(j);
                Class[] paramTypes = new Class[]{String.class};
                Object[] params = new Object[]{findByEntity.get(field.getName()).toString()};
                String className = "org.ofbiz.core.util.UtilValidate";
                String methodName = curValidate;
                if (curValidate.indexOf(46) > 0) {
                    className = curValidate.substring(0, curValidate.lastIndexOf(46));
                    methodName = curValidate.substring(curValidate.lastIndexOf(46) + 1);
                }
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    valClass = loader.loadClass(className);
                }
                catch (ClassNotFoundException cnfe) {
                    Debug.logError((String)("[updateGeneric] Could not find validation class: " + className + "; ignoring."));
                    continue;
                }
                try {
                    valMethod = valClass.getMethod(methodName, paramTypes);
                }
                catch (NoSuchMethodException cnfe) {
                    Debug.logError((String)("[updateGeneric] Could not find validation method: " + methodName + " of class " + className + "; ignoring."));
                    continue;
                }
                try {
                    resultBool = (Boolean)valMethod.invoke(null, params);
                }
                catch (Exception e) {
                    Debug.logError((String)("[updateGeneric] Could not access validation method: " + methodName + " of class " + className + "; returning true."));
                    resultBool = Boolean.TRUE;
                }
                if (resultBool.booleanValue()) continue;
                try {
                    Field msgField = valClass.getField(curValidate + "Msg");
                    message = (String)msgField.get(null);
                }
                catch (Exception e) {
                    Debug.logError((String)("[updateGeneric] Could not find validation message field: " + curValidate + "Msg of class " + className + "; returning generic validation failure message."));
                    message = "validation failed.";
                }
                errMsg = errMsg + "<li>" + field.getColName() + " " + curValidate + " failed: " + message;
                Debug.logWarning((String)("[updateGeneric] " + field.getColName() + " " + curValidate + " failed: " + message));
            }
        }
        if (errMsg.length() > 0) {
            errMsg = "<br><b>The following error(s) occurred:</b><ul>" + errMsg + "</ul>";
            request.setAttribute("_ERROR_MESSAGE_", (Object)errMsg);
            return "error";
        }
        if (updateMode.equals("CREATE")) {
            GenericValue value;
            try {
                value = delegator.create(findByEntity.getEntityName(), findByEntity.getAllFields());
            }
            catch (GenericEntityException e) {
                Debug.logWarning((Throwable)e);
                value = null;
            }
            if (value == null) {
                request.setAttribute("_ERROR_MESSAGE_", (Object)("Creation of " + entity.getEntityName() + " failed for entity: " + findByEntity.toString()));
                return "error";
            }
        } else if (updateMode.equals("UPDATE")) {
            GenericValue value = delegator.makeValue(findByEntity.getEntityName(), findByEntity.getAllFields());
            try {
                value.store();
            }
            catch (GenericEntityException e) {
                Debug.logWarning((Throwable)e);
                request.setAttribute("_ERROR_MESSAGE_", (Object)("Update of " + entity.getEntityName() + " failed for value: " + value.toString()));
                return "error";
            }
        } else {
            request.setAttribute("_ERROR_MESSAGE_", (Object)("Update Mode specified (" + updateMode + ") was not valid."));
            Debug.logWarning((String)("updateGeneric: Update Mode specified (" + updateMode + ") was not valid for entity: " + findByEntity.toString()));
            return "error";
        }
        return "success";
    }
}

