/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.extutil;

import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ofbiz.core.security.Security;
import org.ofbiz.core.util.UtilCache;

public class UtilCacheEvents {
    public static String removeElementEvent(HttpServletRequest request, HttpServletResponse response) {
        Object key;
        int number;
        Security security = (Security)request.getAttribute("security");
        if (!security.hasPermission("UTIL_CACHE_EDIT", request.getSession())) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)"You do not have permission to perform this operation, UTIL_CACHE_EDIT required.");
            return "error";
        }
        String name = request.getParameter("UTIL_CACHE_NAME");
        if (name == null) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)"Could not remove cache line/element, no cache name specified.");
            return "error";
        }
        String numString = request.getParameter("UTIL_CACHE_ELEMENT_NUMBER");
        if (numString == null) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)"Could not remove cache line/element, no element number specified.");
            return "error";
        }
        try {
            number = Integer.parseInt(numString);
        }
        catch (Exception e) {
            return "error";
        }
        UtilCache utilCache = (UtilCache)UtilCache.utilCacheTable.get(name);
        if (utilCache != null) {
            key = null;
            if (utilCache.getMaxSize() > 0L) {
                try {
                    key = utilCache.keyLRUList.get(number);
                }
                catch (Exception e) {}
            } else {
                Iterator ksIter = utilCache.cacheLineTable.keySet().iterator();
                int curNum = 0;
                while (ksIter.hasNext()) {
                    if (number == curNum) {
                        key = ksIter.next();
                        break;
                    }
                    ksIter.next();
                    ++curNum;
                }
            }
            if (key == null) {
                request.setAttribute("_ERROR_MESSAGE_", (Object)("Could not remove cache element, element not found with cache name: " + name + ", element number: " + numString));
                return "error";
            }
        } else {
            request.setAttribute("_ERROR_MESSAGE_", (Object)("Could not remove cache element, cache not found with name: " + name));
            return "error";
        }
        utilCache.remove(key);
        request.setAttribute("_EVENT_MESSAGE_", (Object)("Removed element from cache with key: " + key.toString()));
        return "success";
    }

    public static String clearEvent(HttpServletRequest request, HttpServletResponse response) {
        Security security = (Security)request.getAttribute("security");
        if (!security.hasPermission("UTIL_CACHE_EDIT", request.getSession())) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)"You do not have permission to perform this operation, UTIL_CACHE_EDIT required.");
            return "error";
        }
        String name = request.getParameter("UTIL_CACHE_NAME");
        if (name == null) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)"Could not clear cache, no name specified.");
            return "error";
        }
        UtilCache utilCache = (UtilCache)UtilCache.utilCacheTable.get(name);
        if (utilCache == null) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)("Could not clear cache, cache not found with name: " + name));
            return "error";
        }
        utilCache.clear();
        request.setAttribute("_EVENT_MESSAGE_", (Object)("Cleared cache with name: " + name));
        return "success";
    }

    public static String clearAllEvent(HttpServletRequest request, HttpServletResponse response) {
        Security security = (Security)request.getAttribute("security");
        if (!security.hasPermission("UTIL_CACHE_EDIT", request.getSession())) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)"You do not have permission to perform this operation, UTIL_CACHE_EDIT required.");
            return "error";
        }
        UtilCache.clearAllCaches();
        request.setAttribute("_EVENT_MESSAGE_", (Object)"Cleared all caches.");
        return "success";
    }

    public static String clearAllExpiredEvent(HttpServletRequest request, HttpServletResponse response) {
        Security security = (Security)request.getAttribute("security");
        if (!security.hasPermission("UTIL_CACHE_EDIT", request.getSession())) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)"You do not have permission to perform this operation, UTIL_CACHE_EDIT required.");
            return "error";
        }
        UtilCache.clearExpiredFromAllCaches();
        request.setAttribute("_EVENT_MESSAGE_", (Object)"Cleared all expried elements from all caches.");
        return "success";
    }

    public static String updateEvent(HttpServletRequest request, HttpServletResponse response) {
        Security security = (Security)request.getAttribute("security");
        if (!security.hasPermission("UTIL_CACHE_EDIT", request.getSession())) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)"You do not have permission to perform this operation, UTIL_CACHE_EDIT required.");
            return "error";
        }
        String name = request.getParameter("UTIL_CACHE_NAME");
        if (name == null) {
            request.setAttribute("_ERROR_MESSAGE_", (Object)"Could not update cache settings, no name specified");
            return "error";
        }
        String maxSizeStr = request.getParameter("UTIL_CACHE_MAX_SIZE");
        String expireTimeStr = request.getParameter("UTIL_CACHE_EXPIRE_TIME");
        String useSoftReferenceStr = request.getParameter("UTIL_CACHE_USE_SOFT_REFERENCE");
        Long maxSize = null;
        Long expireTime = null;
        try {
            maxSize = Long.valueOf(maxSizeStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            expireTime = Long.valueOf(expireTimeStr);
        }
        catch (Exception e) {
            // empty catch block
        }
        UtilCache utilCache = (UtilCache)UtilCache.utilCacheTable.get(name);
        if (utilCache != null) {
            if (maxSize != null) {
                utilCache.setMaxSize(maxSize.longValue());
            }
            if (expireTime != null) {
                utilCache.setExpireTime(expireTime.longValue());
            }
            if (useSoftReferenceStr != null) {
                utilCache.setUseSoftReference("true".equals(useSoftReferenceStr));
            }
        }
        return "success";
    }
}

