/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.calendar;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.calendar.RecurrenceRuleException;
import org.ofbiz.core.calendar.RecurrenceUtil;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.StringUtil;
import org.ofbiz.core.util.UtilMisc;

public class RecurrenceRule {
    public static final String module = RecurrenceRule.class.getName();
    public static final int MIN_SEC = 0;
    public static final int MAX_SEC = 59;
    public static final int MIN_MIN = 0;
    public static final int MAX_MIN = 59;
    public static final int MIN_HR = 0;
    public static final int MAX_HR = 23;
    public static final int MIN_MTH_DAY = -31;
    public static final int MAX_MTH_DAY = 31;
    public static final int MIN_YEAR_DAY = -366;
    public static final int MAX_YEAR_DAY = 366;
    public static final int MIN_WEEK_NO = -53;
    public static final int MAX_WEEK_NO = 53;
    public static final int MIN_MTH = 1;
    public static final int MAX_MTH = 12;
    public static final int SECONDLY = 1;
    public static final int MINUTELY = 2;
    public static final int HOURLY = 3;
    public static final int DAILY = 4;
    public static final int WEEKLY = 5;
    public static final int MONTHLY = 6;
    public static final int YEARLY = 7;
    protected GenericValue rule;
    protected List bySecondList;
    protected List byMinuteList;
    protected List byHourList;
    protected List byDayList;
    protected List byMonthDayList;
    protected List byYearDayList;
    protected List byWeekNoList;
    protected List byMonthList;
    protected List bySetPosList;

    public RecurrenceRule(GenericValue rule) throws RecurrenceRuleException {
        this.rule = rule;
        if (!rule.getEntityName().equals("RecurrenceRule")) {
            throw new RecurrenceRuleException("Invalid RecurrenceRule Value object.");
        }
        this.init();
    }

    public void init() throws RecurrenceRuleException {
        String freq = this.rule.getString("frequency");
        if (!this.checkFreq(freq)) {
            throw new RecurrenceRuleException("Recurrence FREQUENCY is a required parameter.");
        }
        if (this.rule.getLong("intervalNumber") < 1L) {
            throw new RecurrenceRuleException("Recurrence INTERVAL must be a positive integer.");
        }
        this.bySecondList = StringUtil.split((String)this.rule.getString("bySecondList"), (String)",");
        this.byMinuteList = StringUtil.split((String)this.rule.getString("byMinuteList"), (String)",");
        this.byHourList = StringUtil.split((String)this.rule.getString("byHourList"), (String)",");
        this.byDayList = StringUtil.split((String)this.rule.getString("byDayList"), (String)",");
        this.byMonthDayList = StringUtil.split((String)this.rule.getString("byMonthDayList"), (String)",");
        this.byYearDayList = StringUtil.split((String)this.rule.getString("byYearDayList"), (String)",");
        this.byWeekNoList = StringUtil.split((String)this.rule.getString("byWeekNoList"), (String)",");
        this.byMonthList = StringUtil.split((String)this.rule.getString("byMonthList"), (String)",");
        this.bySetPosList = StringUtil.split((String)this.rule.getString("bySetPosList"), (String)",");
    }

    private long now() {
        return new Date().getTime();
    }

    private boolean checkFreq(String freq) {
        if (freq == null) {
            return false;
        }
        if (freq.equalsIgnoreCase("SECONDLY")) {
            return true;
        }
        if (freq.equalsIgnoreCase("MINUTELY")) {
            return true;
        }
        if (freq.equalsIgnoreCase("HOURLY")) {
            return true;
        }
        if (freq.equalsIgnoreCase("DAILY")) {
            return true;
        }
        if (freq.equalsIgnoreCase("WEEKLY")) {
            return true;
        }
        if (freq.equalsIgnoreCase("MONTHLY")) {
            return true;
        }
        return freq.equalsIgnoreCase("YEARLY");
    }

    public long getEndTime() {
        if (this.rule == null) {
            Debug.logVerbose((String)"Rule is null.", (String)module);
            return -1L;
        }
        long time = 0L;
        Timestamp stamp = null;
        stamp = this.rule.getTimestamp("untilDateTime");
        Debug.logVerbose((String)("Stamp value: " + stamp), (String)module);
        if (stamp != null) {
            long nanos = stamp.getNanos();
            time = stamp.getTime();
            time += nanos / 1000000L;
        }
        Debug.logVerbose((String)("Returning time: " + time), (String)module);
        return time;
    }

    public long getCount() {
        if (this.rule.get("countNumber") != null) {
            return this.rule.getLong("countNumber");
        }
        return 0L;
    }

    public String getFrequencyName() {
        return this.rule.getString("frequency").toUpperCase();
    }

    public int getFrequency() {
        String freq = this.rule.getString("frequency");
        if (freq == null) {
            return 0;
        }
        if (freq.equalsIgnoreCase("SECONDLY")) {
            return 1;
        }
        if (freq.equalsIgnoreCase("MINUTELY")) {
            return 2;
        }
        if (freq.equalsIgnoreCase("HOURLY")) {
            return 3;
        }
        if (freq.equalsIgnoreCase("DAILY")) {
            return 4;
        }
        if (freq.equalsIgnoreCase("WEEKLY")) {
            return 5;
        }
        if (freq.equalsIgnoreCase("MONTHLY")) {
            return 6;
        }
        if (freq.equalsIgnoreCase("YEARLY")) {
            return 7;
        }
        return 0;
    }

    public long getInterval() {
        if (this.rule.get("intervalNumber") == null) {
            return 1L;
        }
        return this.rule.getLong("intervalNumber");
    }

    public int getIntervalInt() {
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[RecurrenceInfo.getInterval] : " + this.getInterval()));
        }
        return (int)this.getInterval();
    }

    public long next(long startTime, long fromTime, long currentCount) {
        if (startTime == 0L) {
            startTime = RecurrenceUtil.now();
        }
        if (fromTime == 0L) {
            fromTime = startTime;
        }
        if (this.getEndTime() != 0L && this.getEndTime() <= RecurrenceUtil.now()) {
            return 0L;
        }
        Debug.logVerbose((String)"Rule NOT expired by end time.", (String)module);
        if (this.getCount() != -1L && currentCount >= this.getCount()) {
            return 0L;
        }
        Debug.logVerbose((String)"Rule NOT expired by max count.", (String)module);
        boolean isSeeking = true;
        long nextRuntime = 0L;
        long seekTime = fromTime;
        int maxLoop = 100000;
        for (int loopProtection = 0; isSeeking && loopProtection < maxLoop; ++loopProtection) {
            Date nextRun = this.getNextFreq(startTime, seekTime);
            seekTime = nextRun.getTime();
            if (!this.validByRule(nextRun)) continue;
            isSeeking = false;
            nextRuntime = nextRun.getTime();
        }
        return nextRuntime;
    }

    public boolean isValid(Date startDate, Date date) {
        return this.isValid(startDate.getTime(), date.getTime());
    }

    public boolean isValid(long startTime, long dateTime) {
        long testTime = startTime;
        if (testTime == dateTime) {
            return true;
        }
        while (testTime < dateTime) {
            if ((testTime = this.next(startTime, testTime, 1L)) != dateTime) continue;
            return true;
        }
        return false;
    }

    public void remove() throws RecurrenceRuleException {
        try {
            this.rule.remove();
        }
        catch (GenericEntityException e) {
            throw new RecurrenceRuleException(e.getMessage(), e);
        }
    }

    private Date getNextFreq(long startTime, long fromTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(startTime));
        long nextStartTime = startTime;
        while (nextStartTime < fromTime) {
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[RecurrenceInfo.getNextFreq] : Updating time - " + this.getFrequency()));
            }
            switch (this.getFrequency()) {
                case 1: {
                    cal.add(13, this.getIntervalInt());
                    break;
                }
                case 2: {
                    cal.add(12, this.getIntervalInt());
                    break;
                }
                case 3: {
                    cal.add(10, this.getIntervalInt());
                    break;
                }
                case 4: {
                    cal.add(5, this.getIntervalInt());
                    break;
                }
                case 5: {
                    cal.add(5, 7 * this.getIntervalInt());
                    break;
                }
                case 6: {
                    cal.add(2, this.getIntervalInt());
                    break;
                }
                case 7: {
                    cal.add(1, this.getIntervalInt());
                    break;
                }
                default: {
                    return null;
                }
            }
            nextStartTime = cal.getTime().getTime();
        }
        return new Date(nextStartTime);
    }

    private boolean validByRule(Date date) {
        int currentDay;
        int maxDay;
        String dayStr;
        boolean foundDay;
        Iterator iter;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (this.bySecondList != null && this.bySecondList.size() > 0 && !this.bySecondList.contains(new Integer(cal.get(13)))) {
            return false;
        }
        if (this.byMinuteList != null && this.byMinuteList.size() > 0 && !this.byMinuteList.contains(new Integer(cal.get(12)))) {
            return false;
        }
        if (this.byHourList != null && this.byHourList.size() > 0 && !this.byHourList.contains(new Integer(cal.get(10)))) {
            return false;
        }
        if (this.byDayList != null && this.byDayList.size() > 0) {
            iter = this.byDayList.iterator();
            foundDay = false;
            while (iter.hasNext() && !foundDay) {
                String dayRule = (String)iter.next();
                String dayString = this.getDailyString(dayRule);
                if (7 != this.getCalendarDay(dayString)) continue;
                if (this.hasNumber(dayRule) && (this.getFrequency() == 6 || this.getFrequency() == 7)) {
                    int firstDay;
                    int maxDay2;
                    int totalDay;
                    int thisDiff;
                    int dayPosCalc;
                    int currentPos;
                    int modifier = this.getDailyNumber(dayRule);
                    if (modifier == 0) {
                        foundDay = true;
                    }
                    if (this.getFrequency() == 6) {
                        currentPos = cal.get(4);
                        dayPosCalc = cal.get(5) - (currentPos - 1) * 7;
                        if (dayPosCalc < 1) {
                            --currentPos;
                        }
                        if (modifier > 0) {
                            if (currentPos != modifier) continue;
                            foundDay = true;
                            continue;
                        }
                        if (modifier >= 0 || (thisDiff = currentPos - (totalDay = ((maxDay2 = cal.getActualMaximum(5)) - (firstDay = dayPosCalc > 0 ? dayPosCalc : dayPosCalc + 7)) / 7 + 1) - 1) != modifier) continue;
                        foundDay = true;
                        continue;
                    }
                    if (this.getFrequency() != 7) continue;
                    currentPos = cal.get(3);
                    dayPosCalc = cal.get(6) - (currentPos - 1) * 7;
                    if (dayPosCalc < 1) {
                        --currentPos;
                    }
                    if (modifier > 0) {
                        if (currentPos != modifier) continue;
                        foundDay = true;
                        continue;
                    }
                    if (modifier >= 0 || (thisDiff = currentPos - (totalDay = ((maxDay2 = cal.getActualMaximum(6)) - (firstDay = dayPosCalc > 0 ? dayPosCalc : dayPosCalc + 7)) / 7 + 1) - 1) != modifier) continue;
                    foundDay = true;
                    continue;
                }
                foundDay = true;
            }
            if (!foundDay) {
                return false;
            }
        }
        if (this.byMonthDayList != null && this.byMonthDayList.size() > 0) {
            iter = this.byMonthDayList.iterator();
            foundDay = false;
            while (iter.hasNext() && !foundDay) {
                int day = 0;
                dayStr = (String)iter.next();
                try {
                    day = Integer.parseInt(dayStr);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                maxDay = cal.getActualMaximum(5);
                currentDay = cal.get(5);
                if (day > 0 && day == currentDay) {
                    foundDay = true;
                }
                if (day >= 0 || day != currentDay - maxDay - 1) continue;
                foundDay = true;
            }
            if (!foundDay) {
                return false;
            }
        }
        if (this.byYearDayList != null && this.byYearDayList.size() > 0) {
            iter = this.byYearDayList.iterator();
            foundDay = false;
            while (iter.hasNext() && !foundDay) {
                int day = 0;
                dayStr = (String)iter.next();
                try {
                    day = Integer.parseInt(dayStr);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                maxDay = cal.getActualMaximum(6);
                currentDay = cal.get(6);
                if (day > 0 && day == currentDay) {
                    foundDay = true;
                }
                if (day >= 0 || day != currentDay - maxDay - 1) continue;
                foundDay = true;
            }
            if (!foundDay) {
                return false;
            }
        }
        if (this.byWeekNoList != null && this.byWeekNoList.size() > 0) {
            iter = this.byWeekNoList.iterator();
            boolean foundWeek = false;
            while (iter.hasNext() && !foundWeek) {
                int week = 0;
                String weekStr = (String)iter.next();
                try {
                    week = Integer.parseInt(weekStr);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                int maxWeek = cal.getActualMaximum(3);
                int currentWeek = cal.get(3);
                if (week > 0 && week == currentWeek) {
                    foundWeek = true;
                }
                if (week >= 0 || week != currentWeek - maxWeek - 1) continue;
                foundWeek = true;
            }
            if (!foundWeek) {
                return false;
            }
        }
        if (this.byMonthList != null && this.byMonthList.size() > 0) {
            iter = this.byMonthList.iterator();
            boolean foundMonth = false;
            while (iter.hasNext() && !foundMonth) {
                int month = 0;
                String monthStr = (String)iter.next();
                try {
                    month = Integer.parseInt(monthStr);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                if (month != cal.get(2)) continue;
                foundMonth = true;
            }
            if (!foundMonth) {
                return false;
            }
        }
        return true;
    }

    private boolean hasNumber(String str) {
        String firstChar;
        String[] list = new String[]{"+", "-", "1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
        List<String> numberList = Arrays.asList(list);
        return numberList.contains(firstChar = str.substring(0, 0));
    }

    private int getDailyNumber(String str) {
        int number = 0;
        StringBuffer numberBuf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            String thisChar = str.substring(i, i);
            if (!this.hasNumber(thisChar)) continue;
            numberBuf.append(thisChar);
        }
        String numberStr = numberBuf.toString();
        if (numberStr.length() > 0 && (numberStr.length() > 1 || numberStr.charAt(0) != '+' && numberStr.charAt(0) != '-')) {
            try {
                number = Integer.parseInt(numberStr);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return number;
    }

    private String getDailyString(String str) {
        StringBuffer sBuf = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            String thisChar = str.substring(i, i);
            if (this.hasNumber(thisChar)) continue;
            sBuf.append(thisChar);
        }
        return sBuf.toString();
    }

    private int getCalendarDay(String day) {
        if (day.equalsIgnoreCase("MO")) {
            return 2;
        }
        if (day.equalsIgnoreCase("TU")) {
            return 3;
        }
        if (day.equalsIgnoreCase("WE")) {
            return 4;
        }
        if (day.equalsIgnoreCase("TH")) {
            return 5;
        }
        if (day.equalsIgnoreCase("FR")) {
            return 6;
        }
        if (day.equalsIgnoreCase("SA")) {
            return 7;
        }
        if (day.equalsIgnoreCase("SU")) {
            return 1;
        }
        return 0;
    }

    public String primaryKey() {
        return this.rule.getString("recurrenceRuleId");
    }

    public static RecurrenceRule makeRule(GenericDelegator delegator, int frequency, int interval, int count) throws RecurrenceRuleException {
        return RecurrenceRule.makeRule(delegator, frequency, interval, count, 0L);
    }

    public static RecurrenceRule makeRule(GenericDelegator delegator, int frequency, int interval, long endTime) throws RecurrenceRuleException {
        return RecurrenceRule.makeRule(delegator, frequency, interval, -1, endTime);
    }

    public static RecurrenceRule makeRule(GenericDelegator delegator, int frequency, int interval, int count, long endTime) throws RecurrenceRuleException {
        String[] freq = new String[]{"", "SECONDLY", "MINUTELY", "HOURLY", "DAILY", "WEEKLY", "MONTHLY", "YEARLY"};
        if (frequency < 1 || frequency > 7) {
            throw new RecurrenceRuleException("Invalid frequency");
        }
        if (interval < 0) {
            throw new RecurrenceRuleException("Invalid interval");
        }
        String freqStr = freq[frequency];
        try {
            String ruleId = delegator.getNextSeqId("RecurrenceRule").toString();
            GenericValue value = delegator.makeValue("RecurrenceRule", UtilMisc.toMap((String)"recurrenceRuleId", (Object)ruleId));
            value.set("frequency", (Object)freqStr);
            value.set("intervalNumber", (Object)new Long(interval));
            value.set("countNumber", (Object)new Long(count));
            value.set("untilDateTime", (Object)new Timestamp(endTime));
            delegator.create(value);
            RecurrenceRule newRule = new RecurrenceRule(value);
            return newRule;
        }
        catch (GenericEntityException ee) {
            throw new RecurrenceRuleException(ee.getMessage(), ee);
        }
        catch (RecurrenceRuleException re) {
            throw re;
        }
    }
}

