/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.calendar;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.calendar.RecurrenceInfoException;
import org.ofbiz.core.calendar.RecurrenceRule;
import org.ofbiz.core.calendar.RecurrenceRuleException;
import org.ofbiz.core.calendar.RecurrenceUtil;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.StringUtil;
import org.ofbiz.core.util.UtilMisc;

public class RecurrenceInfo {
    public static final String module = RecurrenceInfo.class.getName();
    protected GenericValue info;
    protected Date startDate;
    protected List rRulesList;
    protected List eRulesList;
    protected List rDateList;
    protected List eDateList;

    public RecurrenceInfo(GenericValue info) throws RecurrenceInfoException {
        this.info = info;
        if (!info.getEntityName().equals("RecurrenceInfo")) {
            throw new RecurrenceInfoException("Invalid RecurrenceInfo Value object.");
        }
        this.init();
    }

    public void init() throws RecurrenceInfoException {
        Iterator i;
        List c;
        if (this.info.get("startDateTime") == null) {
            throw new RecurrenceInfoException("Recurrence startDateTime cannot be null.");
        }
        long startTime = this.info.getTimestamp("startDateTime").getTime();
        if (startTime <= 0L) {
            throw new RecurrenceInfoException("Recurrence startDateTime must have a value.");
        }
        int nanos = this.info.getTimestamp("startDateTime").getNanos();
        this.startDate = new Date(startTime += (long)(nanos / 1000000));
        try {
            c = this.info.getRelated("RecurrenceRule");
            i = c.iterator();
            this.rRulesList = new ArrayList();
            while (i.hasNext()) {
                this.rRulesList.add(new RecurrenceRule((GenericValue)i.next()));
            }
        }
        catch (GenericEntityException gee) {
            this.rRulesList = null;
        }
        catch (RecurrenceRuleException rre) {
            throw new RecurrenceInfoException("Illegal rule format.");
        }
        try {
            c = this.info.getRelated("ExceptionRecurrenceRule");
            i = c.iterator();
            this.eRulesList = new ArrayList();
            while (i.hasNext()) {
                this.eRulesList.add(new RecurrenceRule((GenericValue)i.next()));
            }
        }
        catch (GenericEntityException gee) {
            this.eRulesList = null;
        }
        catch (RecurrenceRuleException rre) {
            throw new RecurrenceInfoException("Illegal rule format.");
        }
        this.rDateList = RecurrenceUtil.parseDateList(StringUtil.split((String)this.info.getString("recurrenceDateTimes"), (String)","));
        this.eDateList = RecurrenceUtil.parseDateList(StringUtil.split((String)this.info.getString("exceptionDateTimes"), (String)","));
        Collections.sort(this.rDateList);
        Collections.sort(this.eDateList);
    }

    public String getID() {
        return this.info.getString("recurrenceInfoId");
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public long getStartTime() {
        return this.startDate.getTime();
    }

    public Iterator getRecurrenceRuleIterator() {
        return this.rRulesList.iterator();
    }

    public Iterator getRecurrenceDateIterator() {
        return this.rDateList.iterator();
    }

    public Iterator getExceptionRuleIterator() {
        return this.eRulesList.iterator();
    }

    public Iterator getExceptionDateIterator() {
        return this.eDateList.iterator();
    }

    public long getCurrentCount() {
        if (this.info.get("recurrenceCount") != null) {
            return this.info.getLong("recurrenceCount");
        }
        return 0L;
    }

    public void incrementCurrentCount() throws GenericEntityException {
        Long count = new Long(this.getCurrentCount() + 1L);
        this.info.set("recurrenceCount", (Object)count);
        this.info.store();
    }

    public void remove() throws RecurrenceInfoException {
        ArrayList rulesList = new ArrayList();
        rulesList.addAll(this.rRulesList);
        rulesList.addAll(this.eRulesList);
        Iterator i = rulesList.iterator();
        try {
            while (i.hasNext()) {
                ((RecurrenceRule)i.next()).remove();
            }
            this.info.remove();
        }
        catch (RecurrenceRuleException rre) {
            throw new RecurrenceInfoException(rre.getMessage(), (Throwable)((Object)rre));
        }
        catch (GenericEntityException gee) {
            throw new RecurrenceInfoException(gee.getMessage(), gee);
        }
    }

    public long first() {
        return this.startDate.getTime();
    }

    public long last() {
        return 0L;
    }

    public long next() {
        return this.next(RecurrenceUtil.now());
    }

    public long next(long fromTime) {
        if (this.getCurrentCount() == 0L || fromTime == 0L || fromTime == this.startDate.getTime()) {
            return this.first();
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("Date List Size: " + (this.rDateList == null ? 0 : this.rDateList.size())), (String)module);
            Debug.logVerbose((String)("Rule List Size: " + (this.rRulesList == null ? 0 : this.rRulesList.size())), (String)module);
        }
        if (this.rDateList == null && this.rRulesList == null) {
            return 0L;
        }
        long nextRuleTime = fromTime;
        boolean hasNext = true;
        Iterator rulesIterator = this.getRecurrenceRuleIterator();
        while (rulesIterator.hasNext()) {
            RecurrenceRule rule = (RecurrenceRule)rulesIterator.next();
            while (hasNext) {
                if ((nextRuleTime = this.getNextTime(rule, nextRuleTime)) != 0L && !this.isValid(nextRuleTime)) continue;
                hasNext = false;
            }
        }
        return nextRuleTime;
    }

    private long getNextTime(RecurrenceRule rule, long fromTime) {
        long nextTime = rule.next(this.getStartTime(), fromTime, this.getCurrentCount());
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("Next Time Before Date Check: " + nextTime), (String)module);
        }
        return this.checkDateList(this.rDateList, nextTime, fromTime);
    }

    private long checkDateList(List dateList, long time, long fromTime) {
        long nextTime = time;
        if (dateList != null && dateList.size() > 0) {
            for (Date thisDate : dateList) {
                if (nextTime > 0L && thisDate.getTime() < nextTime && thisDate.getTime() > fromTime) {
                    nextTime = thisDate.getTime();
                    continue;
                }
                if (nextTime != 0L || thisDate.getTime() <= fromTime) continue;
                nextTime = thisDate.getTime();
            }
        }
        return nextTime;
    }

    private boolean isValid(long time) {
        Iterator exceptRulesIterator = this.getExceptionRuleIterator();
        while (exceptRulesIterator.hasNext()) {
            RecurrenceRule except = (RecurrenceRule)exceptRulesIterator.next();
            if (!except.isValid(this.getStartTime(), time) && !this.eDateList.contains(new Date(time))) continue;
            return false;
        }
        return true;
    }

    public String primaryKey() {
        return this.info.getString("recurrenceInfoId");
    }

    public static RecurrenceInfo makeInfo(GenericDelegator delegator, long startTime, int frequency, int interval, int count) throws RecurrenceInfoException {
        return RecurrenceInfo.makeInfo(delegator, startTime, frequency, interval, count, 0L);
    }

    public static RecurrenceInfo makeInfo(GenericDelegator delegator, long startTime, int frequency, int interval, long endTime) throws RecurrenceInfoException {
        return RecurrenceInfo.makeInfo(delegator, startTime, frequency, interval, -1, endTime);
    }

    public static RecurrenceInfo makeInfo(GenericDelegator delegator, long startTime, int frequency, int interval, int count, long endTime) throws RecurrenceInfoException {
        try {
            RecurrenceRule r = RecurrenceRule.makeRule(delegator, frequency, interval, count, endTime);
            String ruleId = r.primaryKey();
            String infoId = delegator.getNextSeqId("RecurrenceInfo").toString();
            GenericValue value = delegator.makeValue("RecurrenceInfo", UtilMisc.toMap((String)"recurrenceInfoId", (Object)infoId));
            value.set("recurrenceRuleId", (Object)ruleId);
            value.set("startDateTime", (Object)new Timestamp(startTime));
            delegator.create(value);
            RecurrenceInfo newInfo = new RecurrenceInfo(value);
            return newInfo;
        }
        catch (RecurrenceRuleException re) {
            throw new RecurrenceInfoException(re.getMessage(), (Throwable)((Object)re));
        }
        catch (GenericEntityException ee) {
            throw new RecurrenceInfoException(ee.getMessage(), ee);
        }
        catch (RecurrenceInfoException rie) {
            throw rie;
        }
    }
}

